/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Projection
extends M4Data {
    public static final String M4_TABLE_NAME = "projection_t";
    public static final String ATTRIB_PROJECTION_ID = "pro_id";
    public static final String ATTRIB_FROM_CONCEPT = "pro_fromconid";
    public static final String ATTRIB_TO_CONCEPT = "pro_toconid";
    public static M4Info m4Info = null;
    private Concept fromConcept;
    private Concept toConcept;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_PROJECTION_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[3];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_PROJECTION_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_FROM_CONCEPT, "getFromConcept", "primitiveSetFromConcept", clazz, "NN");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_TO_CONCEPT, "getToConcept", "primitiveSetToConcept", clazz2, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public Projection(DB db) {
        super(db);
    }

    public void print() {
        Concept fromC = this.getFromConcept();
        Concept toC = this.getToConcept();
        this.doPrint(4, "Projection (Id = " + this.getId() + ";" + " From-Concept's ID: " + (fromC == null ? "<none>" : "<" + fromC.getId() + ">") + "; " + " To-Concept's ID: " + (toC == null ? "<none>" : "<" + toC.getId()) + ">" + ")");
    }

    public Concept getFromConcept() {
        return this.fromConcept;
    }

    public Concept getToConcept() {
        return this.toConcept;
    }

    public void setFromConcept(Concept fromConcept) throws M4Exception {
        Collection col;
        if (this.getToConcept() != null && fromConcept != null && (col = Projection.getTransitiveToProjectionsForConcept(this.getToConcept())).contains(fromConcept)) {
            this.setToConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        Concept.con2fromPro.updateReferenceTo(this, fromConcept);
    }

    public void setToConcept(Concept toConcept) throws M4Exception {
        Collection col;
        if (this.getFromConcept() != null && toConcept != null && (col = Projection.getTransitiveToProjectionsForConcept(toConcept)).contains(this.getFromConcept())) {
            this.setFromConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        Concept.con2toPro.updateReferenceTo(this, toConcept);
    }

    public void primitiveSetFromConcept(Concept fromConcept) {
        this.setDirty();
        this.fromConcept = fromConcept;
    }

    public void primitiveSetToConcept(Concept toConcept) {
        this.setDirty();
        this.toConcept = toConcept;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setFromConcept(null);
        this.setToConcept(null);
    }

    static Collection getTransitiveToProjectionsForConcept(Concept startCon) throws M4Exception {
        Vector<Concept> open = new Vector<Concept>();
        HashSet<Concept> closed = new HashSet<Concept>();
        if (startCon != null) {
            open.add(startCon);
        }
        while (!open.isEmpty()) {
            Concept next = (Concept)open.remove(open.size() - 1);
            closed.add(next);
            if (next == null) continue;
            Iterator it = next.getProjectionsAsFromConcept().iterator();
            while (it.hasNext()) {
                Projection pro = (Projection)it.next();
                Concept to = pro.getToConcept();
                if (to == null || open.contains(to) || closed.contains(to)) continue;
                open.add(to);
            }
        }
        return closed;
    }
}

