/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterError;
import edu.udo.miningmart.exception.ParameterNotFoundException;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.ParameterArray;
import edu.udo.miningmart.m4.core.ParameterObject;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;

public class Parameter
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "parameter_t";
    public static final String ATTRIB_PARAMETER_ID = "par_id";
    public static final String ATTRIB_PARAMETER_NAME = "par_name";
    public static final String ATTRIB_OBJECT_ID = "par_objid";
    public static final String ATTRIB_OBJECT_TYPE = "par_objtype";
    public static final String ATTRIB_PAR_IO_TYPE = "par_type";
    public static final String ATTRIB_PAR_LOOP_NR = "par_stloopnr";
    public static final String ATTRIB_PAR_OPERATOR_ID = "par_opid";
    public static final String ATTRIB_PAR_STEP_ID = "par_stid";
    public static final String ATTRIB_PARAMETER_NR = "par_nr";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    public static final short TYPE_VALUE = 0;
    public static final short TYPE_CONCEPT = 1;
    public static final short TYPE_RELATION = 2;
    public static final short TYPE_BASEATTRIBUTE = 3;
    public static final short TYPE_MULTICOLUMNFEATURE = 4;
    public static final short TYPE_FEATURE = 5;
    public static final short TYPE_PARAMETER_OBJECT = 6;
    private static final String[] typeMapping = new String[]{DB.C_VAL, DB.C_CONC, DB.C_REL, DB.C_BA, DB.C_MCF, DB.C_FEA, "*invalid*"};
    private static final Class[] classForType;
    private Step myStep;
    private boolean isInputParam;
    private long objectId;
    private int loopNr;
    private ParameterObject parameterObject;
    private long myParameterNr;
    private ParameterArray paramArray;
    private String parTypeDuringLoad;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        Class[] classArray = new Class[7];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.udo.miningmart.m4.core.Value");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.udo.miningmart.m4.core.Concept");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Relation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("edu.udo.miningmart.m4.core.MultiColumnFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("edu.udo.miningmart.m4.core.Feature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("edu.udo.miningmart.m4.core.ParameterObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz7;
        classForType = classArray;
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_PARAMETER_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[9];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_PARAMETER_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_PARAMETER_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$8;
            if (clazz2 == null) {
                try {
                    clazz2 = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_PAR_IO_TYPE, "getInputParam", "setInputParam", clazz2, "NN");
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_PAR_LOOP_NR, "getLoopNr", "setLoopNr", Integer.TYPE);
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_PARAMETER_NR, "getParamNr", "setParamNr", Long.TYPE, "NN");
            Class<?> clazz3 = class$10;
            if (clazz3 == null) {
                try {
                    clazz3 = class$10 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_PAR_STEP_ID, "getTheStep", "primitiveSetStep", clazz3, "NN");
            Class<?> clazz4 = class$8;
            if (clazz4 == null) {
                try {
                    clazz4 = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry(ATTRIB_OBJECT_TYPE, "getParObjectType", "privateSetParType", clazz4, "NN");
            Class<?> clazz5 = class$11;
            if (clazz5 == null) {
                try {
                    clazz5 = class$11 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[7] = new M4InfoEntry(ATTRIB_OBJECT_ID, "getParObjectId", "readParObjFromDb", clazz5);
            Class<?> clazz6 = class$12;
            if (clazz6 == null) {
                try {
                    clazz6 = class$12 = Class.forName("edu.udo.miningmart.m4.core.Operator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[8] = new M4InfoEntry(ATTRIB_PAR_OPERATOR_ID, "getTheOperator", "setTheOperator", clazz6, "NN");
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[7];
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$8;
            if (clazz2 == null) {
                try {
                    clazz2 = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("InOut", "getInputParam", "setInputParam", clazz2);
            m4InfoEntryArray[2] = new M4InfoEntry("LoopNumber", "getLoopNr", "setLoopNr", Integer.TYPE);
            m4InfoEntryArray[3] = new M4InfoEntry("ParameterNumber", "getParamNr", "setParamNr", Long.TYPE);
            Class<?> clazz3 = class$10;
            if (clazz3 == null) {
                try {
                    clazz3 = class$10 = Class.forName("edu.udo.miningmart.m4.core.Step");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("Step", "getTheStep", "setTheStep", clazz3);
            Class<?> clazz4 = class$6;
            if (clazz4 == null) {
                try {
                    clazz4 = class$6 = Class.forName("edu.udo.miningmart.m4.core.ParameterObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("ParameterObject", "getTheParameterObject", "setTheParameterObject", clazz4);
            Class<?> clazz5 = class$8;
            if (clazz5 == null) {
                try {
                    clazz5 = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz5);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public static short typeConstForTypeString(String parameterType) throws ParameterError {
        int type = -1;
        if (parameterType != null) {
            parameterType = parameterType.trim();
            int i = 0;
            while (i < typeMapping.length && type == -1) {
                if (typeMapping[i].equalsIgnoreCase(parameterType)) {
                    type = i;
                }
                i = (short)(i + 1);
            }
        }
        if (type == -1) {
            throw new ParameterError("Parameter.typeConstForTypeString(String):\n Unsupported parameter type found: " + parameterType);
        }
        return (short)type;
    }

    public static String typeStringForTypeConst(short parameterType) throws ParameterError {
        if (parameterType < 0 || parameterType >= typeMapping.length) {
            throw new ParameterError("Parameter.typeStringForTypeConst(short):\n Unsupported parameter type found: " + parameterType);
        }
        return typeMapping[parameterType];
    }

    public static Class getClassForParameterType(short parameterType) throws ParameterError {
        if (parameterType < 0 || parameterType >= classForType.length) {
            throw new ParameterError("Parameter.getClassForParameterType(short):\n Unsupported parameter type found: " + parameterType);
        }
        return classForType[parameterType];
    }

    public static String getTypeStringForParObject(ParameterObject parameterObject) throws ParameterError {
        if (parameterObject != null) {
            short i = 0;
            while (i < classForType.length) {
                if (classForType[i].isInstance(parameterObject)) {
                    return Parameter.typeStringForTypeConst(i);
                }
                i = (short)(i + 1);
            }
            throw new ParameterError("Unknown type of ParameterObject: " + parameterObject.getClass().getName());
        }
        return null;
    }

    public Parameter(DB db) {
        super(db);
    }

    public void setTheOperator(Operator op) {
    }

    public Operator getTheOperator() throws M4Exception {
        Step step = this.getTheStep();
        if (step != null) {
            return step.getTheOperator();
        }
        return null;
    }

    public void setTheStep(Step step) throws M4Exception {
        Step.step2par.checkNameExists(this, step);
        Step.step2par.updateReferenceTo(this, step);
    }

    public void primitiveSetStep(Step step) {
        this.setDirty();
        this.myStep = step;
    }

    public Step getTheStep() throws M4Exception {
        return this.myStep;
    }

    public boolean isInputParam() {
        return this.isInputParam;
    }

    public String getInputParam() {
        return this.isInputParam ? "IN" : "OUT";
    }

    public void setIsInputParam(boolean is) {
        this.setDirty();
        this.isInputParam = is;
    }

    public void setInputParam(String inputString) {
        this.setIsInputParam(!"OUT".equals(inputString));
    }

    public void setLoopNr(int nr) {
        this.setDirty();
        this.loopNr = nr;
    }

    public int getLoopNr() {
        return this.loopNr;
    }

    public String getParObjectType() throws ParameterError, M4Exception {
        return Parameter.getTypeStringForParObject(this.getTheParameterObject());
    }

    public Long getParObjectId() throws M4Exception {
        ParameterObject parObj = this.getTheParameterObject();
        return parObj == null ? null : new Long(parObj.getId());
    }

    public ParameterObject getTheParameterObject() throws M4Exception {
        return this.parameterObject;
    }

    public void setTheParameterObject(ParameterObject parameterObject) throws M4Exception {
        ParameterObject.parObj2par.updateReferenceTo(this, parameterObject);
    }

    public long getParamNr() {
        return this.myParameterNr;
    }

    public void setParamNr(long paramNr) {
        this.setDirty();
        this.myParameterNr = paramNr;
    }

    public ParameterArray getParamArray() {
        return this.paramArray;
    }

    public void setParamArray(ParameterArray paramArray) throws M4Exception {
        ParameterArray.parArr2par.updateReferenceTo(this, paramArray);
    }

    public void primitiveSetParamArray(ParameterArray paramArray) {
        this.paramArray = paramArray;
    }

    public void primitiveSetParameterObject(ParameterObject paramObj) {
        this.setDirty();
        this.parameterObject = paramObj;
    }

    protected void privateSetParType(String parType) {
        this.parTypeDuringLoad = parType;
    }

    public void print() {
        try {
            if (this.getName() != null) {
                String objectType = this.getParObjectType();
                this.doPrint(5, "Parameter " + this.getName() + "(Id = " + this.getId() + ";" + " Type = " + (objectType == null ? "<null>" : objectType) + "): ");
            }
            this.getTheParameterObject().print();
        }
        catch (M4Exception e) {
            this.doPrint(11, "Warning: Exception caught when trying to print a ParameterObject in Parameter.print():");
            this.doPrint(e);
        }
    }

    protected void readParObjFromDb(Long idL) throws M4Exception {
        String parType = this.parTypeDuringLoad;
        ParameterObject parObject = null;
        if (idL != null && parType != null) {
            try {
                parObject = this.readParameterObjectFromDb(parType, idL);
            }
            catch (ParameterNotFoundException e) {
                String name = this.getName();
                this.doPrint(4, "Invalid ParameterObject-reference detected while loading parameter (Name: " + (name == null ? "<null>" : name) + ", ID: " + this.getId() + ")");
                this.doPrint(4, "Exception when trying to load was " + e.getMessage());
            }
        }
        this.primitiveSetParameterObject(parObject);
        this.parTypeDuringLoad = null;
    }

    private ParameterObject readParameterObjectFromDb(String parObjType, long parObjId) throws M4Exception {
        DB db = this.getM4Db();
        ParameterObject parObject = null;
        short type = Parameter.typeConstForTypeString(parObjType);
        Class c = Parameter.getClassForParameterType(type);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("edu.udo.miningmart.m4.core.ParameterObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(c)) {
            throw new M4Exception("Internal Compiler Error in Parameter.readParameterObjectFromDb():\nClass provided (" + c.getName() + ") is no subclass of ParameterObject!");
        }
        parObject = (ParameterObject)db.getM4Object(parObjId, c);
        if (parObject == null) {
            Step s = this.getTheStep();
            throw new ParameterNotFoundException("M4 Database: Parameter " + this.getName() + " for Step " + (s == null ? "<null>" : "(Name: " + s.getName() + ", ID: " + s.getId()) + " not found");
        }
        return parObject;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheStep(null);
        this.setTheParameterObject(null);
        this.setParamArray(null);
        this.removeDocObject();
    }
}

