/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.ParameterNotFoundException;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.InterM4MCFeatureBaseAttribute;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class MultiColumnFeature
extends Feature
implements XmlInfo {
    public static final String M4_TABLE_NAME = "mcfeature_t";
    public static final String ATTRIB_MCF_ID = "mcf_id";
    public static final String ATTRIB_MCF_NAME = "mcf_name";
    public static final String ATTRIB_MCF_CONCEPT = "mcf_conid";
    static final InterM4Communicator mcf2ba = new InterM4MCFeatureBaseAttribute();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Concept myConcept;
    private final Vector myAttribs = new Vector();
    private boolean allBaseAttributesLoaded = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_MCF_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[3];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_MCF_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_MCF_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_MCF_CONCEPT, "getTheConcept", "primitiveSetConcept", clazz2);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[3];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Concept", "getTheConcept", "setTheConcept", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz3);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public MultiColumnFeature(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Multicolumn Feature " + this.getName() + "(Id = " + this.myId + ")" + " of Concept: " + this.myConcept.getName());
    }

    public Concept getTheConcept() {
        return this.myConcept;
    }

    public void setTheConcept(Concept c) throws M4Exception {
        Concept.con2fea.checkNameExists(this, c);
        Concept.con2fea.updateReferenceTo(this, c);
    }

    public Collection getBaseAttributes() throws M4Exception {
        if (!this.allBaseAttributesLoaded && !this.isNew()) {
            this.allBaseAttributesLoaded = true;
            this.readBaseAttributesForMCFFromDB();
        }
        return this.myAttribs;
    }

    public void setBaseAttributes(Collection theAttribs) throws M4Exception {
        mcf2ba.setCollectionTo(this, theAttribs);
    }

    public boolean hasBaseAttribute(BaseAttribute ba) throws M4Exception {
        Collection bas = this.getBaseAttributes();
        if (ba == null || bas == null) {
            return false;
        }
        return bas.contains(ba);
    }

    public void addBaseAttribute(BaseAttribute ba) throws M4Exception {
        mcf2ba.checkNameExists(ba, this);
        mcf2ba.add(this, ba);
    }

    public BaseAttribute getBaseAttributeByName(String name) throws M4Exception {
        Collection attribs = this.getBaseAttributes();
        Iterator it = attribs.iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            if (!ba.getName().equalsIgnoreCase(name)) continue;
            return ba;
        }
        return null;
    }

    public boolean removeBaseAttribute(BaseAttribute ba) throws M4Exception {
        return mcf2ba.remove(this, ba);
    }

    public MultiColumnFeature copy() throws M4Exception {
        DB dB = this.getM4Db();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.MultiColumnFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MultiColumnFeature ret = (MultiColumnFeature)dB.createNewInstance(clazz);
        ret.setName(this.getName());
        ret.setBaseAttributes(this.getBaseAttributes());
        ret.setTheConcept(this.getTheConcept());
        return ret;
    }

    public boolean isDeselected() throws M4CompilerError {
        Collection bas;
        try {
            bas = this.getBaseAttributes();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Could not read BaseAttributes of MCF with ID " + this.getId() + "!\n" + e.getMessage());
        }
        if (bas != null) {
            Iterator it = bas.iterator();
            while (it.hasNext()) {
                BaseAttribute b = (BaseAttribute)it.next();
                if (b != null && !b.isDeselected()) continue;
                return true;
            }
        }
        return false;
    }

    private void readBaseAttributesForMCFFromDB() throws M4Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator it = this.getObjectsReferencingMe(clazz).iterator();
        while (it.hasNext()) {
            this.addBaseAttribute((BaseAttribute)it.next());
        }
        if (this.getBaseAttributes().size() < 2) {
            throw new ParameterNotFoundException("Found MultiColumnFeature (Id: " + this.getId() + ") with less than 2 BaseAttributes!");
        }
    }

    public void primitiveSetConcept(Concept c) {
        this.setDirty();
        this.myConcept = c;
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setBaseAttributes(new Vector());
        this.setTheConcept(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getBaseAttributes());
        return ret;
    }
}

