/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.KeyMember;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.InterM4KeyKeymember;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Key
extends M4Data
implements XmlInfo {
    private boolean allMembersLoaded = false;
    public static final String M4_TABLE_NAME = "keyhead_t";
    public static final String ATTRIB_HEAD_ID = "kh_id";
    public static final String ATTRIB_HEAD_NAME = "kh_name";
    public static final String ATTRIB_HEAD_PK_CS = "kh_pkcsid";
    public static final String ATTRIB_HEAD_FK_CS = "kh_fkcsid";
    static final InterM4Communicator key2member = new InterM4KeyKeymember();
    private Columnset primaryKeyCS;
    private Columnset foreignKeyCS;
    private Vector theKeyMembers = new Vector();
    private Relation myRelation;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_HEAD_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[4];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_HEAD_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_HEAD_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_HEAD_PK_CS, "getPrimaryKeyColumnSet", "primitiveSetPrimaryKeyColumnset", clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_HEAD_FK_CS, "getForeignKeyColumnSet", "primitiveSetForeignKeyColumnset", clazz3);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[4];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("PrimaryKeyColumnset", "getPrimaryKeyColumnSet", "setPrimaryKeyColumnSet", clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("ForeignKeyColumnset", "getForeignKeyColumnSet", "setForeignKeyColumnSet", clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz4);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Key(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Key " + this.myName + ": Id = " + this.myId + ";");
    }

    public void addMember(KeyMember newMember) throws M4Exception {
        key2member.checkNameExists(newMember, this);
        key2member.add(this, newMember);
        newMember.setThePosition(this.theKeyMembers.size());
    }

    public void removeMemberByPrimaryColumnName(String name) throws M4Exception {
        if (this.getMembers().isEmpty()) {
            return;
        }
        Iterator it = this.getMembers().iterator();
        KeyMember theMemberToBeRemoved = null;
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (!km.getPrimaryKeyColumn().getName().equals(name)) continue;
            theMemberToBeRemoved = km;
        }
        key2member.remove(this, theMemberToBeRemoved);
        this.setPositions();
    }

    public void removeMemberByForeignColumnName(String name) throws M4Exception {
        if (this.getMembers().isEmpty()) {
            return;
        }
        Iterator it = this.getMembers().iterator();
        KeyMember theMemberToBeRemoved = null;
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (!km.getForeignKeyColumn().getName().equals(name)) continue;
            theMemberToBeRemoved = km;
        }
        key2member.remove(this, theMemberToBeRemoved);
        this.setPositions();
    }

    public Collection getMembers() throws M4Exception {
        if (!this.allMembersLoaded && !this.isNew()) {
            this.allMembersLoaded = true;
            this.readKeyMembersFromDb();
        }
        return this.theKeyMembers;
    }

    public void removeMembers() {
        this.theKeyMembers = new Vector();
    }

    public void setMembers(Collection newMembers) throws M4Exception {
        key2member.setCollectionTo(this, newMembers);
        this.setPositions();
    }

    public Columnset getPrimaryKeyColumnSet() {
        return this.primaryKeyCS;
    }

    public void setPrimaryKeyColumnSet(Columnset cs) throws M4Exception {
        Columnset.cspkey.updateReferenceTo(this, cs);
    }

    public void primitiveSetPrimaryKeyColumnset(Columnset cs) {
        this.setDirty();
        this.primaryKeyCS = cs;
    }

    public Columnset getForeignKeyColumnSet() {
        return this.foreignKeyCS;
    }

    public void setForeignKeyColumnSet(Columnset cs) throws M4Exception {
        Columnset.csfkey.updateReferenceTo(this, cs);
    }

    public void primitiveSetForeignKeyColumnset(Columnset cs) {
        this.setDirty();
        this.foreignKeyCS = cs;
    }

    public Column getFirstPrimaryKeyColumn() throws M4Exception {
        Iterator it = this.getMembers().iterator();
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (km.getThePosition() != 1) continue;
            return km.getPrimaryKeyColumn();
        }
        return null;
    }

    public Column getFirstForeignKeyColumn() throws M4Exception {
        Iterator it = this.getMembers().iterator();
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (km.getThePosition() != 1) continue;
            return km.getForeignKeyColumn();
        }
        return null;
    }

    public Relation getRelation() {
        return this.myRelation;
    }

    public void setRelation(Relation rel, boolean isFrom) throws M4Exception {
        if (isFrom) {
            Relation.rel2fromKey.setReciprocalReferences(rel, this);
        } else {
            Relation.rel2toKey.setReciprocalReferences(rel, this);
        }
    }

    public void setRelationPrimitive(Relation r) {
        this.myRelation = r;
    }

    private void readKeyHeadFromDb() throws M4Exception {
        String query = "SELECT kh_name, kh_pkcsid, kh_fkcsid FROM keyhead_t WHERE kh_id = " + this.getId();
        ResultSet rs = null;
        try {
            try {
                Class<?> clazz;
                long l;
                DB db;
                block12: {
                    block11: {
                        rs = this.executeM4SqlRead(query);
                        db = this.getM4Db();
                        if (!rs.next()) break block11;
                        this.setName(rs.getString(ATTRIB_HEAD_NAME));
                        long l2 = rs.getLong(ATTRIB_HEAD_FK_CS);
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.setForeignKeyColumnSet((Columnset)db.getM4Object(l2, clazz2));
                        l = rs.getLong(ATTRIB_HEAD_PK_CS);
                        clazz = class$2;
                        if (clazz != null) break block12;
                        try {
                            clazz = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        break block12;
                    }
                    throw new M4Exception("M4 Database: Key not found (ID: " + this.getId() + ")!");
                }
                this.setPrimaryKeyColumnSet((Columnset)db.getM4Object(l, clazz));
            }
            catch (SQLException sqle) {
                throw new M4Exception("SQL error when reading Key " + this.getId() + ": " + sqle.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var4_7 = null;
        DB.closeResultSet(rs);
    }

    private void readKeyMembersFromDb() throws M4Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.KeyMember");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setMembers(this.getObjectsReferencingMe(clazz));
    }

    private void setPositions() throws M4Exception {
        Iterator it = this.getMembers().iterator();
        int i = 1;
        while (it.hasNext()) {
            ((KeyMember)it.next()).setThePosition(i);
            ++i;
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.setForeignKeyColumnSet(null);
        this.setMembers(new Vector());
        this.setPrimaryKeyColumnSet(null);
        this.setRelation(null, false);
        this.setRelation(null, true);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getMembers());
        if (this.getRelation() != null) {
            ret.add(this.getRelation());
        }
        return ret;
    }
}

