/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ConceptualDatatypes
implements Serializable {
    public static final String M4_TABLE_NAME = "con_datatype_t";
    public static final String ATTRIB_DATATYPE_ID = "condt_id";
    public static final String ATTRIB_DATATYPE_NAME = "condt_name";
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();

    public ConceptualDatatypes(DB db) throws M4Exception, DbConnectionClosed {
        String query = "SELECT condt_id, condt_name FROM con_datatype_t";
        ResultSet rs = null;
        try {
            try {
                rs = db.executeM4SqlRead(query);
                while (rs.next()) {
                    Integer id = new Integer(rs.getInt(ATTRIB_DATATYPE_ID));
                    if (rs.wasNull()) continue;
                    String name = rs.getString(ATTRIB_DATATYPE_NAME);
                    this.idToName.put(id, name);
                    this.nameToId.put(name, id);
                }
            }
            catch (SQLException e) {
                throw new M4Exception("SQLException when trying to read the conceptual datatypes:\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var6_9 = null;
        DB.closeResultSet(rs);
    }

    public long getIdForName(String name) {
        Integer id = (Integer)this.nameToId.get(name);
        if (id != null) {
            return id.longValue();
        }
        return 0L;
    }

    public String getNameForId(long id) {
        Integer idI = new Integer((int)id);
        return (String)this.idToName.get(idI);
    }
}

