/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.ColumnsetStatistics;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.Relation;
import edu.udo.miningmart.m4.utils.InterM4ColumnsetColsetStat;
import edu.udo.miningmart.m4.utils.InterM4ColumnsetColumn;
import edu.udo.miningmart.m4.utils.InterM4ColumnsetForeignKey;
import edu.udo.miningmart.m4.utils.InterM4ColumnsetPrimaryKey;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Columnset
extends M4Data
implements XmlInfo {
    public static final String M4_TABLE_NAME = "columnset_t";
    public static final String ATTRIB_CS_ID = "CS_ID";
    public static final String ATTRIB_CS_SCHEMA = "CS_SCHEMA";
    public static final String ATTRIB_CS_NAME = "CS_NAME";
    public static final String ATTRIB_CS_TYPE = "CS_TYPE";
    public static final String ATTRIB_CS_CONCEPT_ID = "CS_CONID";
    public static final String ATTRIB_CS_MSBRANCH = "CS_MSBRANCH";
    public static final String ATTRIB_CS_SQL = "CS_SQL";
    public static final int MAX_SQLDEF_LENGTH = 3995;
    public static final String CS_TYPE_TABLE = "T";
    public static final String CS_TYPE_VIEW = "V";
    static final InterM4Communicator cs2col = new InterM4ColumnsetColumn();
    static final InterM4Communicator csstat = new InterM4ColumnsetColsetStat();
    static final InterM4Communicator cspkey = new InterM4ColumnsetPrimaryKey();
    static final InterM4Communicator csfkey = new InterM4ColumnsetForeignKey();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Concept myConcept;
    private String mySchema;
    private String myType;
    private String sql;
    private String multiStepBranch;
    private final Vector myColumns = new Vector();
    private boolean allColumnsLoaded = false;
    private Relation myRelation;
    private final Vector myPrimaryKeys = new Vector();
    private boolean allPrimaryKeysLoaded = false;
    private final Vector myForeignKeys = new Vector();
    private boolean allForeignKeysLoaded = false;
    private boolean allStatisticsLoaded = false;
    private final Collection myStatistics = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CS_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[7];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_CS_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_CS_SCHEMA, "getSchema", "setSchema", clazz, "NN");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_CS_NAME, "getName", "setName", clazz2, "NN");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_CS_TYPE, "getType", "setType", clazz3, "NN");
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_CS_MSBRANCH, "getMultiStepBranch", "setMultiStepBranch", clazz4);
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry(ATTRIB_CS_SQL, "getSQLDefinition", "setSQLDefinition", clazz5);
            Class<?> clazz6 = class$2;
            if (clazz6 == null) {
                try {
                    clazz6 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry(ATTRIB_CS_CONCEPT_ID, "getTheConcept", "primitiveSetConcept", clazz6);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[7];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Schema", "getSchema", "setSchema", clazz2);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("Type", "getType", "setType", clazz3);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Concept");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("Concept", "getTheConcept", "setTheConcept", clazz4);
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("SqlDefinition", "getSQLDefinition", "setSQLDefinition", clazz5);
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("MsBranch", "getMultiStepBranch", "setMultiStepBranch", clazz6);
            Class<?> clazz7 = class$1;
            if (clazz7 == null) {
                try {
                    clazz7 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[6] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz7);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Columnset(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(4, "Columnset " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.myType + ") defined in SQL as " + this.sql);
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public void setTheConcept(Concept c) throws M4Exception {
        Concept.con2cs.checkNameExists(this, c);
        Concept.con2cs.updateReferenceTo(this, c);
    }

    public Concept getTheConcept() {
        return this.myConcept;
    }

    public void setSchema(String s) {
        this.setDirty();
        this.mySchema = s;
    }

    public String getSchema() {
        if (this.mySchema == null) {
            return "";
        }
        return this.mySchema;
    }

    public String getSchemaPlusName() {
        String ret = this.getSchema();
        if (ret.length() > 0) {
            ret = String.valueOf(ret) + ".";
        }
        ret = String.valueOf(ret) + this.getName();
        return ret;
    }

    public void setType(String t) throws M4Exception {
        this.setDirty();
        if (!t.equals(CS_TYPE_TABLE) && !t.equals(CS_TYPE_VIEW)) {
            throw new M4Exception("Tried to set unknown type into Columnset '" + this.getName() + "': " + t);
        }
        this.myType = t;
    }

    public String getType() {
        return this.myType;
    }

    public void setSQLDefinition(String sqlDefinition) {
        this.setDirty();
        if (sqlDefinition != null) {
            if ((sqlDefinition = sqlDefinition.trim()).length() == 0 || sqlDefinition.equals(this.getName()) || sqlDefinition.equals(this.getSchemaPlusName())) {
                sqlDefinition = null;
            } else if (!sqlDefinition.startsWith("(") || !sqlDefinition.endsWith(")")) {
                sqlDefinition = "(" + sqlDefinition + ")";
            }
        }
        this.sql = sqlDefinition;
    }

    public String getSQLDefinition() {
        if (this.sql == null) {
            return this.getSchemaPlusName();
        }
        return this.sql;
    }

    public String getCompleteSQLQuery() throws M4Exception {
        return this.getCompleteSQLQuery(null);
    }

    public String getCompleteSQLQuery(String rowNumName) throws M4Exception {
        Collection theColumns = this.getColumns();
        if (theColumns == null) {
            throw new M4Exception("Columnset.getCompleteSQLQuery: No columns found for Columnset " + (this.getName() != null ? "'" + this.getName() + "' " : "") + "(Id: " + this.getId());
        }
        Iterator it = theColumns.iterator();
        StringBuffer sbuf = new StringBuffer("SELECT " + (rowNumName == null ? "" : "ROWNUM AS " + rowNumName + ", "));
        while (it.hasNext()) {
            Column column = (Column)it.next();
            String sqlDef = column.getSQLDefinition();
            String colName = column.getName();
            sbuf.append(sqlDef);
            if (!sqlDef.equals(colName)) {
                sbuf.append(" AS " + colName);
            }
            sbuf.append(", ");
        }
        String sql = String.valueOf(sbuf.substring(0, sbuf.length() - 2)) + " FROM " + this.getSchemaPlusName();
        return sql;
    }

    public void setMultiStepBranch(String branchDefinition) {
        this.setDirty();
        this.multiStepBranch = branchDefinition;
    }

    public String getMultiStepBranch() {
        return this.multiStepBranch;
    }

    public void addMultiStepBranchInfo(String oldDef, String attribute, String value) throws M4Exception {
        if (attribute == null || value == null || this.getMSBranchSelectionValue(attribute) != null) {
            this.setMultiStepBranch(oldDef == null ? "" : oldDef);
        } else {
            String extension = String.valueOf(attribute.trim()) + "=" + value.trim() + ";";
            this.setMultiStepBranch(oldDef == null ? extension : String.valueOf(oldDef) + extension);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addMultiStepBranch(String branch) throws M4Exception {
        if (branch != null) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            first = branch.substring(0, idx);
            branch = branch.substring(idx + 1);
            eqIdx = first.indexOf(61);
            if (eqIdx == -1) {
                throw new M4Exception("Columnset.addMultiStepBranch(String): Could not parse substring '" + first + "' !");
            }
            attribute = first.substring(0, eqIdx);
            value = first.substring(eqIdx + 1);
            this.addMultiStepBranchInfo(this.getMultiStepBranch(), attribute, value);
lbl11:
            // 2 sources

            ** while ((idx = branch.indexOf((int)59)) != -1)
        }
lbl12:
        // 1 sources

    }

    public void setColumns(Collection theColumns) throws M4Exception {
        cs2col.setCollectionTo(this, theColumns);
    }

    public boolean hasColumn(Column col) throws M4Exception {
        Collection columns = this.getColumns();
        if (col == null || columns == null) {
            return false;
        }
        return columns.contains(col);
    }

    public Collection getColumns() throws M4Exception {
        if (!this.allColumnsLoaded && !this.isNew()) {
            this.allColumnsLoaded = true;
            this.readColumnsForColumnsetFromDB();
        }
        return this.myColumns;
    }

    public void setColumn(int index, Column c) throws M4Exception {
        if (this.getColumns() == null || index <= -1 || index >= this.myColumns.size()) {
            throw new M4Exception("Illegal Index for Column in ColumnSet (ColumnSet.setColumn())!");
        }
        Column oldCol = (Column)this.myColumns.get(index);
        this.myColumns.set(index, c);
        cs2col.updateReferenceTo(oldCol, null);
        cs2col.updateReferenceTo(c, this);
    }

    public Column getColumn(int index) throws M4Exception {
        if (index > -1 && index < this.myColumns.size()) {
            return (Column)this.myColumns.get(index);
        }
        throw new M4Exception("Illegal Index for Column in ColumnSet (ColumnSet.getColumn())!");
    }

    public Collection getPrimaryKeys() throws M4Exception {
        if (!this.allPrimaryKeysLoaded && !this.isNew()) {
            this.allPrimaryKeysLoaded = true;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Key");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection pks = this.getObjectsReferencingMe(clazz, "kh_pkcsid");
            cspkey.setCollectionTo(this, pks);
        }
        return this.myPrimaryKeys;
    }

    public Collection getForeignKeys() throws M4Exception {
        if (!this.allForeignKeysLoaded && !this.isNew()) {
            this.allForeignKeysLoaded = true;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Key");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection fks = this.getObjectsReferencingMe(clazz, "kh_fkcsid");
            csfkey.setCollectionTo(this, fks);
        }
        return this.myForeignKeys;
    }

    public Collection getStatistics() throws M4Exception {
        if (!this.allStatisticsLoaded && !this.isNew()) {
            this.allStatisticsLoaded = true;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.ColumnsetStatistics");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection stats = this.getObjectsReferencingMe(clazz);
            csstat.setCollectionTo(this, stats);
        }
        return this.myStatistics;
    }

    /*
     * WARNING - void declaration
     */
    private ColumnsetStatistics getStatTuple() throws M4Exception {
        void var2_2;
        ColumnsetStatistics ret;
        Collection col = this.getStatistics();
        if (col == null || col.size() == 0) {
            DB dB = this.getM4Db();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.ColumnsetStatistics");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ret = (ColumnsetStatistics)dB.createNewInstance(clazz);
            csstat.add(this, ret);
        } else if (col instanceof Vector) {
            ret = (ColumnsetStatistics)((Vector)col).get(0);
        } else {
            return (ColumnsetStatistics)col.iterator().next();
        }
        return var2_2;
    }

    public void setStatisticsAll(int sa) throws M4Exception {
        this.getStatTuple().setNrOfAllTuples(new Integer(sa));
    }

    public int getStatisticsAll() throws M4Exception {
        Integer i = this.getStatTuple().getNrOfAllTuples();
        return i == null ? 0 : i;
    }

    public void setStatisticsNominal(int sn) throws M4Exception {
        this.getStatTuple().setNrOfNomAttribs(new Integer(sn));
    }

    public int getStatisticsNominal() throws M4Exception {
        Integer i = this.getStatTuple().getNrOfNomAttribs();
        return i == null ? 0 : i;
    }

    public void setStatisticsOrdinal(int so) throws M4Exception {
        this.getStatTuple().setNrOfOrdAttribs(new Integer(so));
    }

    public int getStatisticsOrdinal() throws M4Exception {
        Integer i = this.getStatTuple().getNrOfOrdAttribs();
        return i == null ? 0 : i;
    }

    public void setStatisticsTime(int st) throws M4Exception {
        this.getStatTuple().setNrOfTimeAttribs(new Integer(st));
    }

    public int getStatisticsTime() throws M4Exception {
        Integer i = this.getStatTuple().getNrOfTimeAttribs();
        return i == null ? 0 : i;
    }

    public void addColumn(Column c) throws M4Exception {
        cs2col.checkNameExists(c, this);
        cs2col.add(this, c);
    }

    public boolean removeColumn(Column column) throws M4Exception {
        Collection columns = this.getColumns();
        if (column == null || columns == null) {
            return false;
        }
        boolean ret = columns.remove(column);
        if (ret && column.getColumnset() == this) {
            column.setColumnset(null);
        }
        return ret;
    }

    public String getMSBranchSelectionValue(String attributeName) throws M4Exception {
        int startIdx = Columnset.indexOfMsbAttribute(this.getMultiStepBranch(), attributeName);
        if (startIdx == -1) {
            return null;
        }
        int stopIdx = this.getMultiStepBranch().indexOf(59, startIdx += attributeName.length() + 1);
        if (stopIdx == -1) {
            throw new M4Exception("MultiStepBranch-Information of ColumnSet " + this.getId() + " for attribute " + attributeName + " not properly ended by ';' !");
        }
        return this.getMultiStepBranch().substring(startIdx, stopIdx);
    }

    public String getMsbInfoWithoutAttrib(String attributeName) throws M4Exception {
        String s = this.getMultiStepBranch();
        int startIdx = Columnset.indexOfMsbAttribute(s, attributeName);
        if (startIdx == -1) {
            return s;
        }
        int stopIdx = s.indexOf(59, startIdx);
        if (stopIdx == -1) {
            throw new M4Exception("MultiStepBranch-Information of ColumnSet " + this.getId() + " for attribute " + attributeName + " not properly ended by ';' !");
        }
        String pre = s.substring(0, startIdx);
        String post = s.substring(stopIdx + 1);
        return String.valueOf(pre) + post;
    }

    private static int indexOfMsbAttribute(String msbString, String attributeName) {
        if (msbString == null || attributeName == null) {
            return -1;
        }
        String searchString = String.valueOf(attributeName.toLowerCase()) + "=";
        String lc = msbString.toLowerCase();
        if (lc.startsWith(searchString)) {
            return 0;
        }
        int startIdx = lc.indexOf(searchString = ";" + searchString);
        if (startIdx != -1) {
            return startIdx + 1;
        }
        return -1;
    }

    public String readOrComputeCount() throws M4Exception {
        Integer count = this.getStatTuple().getNrOfAllTuples();
        if (count == null) {
            String query = "SELECT COUNT(*) FROM " + this.getSchemaPlusName();
            String newCount = this.executeBusinessSingleValueSqlRead(query);
            if (newCount == null) {
                throw new M4Exception("Could not compute count for columnset '" + this.getName() + "'!");
            }
            count = new Integer(newCount);
            this.getStatTuple().setNrOfAllTuples(count);
        }
        return count.toString();
    }

    public void updateStatistics() throws M4Exception {
        csstat.setCollectionTo(this, new Vector(0));
        ColumnsetStatistics csstat = this.getStatTuple();
        csstat.update();
    }

    private void readColumnsForColumnsetFromDB() throws M4Exception {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setColumns(this.getObjectsReferencingMe(clazz));
    }

    public void primitiveSetConcept(Concept concept) {
        this.setDirty();
        this.myConcept = concept;
    }

    public Relation getRelation() {
        return this.myRelation;
    }

    public void setRelation(Relation newRelation) throws M4Exception {
        Relation.rel2cs.setReciprocalReferences(newRelation, this);
    }

    public void setRelationPrimitive(Relation r) {
        this.setDirty();
        this.myRelation = r;
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector(0);
        this.setTheConcept(null);
        this.setRelation(null);
        this.setColumns(empty);
        csstat.setCollectionTo(this, empty);
        cspkey.setCollectionTo(this, empty);
        csfkey.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getStatistics());
        ret.addAll(this.getColumns());
        ret.addAll(this.getPrimaryKeys());
        ret.addAll(this.getForeignKeys());
        Relation relation = this.getRelation();
        if (relation != null) {
            ret.add(relation);
        }
        return ret;
    }
}

