/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.m4.core;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.exception.MiningMartException;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.ColumnStatistics1;
import edu.udo.miningmart.m4.core.ColumnStatistics2;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.RelationalDatatypes;
import edu.udo.miningmart.m4.utils.InterM4ColumnColumnStatist1;
import edu.udo.miningmart.m4.utils.InterM4ColumnColumnStatist2;
import edu.udo.miningmart.m4.utils.InterM4ColumnForeignKeyMember;
import edu.udo.miningmart.m4.utils.InterM4ColumnPrimaryKeyMember;
import edu.udo.miningmart.m4.utils.InterM4Communicator;
import edu.udo.miningmart.m4.utils.M4Info;
import edu.udo.miningmart.m4.utils.M4InfoEntry;
import edu.udo.miningmart.m4.utils.XmlInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

public class Column
extends M4Data
implements XmlInfo {
    static final InterM4Communicator colCstat1 = new InterM4ColumnColumnStatist1();
    static final InterM4Communicator colCstat2 = new InterM4ColumnColumnStatist2();
    static final InterM4Communicator colPkMem = new InterM4ColumnPrimaryKeyMember();
    static final InterM4Communicator colFkMem = new InterM4ColumnForeignKeyMember();
    public static final String M4_TABLE_NAME = "column_t";
    public static final String ATTRIB_COLUMN_ID = "COL_ID";
    public static final String ATTRIB_COLUMN_NAME = "COL_NAME";
    public static final String ATTRIB_COLUMNSET_ID = "COL_CSID";
    public static final String ATTRIB_COLUMN_DATATYPE = "COL_COLDTID";
    public static final String ATTRIB_COLUMN_SQL = "COL_SQL";
    public static final String M4_TABLE_COL_BA = "ba_column_t";
    public static final String ATTRIB_COL_BA_TUPLE_ID = "bac_id";
    public static final String ATTRIB_COL_BA_COLID = "bac_colid";
    public static final String ATTRIB_COL_BA_BAID = "bac_baid";
    private static RelationalDatatypes dataTypeMapping = null;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private BaseAttribute myBaseAttribute;
    private Columnset myColumnSet;
    private long dataType;
    private String dataTypeName;
    private String sql;
    private boolean allBasicStatisticsLoaded = false;
    private final Vector myBasicStatistics = new Vector();
    private boolean allDistribStatisticsLoaded = false;
    private final Vector myDistribStatistics = new Vector();
    private final Vector myPrimaryKeyMembers = new Vector();
    private boolean allPrimaryKeyMembersLoaded = false;
    private final Vector myForeignKeyMembers = new Vector();
    private boolean allForeignKeyMembersLoaded = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    private RelationalDatatypes getRelationalDatatypeMapping(DB db) throws M4Exception, DbConnectionClosed {
        if (dataTypeMapping == null) {
            dataTypeMapping = new RelationalDatatypes(db);
        }
        return dataTypeMapping;
    }

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_COLUMN_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[5];
            m4InfoEntryArray[0] = new M4InfoEntry(ATTRIB_COLUMN_ID, "getId", "setId", Long.TYPE, "NN");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry(ATTRIB_COLUMN_NAME, "getName", "setName", clazz, "NN");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry(ATTRIB_COLUMNSET_ID, "getColumnset", "primitiveSetColumnset", clazz2);
            m4InfoEntryArray[3] = new M4InfoEntry(ATTRIB_COLUMN_DATATYPE, "getColumnDataType", "setColumnDataType", Long.TYPE, "NN");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry(ATTRIB_COLUMN_SQL, "getSQLDefinition", "setSQLDefinition", clazz3);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4InfoEntryArray = new M4InfoEntry[6];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[0] = new M4InfoEntry("Name", "getName", "setName", clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Columnset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[1] = new M4InfoEntry("Columnset", "getColumnset", "setColumnset", clazz2);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[2] = new M4InfoEntry("BaseAttribute", "getTheBaseAttribute", "setBaseAttribute", clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[3] = new M4InfoEntry("ColDatatype", "getColumnDataTypeName", "setColumnDataTypeName", clazz4);
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[4] = new M4InfoEntry("SqlDefinition", "getSQLDefinition", "setSQLDefinition", clazz5);
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            m4InfoEntryArray[5] = new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", clazz6);
            M4InfoEntry[] m4i = m4InfoEntryArray;
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Column(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        Columnset cs = this.getColumnset();
        String cdt = "[ID: " + this.getColumnDataType() + "]";
        try {
            cdt = this.getColumnDataTypeName();
        }
        catch (MiningMartException miningMartException) {
            // empty catch block
        }
        String colSetName = cs == null ? "<Columnset not set>" : String.valueOf(cs.getSchema()) + "." + cs.getName();
        try {
            this.doPrint(4, "Column " + this.getName() + "(Id = " + this.getId() + ";" + " Type = " + cdt + ") of Columnset " + colSetName + "  defined in SQL as " + this.getSQLDefinition() + "  (Unique: " + this.getNumberOfUniqueValues() + " Missing: " + this.getNumberOfMissingValues() + " Min: " + this.getMinValue() + " Max: " + this.getMaxValue() + " Median: " + this.getMedianValue() + " Modal: " + this.getModalValue() + " Average: " + this.getAverageValue() + " Std. Dev.: " + this.getStandardDeviation() + ")");
        }
        catch (M4Exception m4Exception) {
            // empty catch block
        }
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public Column copyColTo(Columnset cs) throws M4Exception {
        DB dB = this.getM4Db();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Column");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Column ret = (Column)dB.createNewInstance(clazz);
        ret.myId = 0L;
        ret.setName(this.getName());
        ret.setColumnset(cs);
        ret.setBaseAttribute(this.getTheBaseAttribute());
        ret.setColumnDataType(this.getColumnDataType());
        ret.setSQLDefinition(this.getSQLDefinition());
        ret.setAverageValue(this.getAverageValue());
        ret.setVariance(this.getVariance());
        ret.setMaxValue(this.getMaxValue());
        ret.setMedianValue(this.getMedianValue());
        ret.setMinValue(this.getMinValue());
        ret.setModalValue(this.getModalValue());
        ret.setNumberOfMissingValues(this.getNumberOfMissingValues());
        ret.setNumberOfUniqueValues(this.getNumberOfUniqueValues());
        ret.setStandardDeviation(this.getStandardDeviation());
        ret.setDistributionStatistics(this.getDistributionStatistics());
        cs.addColumn(ret);
        return ret;
    }

    public void setBaseAttribute(BaseAttribute ba) throws M4Exception {
        BaseAttribute.ba2col.updateReferenceTo(this, ba);
    }

    public BaseAttribute getTheBaseAttribute() throws M4Exception {
        return this.myBaseAttribute;
    }

    public void setSQLDefinition(String sqlDefinition) {
        this.setDirty();
        this.sql = sqlDefinition == null || sqlDefinition.length() == 0 ? this.getName() : sqlDefinition;
    }

    public String getSQLDefinition() {
        if (this.sql == null) {
            return this.getName();
        }
        return this.sql;
    }

    public String getSQLPlusLocation() {
        String location = this.getColumnset().getSchemaPlusName();
        location = location != null && !location.equals("") ? String.valueOf(location) + "." : "";
        return String.valueOf(location) + this.getSQLDefinition();
    }

    public void setColumnDataType(long type) {
        this.setDirty();
        this.dataType = type;
    }

    public long getColumnDataType() {
        return this.dataType;
    }

    public void setColumnDataTypeName(String dtname) throws DbConnectionClosed, M4Exception {
        long type = this.getRelationalDatatypeMapping(this.getM4Db()).getIdForName(dtname);
        this.setColumnDataType(type);
    }

    public String getColumnDataTypeName() throws DbConnectionClosed, M4Exception {
        long type = this.getColumnDataType();
        return this.getRelationalDatatypeMapping(this.getM4Db()).getNameForId(type);
    }

    public Collection getPrimaryKeyMembers() throws M4Exception {
        if (!this.allPrimaryKeyMembersLoaded && !this.isNew()) {
            this.allPrimaryKeyMembersLoaded = true;
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.KeyMember");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection pkms = this.getObjectsReferencingMe(clazz, "km_pkcolid");
            colPkMem.setCollectionTo(this, pkms);
        }
        return this.myPrimaryKeyMembers;
    }

    public Collection getForeignKeyMembers() throws M4Exception {
        if (!this.allForeignKeyMembersLoaded && !this.isNew()) {
            this.allForeignKeyMembersLoaded = true;
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.udo.miningmart.m4.core.KeyMember");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection fkms = this.getObjectsReferencingMe(clazz, "km_fkcolid");
            colFkMem.setCollectionTo(this, fkms);
        }
        return this.myForeignKeyMembers;
    }

    public Collection getBasicColStats() throws M4Exception {
        if (!this.allBasicStatisticsLoaded && !this.isNew()) {
            this.allBasicStatisticsLoaded = true;
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection references = this.getObjectsReferencingMe(clazz);
            colCstat1.setCollectionTo(this, references);
        }
        return this.myBasicStatistics;
    }

    private ColumnStatistics1 getBasicStat() throws M4Exception {
        Collection col = this.getBasicColStats();
        ColumnStatistics1 ret = null;
        if (col != null && col.size() >= 1) {
            ret = col instanceof Vector ? (ColumnStatistics1)((Vector)col).get(0) : (ColumnStatistics1)col.iterator().next();
        } else {
            DB dB = this.getM4Db();
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ret = (ColumnStatistics1)dB.createNewInstance(clazz);
            colCstat1.add(this, ret);
        }
        return ret;
    }

    public Collection getDistributionStatistics() throws M4Exception {
        if (!this.allDistribStatisticsLoaded && !this.isNew()) {
            this.allDistribStatisticsLoaded = true;
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Collection references = this.getObjectsReferencingMe(clazz);
            colCstat2.setCollectionTo(this, references);
        }
        return this.myDistribStatistics;
    }

    public void setDistributionStatistics(Collection dStats) throws M4Exception {
        if (dStats == null) {
            dStats = new Vector();
        }
        colCstat2.setCollectionTo(this, dStats);
    }

    public int getNumberOfUniqueValues() throws M4Exception {
        Integer i = this.getBasicStat().getNrOfUniqueValuesI();
        return i == null ? 0 : i;
    }

    public int getNumberOfMissingValues() throws M4Exception {
        Integer i = this.getBasicStat().getNrOfMissingValuesI();
        return i == null ? 0 : i;
    }

    public String getMinValue() throws M4Exception {
        return this.getBasicStat().getMinimum();
    }

    public String getMaxValue() throws M4Exception {
        return this.getBasicStat().getMaximum();
    }

    public String getMedianValue() throws M4Exception {
        return this.getBasicStat().getMedian();
    }

    public String getModalValue() throws M4Exception {
        return this.getBasicStat().getModal();
    }

    public String getAverageValue() throws M4Exception {
        Double doub = this.getBasicStat().getAverageD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    public String getStandardDeviation() throws M4Exception {
        Double doub = this.getBasicStat().getStandardDeviationD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    public String getVariance() throws M4Exception {
        Double doub = this.getBasicStat().getVarianceD();
        if (doub == null) {
            return null;
        }
        return doub.toString();
    }

    protected void setNumberOfUniqueValues(int nuv) throws M4Exception {
        this.getBasicStat().setNrOfUniqueValues(new Integer(nuv));
    }

    protected void setNumberOfMissingValues(int nmv) throws M4Exception {
        this.getBasicStat().setNrOfMissingValues(new Integer(nmv));
    }

    protected void setMinValue(String min) throws M4Exception {
        this.getBasicStat().setMinimum(min);
    }

    protected void setMaxValue(String max) throws M4Exception {
        this.getBasicStat().setMaximum(max);
    }

    protected void setMedianValue(String med) throws M4Exception {
        this.getBasicStat().setMedian(med);
    }

    protected void setModalValue(String mod) throws M4Exception {
        this.getBasicStat().setModal(mod);
    }

    protected void setAverageValue(String avg) throws M4Exception {
        Double v = null;
        if (avg != null && avg.trim().length() > 0) {
            v = new Double(avg);
        }
        this.getBasicStat().setAverage(v);
    }

    protected void setStandardDeviation(String stddev) throws M4Exception {
        Double v = null;
        if (stddev != null && stddev.trim().length() > 0) {
            v = new Double(stddev);
        }
        this.getBasicStat().setStandardDeviation(v);
    }

    protected void setVariance(String var) throws M4Exception {
        Double v = null;
        if (var != null && var.trim().length() > 0) {
            v = new Double(var);
        }
        this.getBasicStat().setVariance(v);
    }

    public Columnset getColumnset() {
        return this.myColumnSet;
    }

    public void setColumnset(Columnset cs) throws M4Exception {
        Columnset.cs2col.checkNameExists(this, cs);
        Columnset.cs2col.updateReferenceTo(this, cs);
    }

    public String readOrComputeMinimum() throws M4Exception {
        String min = this.getMinValue();
        if (min == null) {
            Columnset cs = this.getColumnset();
            String query = "SELECT MIN(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            min = this.executeBusinessSingleValueSqlRead(query);
            if (min == null) {
                throw new M4Exception("Could not compute minimum for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setMinValue(min);
        }
        return min;
    }

    public String readOrComputeAverage() throws M4Exception {
        String avg = this.getAverageValue();
        if (avg == null) {
            Columnset cs = this.getColumnset();
            String query = "SELECT AVG(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            avg = this.executeBusinessSingleValueSqlRead(query);
            if (avg == null) {
                throw new M4Exception("Could not compute average value for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setAverageValue(avg);
        }
        return avg;
    }

    public String readOrComputeMaximum() throws M4Exception {
        String max = this.getMaxValue();
        if (max == null) {
            Columnset cs = this.getColumnset();
            String query = "SELECT MAX(" + this.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            max = this.executeBusinessSingleValueSqlRead(query);
            if (max == null) {
                throw new M4Exception("Could not compute minimum for column '" + this.getName() + "', M4 id " + this.getId() + " in columnset '" + cs.getName() + "'!");
            }
            this.setMaxValue(max);
        }
        return max;
    }

    public void updateStatistics(long conceptualDataType) throws M4Exception {
        block10: {
            colCstat1.setCollectionTo(this, new Vector(0));
            colCstat2.setCollectionTo(this, new Vector(0));
            try {
                Long numMissing;
                String csName = this.getColumnset().getSchemaPlusName();
                String colSql = this.getSQLDefinition().trim();
                long colDt = this.getColumnDataType();
                long conDt = this.getTheBaseAttribute().getConceptualDataType();
                Long numDistinct = this.executeBusinessSingleValueSqlReadL("SELECT COUNT(DISTINCT " + colSql + ")" + " FROM " + csName);
                if (numDistinct != null) {
                    this.setNumberOfUniqueValues(numDistinct.intValue());
                }
                if ((numMissing = this.executeBusinessSingleValueSqlReadL("SELECT COUNT(*) FROM " + csName + " WHERE (" + colSql + ") IS NULL")) != null) {
                    this.setNumberOfMissingValues(numMissing.intValue());
                }
                if (conDt == 3L || conDt == 5L || conDt == 6L) break block10;
                Long rowCountL = this.executeBusinessSingleValueSqlReadL("SELECT COUNT(*) FROM " + csName + " WHERE NOT (" + colSql + ") IS NULL");
                long rowCount = rowCountL == null ? 0L : rowCountL;
                switch ((short)colDt) {
                    case 12: {
                        this.updateOrdinalValueStatistics(rowCount);
                        break;
                    }
                    case 13: {
                        this.updateNominalValueStatistics(rowCount);
                        break;
                    }
                    case 14: {
                        this.updateTimeValueStatistics(rowCount);
                        break;
                    }
                    case 15: {
                        this.updateNominalValueStatistics(rowCount);
                        break;
                    }
                    default: {
                        throw new M4CompilerError("Invalid Column Datatype '" + colDt + "' in CompilerDatabaseService.updateStatistics!");
                    }
                }
            }
            catch (M4CompilerError m4e) {
                throw new M4Exception("M4 error when updating statistics: " + m4e.getMessage());
            }
        }
    }

    private void updateOrdinalValueStatistics(long rowCount) throws M4Exception {
        try {
            ResultSet rs;
            block17: {
                String csName = this.getColumnset().getSchemaPlusName();
                String colSql = this.getSQLDefinition().trim();
                String minVal = this.readOrComputeMinimum();
                String maxVal = this.readOrComputeMaximum();
                this.readOrComputeAverage();
                rs = null;
                try {
                    try {
                        String que = "SELECT ROUND(STDDEV(" + colSql + "),5), " + " ROUND(MOD(VARIANCE(" + colSql + "),100000000000000000000000000000000000000),5) " + " FROM " + csName;
                        rs = this.executeBusinessSqlRead(que);
                        if (rs.next()) {
                            double stddevVal = rs.getDouble(1);
                            if (!rs.wasNull()) {
                                this.setStandardDeviation(Double.toString(stddevVal));
                            }
                            double varVal = rs.getDouble(2);
                            if (!rs.wasNull()) {
                                this.setVariance(Double.toString(varVal));
                            }
                        }
                        rs.close();
                        rs = null;
                        if (minVal == null || maxVal == null || minVal.equals(maxVal)) break block17;
                        que = "SELECT AVG(" + colSql + ")," + " COUNT(*), " + " MIN(" + colSql + ")," + " MAX(" + colSql + ") " + " FROM " + csName + " WHERE NOT (" + colSql + ") IS NULL " + " GROUP BY ROUND((" + colSql + " - " + minVal + ")" + " / (" + maxVal + " - " + minVal + ") * 10)" + " ORDER BY AVG(" + colSql + ")";
                        double modalCount = 0.0;
                        double medianSum = 0.0;
                        String modalVal = "NULL";
                        String medianVal = "NULL";
                        rs = this.executeBusinessSqlRead(que);
                        while (rs.next()) {
                            DB dB = this.getM4Db();
                            Class<?> clazz = class$7;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics2");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            ColumnStatistics2 csstat2 = (ColumnStatistics2)dB.createNewInstance(clazz);
                            csstat2.setTheColumn(this);
                            csstat2.setDistributionValue(rs.getString(1));
                            csstat2.setDistributionCount((int)rs.getLong(2));
                            double d = rs.getDouble(3);
                            if (!rs.wasNull()) {
                                csstat2.setDistributionMinimum(d);
                            }
                            d = rs.getDouble(4);
                            if (!rs.wasNull()) {
                                csstat2.setDistributionMaximum(d);
                            }
                            if ((double)csstat2.getDistributionCount() > modalCount) {
                                modalCount = csstat2.getDistributionCount();
                                modalVal = csstat2.getDistributionValue();
                            }
                            if (medianSum <= (double)(rowCount / 2L) && (double)(rowCount / 2L) <= medianSum + (double)csstat2.getDistributionCount()) {
                                medianVal = csstat2.getDistributionValue();
                            }
                            medianSum += (double)csstat2.getDistributionCount();
                        }
                        this.setModalValue(modalVal);
                        this.setMedianValue(medianVal);
                    }
                    catch (SQLException e) {
                        throw new M4CompilerError("Column.updateOrdinalValueStatistics(Column ID: " + this.getId() + ") :" + e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var18_17 = null;
                    DB.closeResultSet(rs);
                    throw throwable;
                }
            }
            Object var18_18 = null;
            DB.closeResultSet(rs);
        }
        catch (M4CompilerError m4e) {
            throw new M4Exception("M4 error when updating statistics: " + m4e.getMessage());
        }
    }

    private void updateNominalValueStatistics(long rowCount) throws M4Exception {
        String csName = this.getColumnset().getSchemaPlusName();
        String colSql = this.getSQLDefinition().trim();
        long colId = this.getId();
        ResultSet rs = null;
        try {
            try {
                String que = "SELECT (" + colSql + "), " + " COUNT(*) FROM " + csName + " WHERE (" + colSql + ") IS NOT NULL" + " GROUP BY (" + colSql + ")";
                double modalCount = 0.0;
                String modalVal = "NULL";
                rs = this.executeBusinessSqlRead(que);
                while (rs.next()) {
                    String attrName = rs.getString(1);
                    if (rs.wasNull()) {
                        attrName = "NULL";
                    }
                    long attrCount = rs.getLong(2);
                    DB dB = this.getM4Db();
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ColumnStatistics2 cstat2 = (ColumnStatistics2)dB.createNewInstance(clazz);
                    cstat2.setTheColumn(this);
                    cstat2.setDistributionValue(attrName);
                    cstat2.setDistributionCount((int)attrCount);
                    if (!((double)attrCount > modalCount)) continue;
                    modalCount = attrCount;
                    modalVal = attrName;
                }
                this.setModalValue(modalVal);
            }
            catch (SQLException e) {
                throw new M4Exception("CompilerDatabaseService.updateOrdinalValueStatistics(Column ID: " + colId + ") :" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var16_15 = null;
        DB.closeResultSet(rs);
    }

    private void updateTimeValueStatistics(long rowCount) throws M4Exception {
        String csName = this.getColumnset().getSchemaPlusName();
        String colSql = this.getSQLDefinition().trim();
        long colId = this.getId();
        ResultSet rs = null;
        try {
            try {
                long monthBetween;
                this.readOrComputeAverage();
                String que = "SELECT MONTHS_BETWEEN(MAX(" + colSql + "), " + " MIN(" + colSql + ")) FROM " + csName;
                Long monthL = this.executeBusinessSingleValueSqlReadL(que);
                long l = monthBetween = monthL == null ? 0L : monthL;
                String distBase = monthBetween > 600L ? "YYYY" : (monthBetween > 60L ? "YYYYQ" : (monthBetween > 3L ? "YYYYMM" : (monthBetween > 0L ? "YYYYMMDD" : "YYYYMMDD")));
                String query = "SELECT TO_CHAR(" + colSql + ", '" + distBase + "')," + " COUNT(*)," + " TO_CHAR(MIN(" + colSql + "), '" + distBase + "')," + " TO_CHAR(MAX(" + colSql + "), '" + distBase + "')" + " FROM " + csName + " WHERE (" + colSql + ") IS NOT NULL" + " GROUP BY TO_CHAR(" + colSql + ", '" + distBase + "')" + " ORDER BY TO_CHAR(" + colSql + ", '" + distBase + "')";
                double modalCount = 0.0;
                double medianSum = 0.0;
                String modalVal = "NULL";
                String medianVal = "NULL";
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    String attrVal = rs.getString(1);
                    if (rs.wasNull()) {
                        attrVal = "NULL";
                    }
                    long attrCount = rs.getLong(2);
                    String attrMin = rs.getString(3);
                    if (rs.wasNull()) {
                        attrMin = "NULL";
                    }
                    String attrMax = rs.getString(4);
                    if (rs.wasNull()) {
                        attrMax = "NULL";
                    }
                    DB dB = this.getM4Db();
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.udo.miningmart.m4.core.ColumnStatistics2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ColumnStatistics2 cstat2 = (ColumnStatistics2)dB.createNewInstance(clazz);
                    cstat2.setTheColumn(this);
                    cstat2.setDistributionValue(attrVal);
                    cstat2.setDistributionCount((int)attrCount);
                    cstat2.setDistributionMinimum(Double.parseDouble(attrMin));
                    cstat2.setDistributionMaximum(Double.parseDouble(attrMax));
                    if ((double)attrCount > modalCount) {
                        modalCount = attrCount;
                        modalVal = attrVal;
                    }
                    if (medianSum <= (double)(rowCount / 2L) && (double)(rowCount / 2L) <= medianSum + (double)attrCount) {
                        medianVal = attrVal;
                    }
                    medianSum += (double)attrCount;
                }
                this.setModalValue(modalVal);
                this.setMedianValue(medianVal);
            }
            catch (SQLException e) {
                throw new M4Exception("CompilerDatabaseService.updateOrdinalValueStatistics(Column ID: " + colId + ") :" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var24_20 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var24_21 = null;
        DB.closeResultSet(rs);
    }

    private void readBaseAttributeForColumnFromDB() throws M4Exception {
        String query = "SELECT bac_baid FROM ba_column_t WHERE bac_colid = " + this.getId();
        Long baId = this.executeM4SingleValueSqlReadL(query);
        BaseAttribute ba = null;
        if (baId != null) {
            DB dB = this.getM4Db();
            long l = baId;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ba = (BaseAttribute)dB.getM4Object(l, clazz);
        }
        this.primitiveSetBaseAttribute(ba);
    }

    public void primitiveSetBaseAttribute(BaseAttribute ba) {
        this.setDirty();
        this.myBaseAttribute = ba;
    }

    public void primitiveSetColumnset(Columnset cs) {
        this.setDirty();
        this.myColumnSet = cs;
    }

    protected void readFromDbLocal() throws M4Exception {
        this.readBaseAttributeForColumnFromDB();
    }

    public void storeLocal() throws M4Exception {
        super.storeLocal();
        String sql = "DELETE FROM ba_column_t WHERE bac_colid = " + this.getId();
        this.executeM4SqlWrite(sql);
        if (this.getTheBaseAttribute() != null) {
            String baId = Long.toString(this.getTheBaseAttribute().getId());
            String sql2 = "INSERT INTO ba_column_t ( bac_id, bac_colid, bac_baid ) VALUES ( " + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + baId + " )";
            this.executeM4SqlWrite(sql2);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector(0);
        colCstat1.setCollectionTo(this, empty);
        colPkMem.setCollectionTo(this, empty);
        colFkMem.setCollectionTo(this, empty);
        this.setDistributionStatistics(null);
        this.setBaseAttribute(null);
        this.setColumnset(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getBasicColStats());
        ret.addAll(this.getDistributionStatistics());
        ret.addAll(this.getPrimaryKeyMembers());
        ret.addAll(this.getForeignKeyMembers());
        return ret;
    }
}

