/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.db;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.db.DbCore;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.Driver;

public class DbCorePostgres
extends DbCore {
    public static final String POSTGRES_TYPE_NUMBER = "NUMERIC";
    public static final String POSTGRES_TYPE_STRING = "VARCHAR";
    public static final String POSTGRES_TYPE_CHAR = "CHAR";
    public static final String POSTGRES_TYPE_DATE = "DATE";
    public static final String POSTGRES_TYPE_TIME = "TIME";
    public static final String POSTGRES_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String POSTGRES_TYPE_TEXT = "TEXT";
    private final String nameOfM4Sequence = "all_sq";
    private final String POSTGRES_COMMAND_INIT_TRANSACTION = "BEGIN";

    public DbCorePostgres(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, "/" + dbName, user, passwd, cal, isM4Schema);
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
    }

    public short getDbms() {
        return 2;
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        con.setAutoCommit(false);
        this.openTransactionBlock();
    }

    public void commitTransactions() throws SQLException {
        super.commitTransactions();
        this.openTransactionBlock();
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String query = "select nextval('" + "all_sq" + "')";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invocation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCorePostgres.getNextM4SequenceValue(Statement):\nSequence 'all_sq' did not return a value!" + sqle;
            throw new M4Exception(msg);
        }
        return nextval;
    }

    public String getSelectStringAllTables() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='r'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getUser() != null) {
            ret = String.valueOf(ret) + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getUser() + "'";
        }
        return ret;
    }

    public String getSelectStringAllViews() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='v'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getUser() != null) {
            ret = String.valueOf(ret) + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getUser() + "'";
        }
        return ret;
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT attname, typname FROM pg_attribute, pg_type, pg_class WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "'";
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT typname FROM pg_attribute, pg_type, pg_class, pg_user WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND relowner = pg_user.usesysid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "' AND attname = '" + columnName.toLowerCase() + "'";
        if (owner != null) {
            ret = String.valueOf(ret) + " AND usename = '" + owner.toLowerCase() + "'";
        }
        return ret;
    }

    public String getAttributeForColumnNames() {
        return "attname";
    }

    public String getAttributeForColumnTypes() {
        return "typname";
    }

    public String getUniqueRowIdentifier() {
        return "oid";
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals("NUMBER")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(POSTGRES_TYPE_DATE)) {
            ret = POSTGRES_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = POSTGRES_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = String.valueOf(ret) + "(" + size + ")";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(POSTGRES_TYPE_NUMBER)) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("FLOAT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_DATE)) {
            return POSTGRES_TYPE_DATE;
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_TEXT)) {
            return "STRING";
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws SQLException {
        ResultSet rs;
        boolean tableExists;
        block10: {
            String sql_test = "SELECT * FROM " + tableName;
            tableExists = true;
            rs = null;
            try {
                try {
                    this.commitTransactions();
                    rs = this.executeSqlRead(sql_test);
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("does not exist") > -1) {
                        this.commitTransactions();
                        tableExists = false;
                        break block10;
                    }
                    throw new SQLException("Error trying to access business table '" + tableName + "': " + sqle.getMessage());
                }
                catch (DbConnectionClosed dbe) {
                    throw new SQLException("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        Object var6_10 = null;
        DB.closeResultSet(rs);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new SQLException("Error trying to remove the business table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new SQLException("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    private void openTransactionBlock() throws SQLException {
        try {
            this.executeSqlWrite("BEGIN");
        }
        catch (DbConnectionClosed d) {
            throw new SQLException("Problem in DbCorePostgres.commitTransactions: DbConnectionClosed exception caught: " + d.getMessage());
        }
    }

    public String getTestQuery() {
        return this.getSelectStringAllTables();
    }
}

