/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.db;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.db.DbCore;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleDriver;

public class DbCoreOracle
extends DbCore {
    public static final String ORACLE_TYPE_NUMBER = "NUMBER";
    public static final String ORACLE_TYPE_STRING = "VARCHAR2";
    public static final String ORACLE_TYPE_DATE = "DATE";
    public static final String ORACLE_TYPE_CHAR = "CHAR";

    public DbCoreOracle(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, dbName, user, passwd, cal, isM4Schema);
    }

    public short getDbms() {
        return 1;
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        con.setAutoCommit(false);
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String query = "select all_sq.nextval from dual";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invokation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCore.getNextM4SequenceValue(Statement):\nSequence 'all_sq.nextval' did not return a value!" + sqle;
            throw new M4Exception(msg);
        }
        return nextval;
    }

    public String getSelectStringAllTables() {
        return "SELECT UPPER(TABLE_NAME) FROM USER_TABLES";
    }

    public String getSelectStringAllViews() {
        return "SELECT UPPER(VIEW_NAME) FROM USER_VIEWS";
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT column_name, data_type FROM USER_TAB_COLUMNS WHERE table_name = '" + dbObjectName.toUpperCase() + "'";
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT data_type FROM ALL_TAB_COLUMNS WHERE table_name = '" + dbObjectName.toUpperCase() + "' AND column_name = '" + columnName.toUpperCase() + "'";
        if (owner != null) {
            ret = String.valueOf(ret) + " AND owner = '" + owner.toUpperCase() + "'";
        }
        return ret;
    }

    public String getAttributeForColumnNames() {
        return "COLUMN_NAME";
    }

    public String getAttributeForColumnTypes() {
        return "DATA_TYPE";
    }

    public String getUniqueRowIdentifier() {
        return "ROWNUM";
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals(ORACLE_TYPE_NUMBER)) {
            ret = ORACLE_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(ORACLE_TYPE_DATE)) {
            ret = ORACLE_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = ORACLE_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = ORACLE_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = String.valueOf(ret) + "(" + size + ")";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(ORACLE_TYPE_NUMBER)) {
            return ORACLE_TYPE_NUMBER;
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_DATE)) {
            return ORACLE_TYPE_DATE;
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_CHAR)) {
            return "STRING";
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws SQLException {
        ResultSet rs;
        boolean tableExists;
        block10: {
            String sql_test = "SELECT * FROM " + tableName + " WHERE ROWNUM=1";
            tableExists = true;
            rs = null;
            try {
                try {
                    rs = this.executeSqlRead(sql_test);
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("does not exist") > -1 || sqle.getMessage().startsWith("ORA-00942:")) {
                        tableExists = false;
                        break block10;
                    }
                    throw new SQLException("Error trying to access business table '" + tableName + "': " + sqle.getMessage());
                }
                catch (DbConnectionClosed dbe) {
                    throw new SQLException("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        Object var6_10 = null;
        DB.closeResultSet(rs);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new SQLException("Error trying to remove the business table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new SQLException("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    public String getTestQuery() {
        return "SELECT 0 FROM DUAL";
    }
}

