/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.db;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.db.DbCoreOracle;
import edu.udo.miningmart.db.DbCorePostgres;
import edu.udo.miningmart.db.ExtendedResultSet;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import edu.udo.miningmart.m4.utils.Print;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;

public abstract class DbCore {
    public static String DBMS_ORACLE = "Oracle";
    public static String DBMS_POSTGRES = "Postgres";
    private Connection con = null;
    private final HashMap readResultSets = new HashMap();
    private Statement statementWrite;
    private static final int MAX_OPEN_STATEMENTS = 20;
    private final String url;
    private final String user;
    private final String passwd;
    private final boolean refersToM4Schema;
    private final transient M4InterfaceContext cal;

    static DbCore getDbCore(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        String dbms = DbCore.findDBMS(url);
        if (dbms == null) {
            return null;
        }
        if (dbms.equals(DBMS_ORACLE)) {
            return new DbCoreOracle(url, dbName, user, passwd, cal, isM4Schema);
        }
        if (dbms.equals(DBMS_POSTGRES)) {
            return new DbCorePostgres(url, dbName, user, passwd, cal, isM4Schema);
        }
        throw new SQLException("DbCore.getDbCore(): Could not recognize DBMS system!");
    }

    public static String findDBMS(String url) {
        if (url != null) {
            String lowUrl = url.toLowerCase();
            if (lowUrl.indexOf("oracle") >= 0) {
                return DBMS_ORACLE;
            }
            if (lowUrl.indexOf("postgres") >= 0) {
                return DBMS_POSTGRES;
            }
        }
        return null;
    }

    public Print getCasePrintObject() {
        return this.cal.getPrintObject();
    }

    public DbCore(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean refersToM4Schema) throws SQLException {
        this.url = String.valueOf(url) + dbName;
        this.user = user;
        this.passwd = passwd;
        this.refersToM4Schema = refersToM4Schema;
        this.cal = cal;
        this.getFreshConnection();
    }

    public void finalize() throws SQLException {
        this.closeDbStatements();
        if (this.con != null) {
            this.con.close();
            this.con = null;
            this.doPrint(10, "DB disconnected");
        }
    }

    public abstract short getDbms();

    protected abstract void registerJDBC_Driver() throws SQLException;

    protected abstract void switchAutocommitOff(Connection var1) throws SQLException;

    void getFreshConnection() throws SQLException {
        if (this.con != null) {
            this.con.commit();
            this.closeDbStatements();
            this.con.close();
        } else {
            this.registerJDBC_Driver();
        }
        this.con = DriverManager.getConnection(this.url, this.user, this.passwd);
        this.switchAutocommitOff(this.con);
        DatabaseMetaData md = this.con.getMetaData();
        this.doPrint(10, "\n--- Refreshing database connection ---");
        this.doPrint(10, "JDBC-Driver-Version: " + md.getDriverVersion() + "  " + md.getDatabaseProductName());
        this.doPrint(10, "DB-Connection ok");
    }

    String getUrl() {
        return this.url;
    }

    String getUser() {
        return this.user;
    }

    String getPasswd() {
        return this.passwd;
    }

    boolean isM4Schema() {
        return this.refersToM4Schema;
    }

    public void commitTransactions() throws SQLException {
        this.closeDbStatements();
        if (this.isM4Schema()) {
            this.getDatabaseConnection().commit();
        } else {
            this.getDatabaseConnection().commit();
        }
        this.doPrint(3, "DB: Batch executed, updates committed!");
    }

    public void rollback() throws SQLException {
        this.closeDbStatements();
        this.getDatabaseConnection().rollback();
        this.doPrint(3, "DB: Updates rolled back!");
    }

    private Connection getDatabaseConnection() {
        return this.con;
    }

    private Statement getDbReadStatement() throws SQLException, DbConnectionClosed {
        Statement stmt = DbCore.findFreeStatement(this.readResultSets);
        if (stmt == null) {
            stmt = this.getDatabaseConnection().createStatement();
            this.readResultSets.put(stmt, new ExtendedResultSet(stmt));
        }
        if (this.readResultSets.size() > 20) {
            this.openStatementsWarning(this.readResultSets.size());
        }
        return stmt;
    }

    private Statement getDbWriteStatement() throws SQLException, DbConnectionClosed {
        if (this.statementWrite == null) {
            Statement stmt = this.getDatabaseConnection().createStatement();
            stmt.clearBatch();
            this.statementWrite = stmt;
        }
        return this.statementWrite;
    }

    private void closeDbStatements() {
        if (this.statementWrite != null) {
            try {
                DbCore.commitBatch(this.statementWrite);
                this.statementWrite.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statementWrite = null;
        }
        DbCore.clearStatementMap(this.readResultSets);
    }

    Connection getExternalDatabaseConnection() throws SQLException {
        this.registerJDBC_Driver();
        Connection newDataCon = DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPasswd());
        newDataCon.setAutoCommit(false);
        DatabaseMetaData dmd = newDataCon.getMetaData();
        this.doPrint(10, "\n--- Setting up new database connection for external use ---");
        this.doPrint(10, "JDBC-Driver-Version: " + dmd.getDriverVersion() + "  " + dmd.getDatabaseProductName());
        this.doPrint(10, "DB-Connection ok");
        return newDataCon;
    }

    public void executeSqlWrite(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbWriteStatement();
        this.executeSqlWrite(query, stmt);
    }

    public void createSQLView(Columnset cs, long stepId, boolean materialize) throws SQLException, DbConnectionClosed, M4CompilerError {
        String sqlTemp = cs.getSQLDefinition();
        sqlTemp = sqlTemp.substring(1, sqlTemp.length() - 1);
        String query = "CREATE " + (materialize ? "TABLE " : "OR REPLACE VIEW ") + cs.getName() + " AS " + sqlTemp;
        this.executeSqlWrite(query);
    }

    public void createSQLFunction(String myFunction) throws SQLException, DbConnectionClosed {
        String query = "CREATE OR REPLACE " + myFunction;
        this.executeSqlWrite(query);
    }

    public String createSqlIndex(String tableName, String[] attributes) throws SQLException, DbConnectionClosed {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        String indexName = String.valueOf(tableName) + "_IDX";
        String query = "CREATE INDEX " + indexName + " ON " + tableName + " (";
        int i = 0;
        while (i < attributes.length) {
            query = String.valueOf(query) + attributes[i] + ", ";
            ++i;
        }
        query = query.subSequence(0, query.length() - 2) + ")";
        this.executeSqlWrite(query);
        return indexName;
    }

    public ResultSet executeSqlRead(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSqlRead(query, stmt);
    }

    private void executeSqlWrite(String query, Statement stmt) throws SQLException {
        if (DbCore.isBatchableWriteQuery(query)) {
            stmt.addBatch(query);
            this.doPrint(3, "DB write (to batch): " + query);
        } else {
            DbCore.commitBatch(stmt);
            stmt.executeUpdate(query);
            this.doPrint(3, "DB execute/update: " + query);
        }
    }

    private ResultSet executeSqlRead(String query, Statement stmt) throws SQLException {
        this.doPrint(2, "DB Query (Read): " + query);
        ExtendedResultSet rs = new ExtendedResultSet(stmt.executeQuery(query));
        this.readResultSets.put(stmt, rs);
        return rs;
    }

    private String executeSingleValueSqlRead(String query, Statement stmt) throws SQLException {
        ResultSet rs;
        block2: {
            String string;
            rs = null;
            try {
                String s;
                rs = this.executeSqlRead(query, stmt);
                if (!rs.next()) break block2;
                string = s = rs.getString(1);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                DB.closeResultSet(rs);
                throw throwable;
            }
            DB.closeResultSet(rs);
            return string;
        }
        Object var5_7 = null;
        DB.closeResultSet(rs);
        return null;
    }

    protected Long executeSingleValueSqlReadL(String query, Statement stmt) throws SQLException {
        ResultSet rs;
        block2: {
            Long l;
            rs = null;
            try {
                rs = this.executeSqlRead(query, stmt);
                if (!rs.next()) break block2;
                Long l2 = new Long(rs.getLong(1));
                rs.close();
                l = l2;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                DB.closeResultSet(rs);
                throw throwable;
            }
            DB.closeResultSet(rs);
            return l;
        }
        Object var5_7 = null;
        DB.closeResultSet(rs);
        return null;
    }

    public Long executeSingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSingleValueSqlReadL(query, stmt);
    }

    public String executeSingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        Statement stmt = this.getDbReadStatement();
        return this.executeSingleValueSqlRead(query, stmt);
    }

    protected abstract long getNextM4SequenceValue(Statement var1) throws M4Exception;

    long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        try {
            Statement stmt = this.getDbReadStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4Exception(msg);
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters) throws SQLException, DbConnectionClosed, M4CompilerError {
        Statement stmt = this.getDbWriteStatement();
        DbCore.commitBatch(stmt);
        String queryStart = "BEGIN " + procedureName + "(";
        String queryEnd = "); END; ";
        String queryParameters = "";
        int i = 0;
        while (i < parameters.length) {
            queryParameters = String.valueOf(queryParameters) + parameters[i];
            if (i < parameters.length - 1) {
                queryParameters = String.valueOf(queryParameters) + ", ";
            }
            ++i;
        }
        String query = String.valueOf(queryStart) + queryParameters + queryEnd;
        this.doPrint(2, "DB Query: " + query);
        stmt.executeUpdate(query);
    }

    private void openStatementsWarning(int number) {
        this.doPrint(11, "( Warning: The number of open statements is " + number + ".");
        this.doPrint(11, "  Probably some of the ResultSets are not closed after usage! )");
    }

    void stopDbThread() {
        this.doPrint(11, "Thread was requested to stop. Closing database resources.");
        try {
            if (this.statementWrite != null) {
                this.statementWrite.clearBatch();
            }
            DbCore.clearStatementMap(this.readResultSets);
            if (this.con != null) {
                this.con.rollback();
                this.con.close();
                this.con = null;
            }
            this.doPrint(3, "DB: Rollback and closing of connection successful!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void doPrint(int verbosity, String message) {
        this.getCasePrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception ex) {
        this.getCasePrintObject().doPrint(ex);
    }

    private static void commitBatch(Statement stmt) throws SQLException {
        stmt.executeBatch();
        stmt.clearBatch();
    }

    private static boolean isBatchableWriteQuery(String query) {
        String tmp = query.trim().toLowerCase();
        return tmp.startsWith("update ") || tmp.startsWith("insert ");
    }

    private static void clearStatementMap(HashMap theMap) {
        if (theMap == null || theMap.isEmpty()) {
            return;
        }
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        theMap.clear();
    }

    private static Statement findFreeStatement(HashMap theMap) {
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            ExtendedResultSet rs;
            Statement stmt = (Statement)it.next();
            if (stmt == null || (rs = (ExtendedResultSet)theMap.get(stmt)) == null || !rs.isClosed()) continue;
            return stmt;
        }
        return null;
    }

    public abstract String getSelectStringAllTables();

    public abstract String getSelectStringAllViews();

    public abstract String getSelectStringAllColumnsForDbObject(String var1);

    public abstract String getAttributeForColumnNames();

    public abstract String getAttributeForColumnTypes();

    public abstract String getUniqueRowIdentifier();

    public abstract String getDatatypeName(String var1, int var2);

    public abstract String getM4DatatypeName(String var1);

    public abstract String getSelectStringColumnDataTypes(String var1, String var2, String var3);

    public abstract boolean dropRelation(String var1) throws SQLException;

    public abstract String getTestQuery();
}

