/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.miningmart.db;

import edu.udo.miningmart.db.DbCore;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.M4Data;
import edu.udo.miningmart.m4.core.M4InterfaceContext;
import edu.udo.miningmart.m4.core.M4Object;
import edu.udo.miningmart.m4.utils.Print;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

public class DB
implements Serializable {
    protected final transient DbCore m4Dbc;
    protected final transient DbCore busiDbc;
    public static final short NO_DBMS = 0;
    public static final short ORACLE = 1;
    public static final short POSTGRES = 2;
    public static final String c_yes = "YES";
    public static final String c_no = "NO";
    public static final String c_output = "OUT";
    public static final String c_input = "IN";
    public static final String c_db = "DB";
    public static final String c_mining = "MINING";
    public static String C_VAL = "V";
    public static String C_CONC = "CON";
    public static String C_REL = "REL";
    public static String C_BA = "BA";
    public static String C_MCF = "MCF";
    public static String C_FEA = "FEA";
    protected boolean computeAllStat;
    protected transient M4InterfaceContext cal;
    private final Hashtable loadedObjects;
    private static final Class[] CONSTR_ARGS;
    public static final boolean READ_ONLY = false;
    private static final String[] ORDER_FOR_WRITING;
    private static final HashMap dirtyObjectSets;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.udo.miningmart.db.DB");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CONSTR_ARGS = classArray;
        ORDER_FOR_WRITING = new String[]{"case_t", "concept_t", "columnset_t", "csstatist_t", "conceptisa_t", "projection_t", "mcfeature_t", "baseattrib_t", "column_t", "colstatist1_t", "colstatist2_t", "keyhead_t", "keymember_t", "relation_t", "value_t", "chain_t", "step_t", "parameter_t", "docu_t"};
        dirtyObjectSets = new HashMap();
    }

    public DB(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        this.computeAllStat = computeStatistics;
        this.cal = cal;
        this.m4Dbc = DbCore.getDbCore(m4Url, m4DbName, m4User, m4Passwd, cal, true);
        this.busiDbc = DbCore.getDbCore(dataUrl, dataDbName, dataUser, dataPasswd, cal, false);
        this.loadedObjects = new Hashtable();
        this.testDbConnection();
    }

    public DB(DB db, M4InterfaceContext m4i) {
        this.loadedObjects = db.loadedObjects;
        this.m4Dbc = db.m4Dbc;
        this.busiDbc = db.busiDbc;
        this.cal = m4i;
    }

    public Print getCasePrintObject() {
        M4InterfaceContext cal = this.getCompilerAccessLogic();
        return cal == null ? null : cal.getPrintObject();
    }

    public void getFreshM4Connection() throws SQLException, DbConnectionClosed {
        this.getM4DbCore().getFreshConnection();
    }

    private void testDbConnection() throws SQLException {
        try {
            DbCore m4Dbc = this.getM4DbCore();
            DbCore busDbc = this.getBusinessDbCore();
            if (m4Dbc == null || busDbc == null) {
                throw new SQLException("DB.testDbConnection: DbCore not found!");
            }
            ResultSet rs = this.executeM4SqlRead(m4Dbc.getTestQuery());
            rs.close();
            rs = this.executeBusinessSqlRead(busDbc.getTestQuery());
            rs.close();
        }
        catch (DbConnectionClosed dbConnectionClosed) {
            // empty catch block
        }
    }

    public short getM4Dbms() throws DbConnectionClosed {
        DbCore dbc = this.getM4DbCore();
        if (dbc != null) {
            return dbc.getDbms();
        }
        return 0;
    }

    public short getBusinessDbms() throws DbConnectionClosed {
        DbCore dbc = this.getBusinessDbCore();
        if (dbc != null) {
            return dbc.getDbms();
        }
        return 0;
    }

    public void commitM4Transactions() throws SQLException, DbConnectionClosed {
        this.getM4DbCore().commitTransactions();
    }

    public void commitBusinessTransactions() throws SQLException, DbConnectionClosed {
        this.getBusinessDbCore().commitTransactions();
    }

    public void rollbackOnM4() throws SQLException, DbConnectionClosed {
        this.getM4DbCore().rollback();
    }

    public M4Object getM4Object(long Id, Class m4ClassObject) throws M4Exception {
        if (Id == 0L) {
            return null;
        }
        M4Object tmp = this.getM4ObjectFromCache(Id);
        if (tmp == null) {
            this.doPrint(6, "Loading object from database");
            M4Object emptyObject = this.createNewInstance(m4ClassObject);
            M4Object theObject = emptyObject.load(Id);
            this.putM4ObjectToCache(theObject);
            return theObject;
        }
        this.doPrint(6, "Returning already loaded Object");
        return tmp;
    }

    public void clearM4Cache() {
        if (this.loadedObjects == null) {
            return;
        }
        this.loadedObjects.clear();
    }

    public M4Object getM4ObjectFromCache(long Id) {
        return (M4Object)this.loadedObjects.get(new Long(Id));
    }

    public void putM4ObjectToCache(M4Object m4o) throws M4Exception {
        if (m4o == null) {
            throw new M4Exception("M4 Cache, method DB.putM4ObjectToCache(M4Object):\nRefusing to store a <null> object!");
        }
        long id = m4o.getId();
        if (id == 0L) {
            throw new M4Exception("M4 Cache, method DB.putM4ObjectToCache(M4Object):\nRefusing to store an M4Object with ID 0!\nObject is of type " + m4o.getClass().getName());
        }
        this.loadedObjects.put(new Long(id), m4o);
    }

    public void removeM4ObjectFromCache(M4Object m4o) {
        if (m4o != null && m4o.getId() != 0L && m4o.equals(this.getM4ObjectFromCache(m4o.getId()))) {
            this.loadedObjects.remove(new Long(m4o.getId()));
        }
    }

    public static String attribPrefix(String attributeName, String prefix) {
        String ret = "SUBSTR(" + attributeName + ", 1, " + prefix.length() + ")";
        return ret;
    }

    public static String quote(String sql) {
        if (sql == null) {
            return null;
        }
        String tmp1 = sql;
        String tmp2 = "'";
        int i = tmp1.indexOf("'");
        while (i >= 0) {
            tmp2 = String.valueOf(tmp2) + tmp1.substring(0, i + 1) + "'";
            tmp1 = tmp1.substring(i + 1);
            i = tmp1.indexOf("'");
        }
        return String.valueOf(tmp2) + tmp1 + "'";
    }

    private void insertColumnStatistField(String fieldName, int tableNumber, long colId, String value) throws M4Exception, DbConnectionClosed {
        if (tableNumber != 1 && tableNumber != 2) {
            throw new M4Exception("DB.java: updateColumnStatistFieldAndTrash called with wrong table number " + tableNumber);
        }
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO COLSTATIST" + tableNumber + "_T " + "(colst" + tableNumber + "_id, colst" + tableNumber + "_colid, " + fieldName + ") VALUES (" + statId + ", " + colId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.insertColumnStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private void insertColumnSetStatistField(String fieldName, long csId, String value) throws M4Exception, DbConnectionClosed {
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO CSSTATIST_T (csst_id, csst_csid, " + fieldName + ") VALUES (" + statId + ", " + csId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.insertColumnSetStatistField: DB access error: " + sqle.getMessage());
        }
    }

    public static String checkDouble(String test) throws M4Exception {
        if (test == null) {
            return null;
        }
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = String.valueOf(pre) + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4Exception("Error trying to convert '" + test + "' into double, when reading a Value from the DB.");
        }
        return test;
    }

    public void executeM4SqlWrite(String query) throws SQLException, DbConnectionClosed {
        this.getM4DbCore().executeSqlWrite(query);
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, DbConnectionClosed {
        this.getBusinessDbCore().executeSqlWrite(query);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSqlRead(query);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSqlRead(query);
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSingleValueSqlReadL(query);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSingleValueSqlReadL(query);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSingleValueSqlRead(query);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSingleValueSqlRead(query);
    }

    public long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        return this.getM4DbCore().getNextM4SequenceValue();
    }

    protected void doPrint(int verbosity, String message) {
        this.getCasePrintObject().doPrint(verbosity, message);
    }

    protected void doPrint(Exception ex) {
        this.getCasePrintObject().doPrint(ex);
    }

    public M4InterfaceContext getCompilerAccessLogic() {
        return this.cal;
    }

    private DbCore getM4DbCore() throws DbConnectionClosed {
        return this.m4Dbc;
    }

    private DbCore getBusinessDbCore() throws DbConnectionClosed {
        return this.busiDbc;
    }

    public M4Object createNewInstance(Class c) throws M4Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.M4Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(c)) {
            throw new M4Exception("Error: M4Object.createNewInstance(Class) failed, because the Class object provided is not assignment compatible to M4Object!");
        }
        try {
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new M4Exception("DB.createNewInstance(" + c.getName() + "): Cannot instantiate an abstract class!");
            }
            Constructor constr = c.getConstructor(CONSTR_ARGS);
            if (constr == null) {
                throw new M4Exception("DB.createNewInstance(" + c.getName() + "):\n" + " This class does not have the necessary constructor with argument class DB!");
            }
            Object[] parameters = new Object[]{this};
            return (M4Object)constr.newInstance(parameters);
        }
        catch (Exception e) {
            throw new M4Exception("Error: M4Object.createNewInstance(Class) failed:\n" + e.getMessage());
        }
    }

    public static String closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static HashSet getDirtyObjectsForTable(String dbTableName) {
        if (dbTableName == null) {
            return null;
        }
        HashSet ret = (HashSet)dirtyObjectSets.get(dbTableName);
        if (ret == null) {
            ret = new HashSet();
            dirtyObjectSets.put(dbTableName, ret);
        }
        return ret;
    }

    private static void clearDirtyObjectSets() {
        dirtyObjectSets.clear();
    }

    public void updateDatabase() throws M4Exception {
        String dbTableName;
        int i;
        if (this.m4Dbc == null || this.busiDbc == null) {
            return;
        }
        int numOfSets = ORDER_FOR_WRITING.length;
        HashMap<String, Collection> deleteThose = new HashMap<String, Collection>();
        boolean dirty = true;
        int passes = 0;
        while (passes++ < 3 && dirty) {
            this.doPrint(3, "*** Updating database! Pass " + passes + ": ***");
            i = 0;
            while (i < numOfSets) {
                dbTableName = ORDER_FOR_WRITING[i];
                Collection deleteCol = M4Data.updateObjectsFromTable(dbTableName);
                Collection delMap = (Collection)deleteThose.get(dbTableName);
                if (delMap == null) {
                    deleteThose.put(dbTableName, deleteCol);
                } else {
                    delMap.addAll(deleteCol);
                }
                ++i;
            }
            dirty = false;
            i = 0;
            while (i < numOfSets) {
                dbTableName = ORDER_FOR_WRITING[i];
                HashSet col = DB.getDirtyObjectsForTable(dbTableName);
                int colSize = col.size();
                this.doPrint(3, "Remaining objects to be updated from table " + dbTableName + ": " + colSize);
                dirty = dirty || colSize > 0;
                ++i;
            }
        }
        if (dirty) {
            this.doPrint(11, "DB.updateDatabase(): Warning, could not update all dirty database objects!\nIt might be a good idea to close and restart this application!");
        }
        i = numOfSets - 1;
        while (i >= 0) {
            dbTableName = ORDER_FOR_WRITING[i];
            Collection dirtySet = (Collection)deleteThose.get(dbTableName);
            if (dirtySet != null) {
                M4Data.removeSetFromDb(dirtySet);
            }
            --i;
        }
        try {
            this.commitM4Transactions();
            this.commitBusinessTransactions();
            this.doPrint(3, "Database is up to date now!");
        }
        catch (SQLException e) {
            this.clearM4Cache();
            throw new M4Exception("SQLException caught at DB.updateDatabase() when trying to commit changes:\n" + e.getMessage());
        }
        catch (DbConnectionClosed e) {
            this.clearM4Cache();
            throw new M4Exception("Error: The database connection was closed before the updates could be committed at DB.updateDatabase()!\nException message is:\n" + e.getMessage());
        }
    }
}

