/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.wizard;

import com.syllogic.miningmart.concepteditor.util.Constants;
import com.syllogic.miningmart.concepteditor.util.Task;
import com.syllogic.miningmart.concepteditor.wizard.WizardScreen;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class Wizard
extends JDialog
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)"Wizard");
    private WizardScreen firstScreen;
    protected LinkedList screens = new LinkedList();
    private Task task;
    private ArrayList screenHistory = new ArrayList();
    private boolean cancelPressed = false;
    private JPanel screenPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton previousButton = new JButton();
    private JButton finishButton = new JButton();
    private JButton helpButton = new JButton();

    public Wizard() {
    }

    public Wizard(Frame parent, boolean modal, Task task) {
        super(parent, modal);
        this.initGUI();
        this.setTask(task);
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Wizard.this.doCancel();
            }
        });
        ((Component)this).setBackground(Constants.LIGHT_GREY);
        this.previousButton.setText("Previous");
        this.previousButton.setActionCommand("Previous");
        this.previousButton.setMnemonic('P');
        this.previousButton.addActionListener(this);
        this.nextButton.setText("Next");
        this.nextButton.setActionCommand("Next");
        this.nextButton.setMnemonic('N');
        this.nextButton.addActionListener(this);
        this.finishButton.setText("Finish");
        this.finishButton.setActionCommand("Finish");
        this.finishButton.setMnemonic('F');
        this.finishButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.helpButton.setText("Help");
        this.helpButton.setActionCommand("Help");
        this.helpButton.setMnemonic('H');
        this.helpButton.addActionListener(this);
        this.buttonPanel.add(this.previousButton);
        this.buttonPanel.add(this.nextButton);
        this.buttonPanel.add(this.finishButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.buttonPanel.setBackground(Constants.LIGHT_GREY);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.screenPanel.setLayout(new GridLayout(1, 1));
        this.screenPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.screenPanel, "Center");
        ((Component)this).setSize(600, 400);
    }

    protected abstract void initScreens();

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    protected void handleEvents(String command) {
        if (command.equalsIgnoreCase("Next")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Next button accessed");
            }
            this.doNext();
        } else if (command.equalsIgnoreCase("Previous")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Previous button");
            }
            this.doPrevious();
        } else if (command.equalsIgnoreCase("Finish")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Finish button");
            }
            this.doFinish();
        } else if (command.equalsIgnoreCase("Help")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Help button");
            }
            this.doHelp();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        }
    }

    public void doFinish() {
        WizardScreen currentScreen = this.getCurrentScreen();
        if (!currentScreen.canProceed()) {
            return;
        }
        ((Component)this).setVisible(false);
        HashMap info = new HashMap();
        Iterator i = ((AbstractList)this.screenHistory).iterator();
        while (i.hasNext()) {
            WizardScreen aScreen = (WizardScreen)i.next();
            Map screenInfo = aScreen.getScreenInfo();
            info.putAll(screenInfo);
        }
        if (this.task != null) {
            this.task.setInput(info);
            this.task.execute();
        }
        ((Component)this).setVisible(false);
        this.setCancelPressed(false);
    }

    public void start() {
        this.screenHistory.clear();
        this.screenPanel.add(this.firstScreen);
        this.screenHistory.add(this.firstScreen);
        this.updateButtons(this.firstScreen);
        ((Component)this).setVisible(true);
    }

    public void doPrevious() {
        WizardScreen previousScreen = this.getPreviousScreen();
        if (previousScreen != null) {
            this.screenPanel.removeAll();
            this.screenPanel.add(previousScreen);
            this.screenPanel.updateUI();
            ((AbstractCollection)this.screenHistory).remove(this.getCurrentScreen());
            this.updateButtons(previousScreen);
        }
    }

    public void doNext() {
        WizardScreen currentScreen = this.getCurrentScreen();
        if (currentScreen != null) {
            if (currentScreen.canProceed()) {
                WizardScreen nextScreen = currentScreen.getNextScreen();
                nextScreen.setInputInfo(currentScreen.getScreenInfo());
                nextScreen.init();
                this.screenPanel.removeAll();
                this.screenPanel.add(nextScreen);
                this.screenPanel.updateUI();
                this.screenHistory.add(nextScreen);
                this.updateButtons(nextScreen);
            } else {
                String message = "Not all necessary information has been provided.\nPlease check the settings.";
                JOptionPane.showMessageDialog(this, message, "Input check", 1);
            }
        }
    }

    public void doHelp() {
    }

    public void doCancel() {
        ((Component)this).setVisible(false);
        this.setCancelPressed(true);
    }

    public WizardScreen getFirstScreen() {
        return this.firstScreen;
    }

    public void setFirstScreen(WizardScreen firstScreen) {
        this.firstScreen = firstScreen;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected WizardScreen getCurrentScreen() {
        int historySize = this.screenHistory.size();
        if (historySize > 0) {
            return (WizardScreen)this.screenHistory.get(historySize - 1);
        }
        return null;
    }

    private WizardScreen getPreviousScreen() {
        int historySize = this.screenHistory.size();
        if (historySize > 1) {
            return (WizardScreen)this.screenHistory.get(historySize - 2);
        }
        return null;
    }

    private void updateButtons(WizardScreen screen) {
        if (screen.isLastScreen()) {
            this.nextButton.setEnabled(false);
            this.finishButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(true);
            this.finishButton.setEnabled(false);
        }
        if (this.screenHistory.size() > 1) {
            this.previousButton.setEnabled(true);
        } else {
            this.previousButton.setEnabled(false);
        }
    }

    protected void addScreen(WizardScreen screen) {
        if (this.screens.size() == 0) {
            this.setFirstScreen(screen);
        } else {
            WizardScreen previousScreen = (WizardScreen)this.screens.getLast();
            previousScreen.setNextScreen(screen);
        }
        screen.setNextScreen(null);
        this.screens.add(screen);
    }

    protected void removeScreen(WizardScreen screen) {
        int index = this.screens.indexOf(screen);
        int size = this.screens.size();
        if (index == 0) {
            this.setFirstScreen((WizardScreen)this.screens.get(1));
        } else if (index == size - 1 && index > 0) {
            WizardScreen previousScreen = (WizardScreen)this.screens.get(index - 1);
            previousScreen.setNextScreen(null);
        } else if (index > 0 && index < size - 1) {
            WizardScreen previousScreen = (WizardScreen)this.screens.get(index - 1);
            WizardScreen nextScreen = (WizardScreen)this.screens.get(index + 1);
            previousScreen.setNextScreen(nextScreen);
        }
        this.screens.remove(screen);
        if (this.screens.size() == 0) {
            this.setFirstScreen(null);
        }
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void setCancelPressed(boolean value) {
        this.cancelPressed = value;
    }

    public void removeHelpButton() {
        this.buttonPanel.remove(this.helpButton);
    }
}

