/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MapTableModel;
import edu.udo.miningmart.m4.hciImpl.ColumnsetImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import miningmart.m4.Case;
import miningmart.m4.ColumnSet;
import miningmart.m4.Concept;
import miningmart.m4.M4Interface;
import org.apache.log4j.Logger;

public class StatisticsDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"StatisticsDialog");
    private Frame parentFrame;
    private ColumnSet currentColumnSet;
    private Map csMap = new HashMap();
    private List csColumnNames = new ArrayList();
    private Map c1Map = new HashMap();
    private List c1ColumnNames = new ArrayList();
    private Map c2Map = new HashMap();
    private List c2ColumnNames = new ArrayList();
    private GridBagLayout gridBagLO = new GridBagLayout();
    private GridBagConstraints gridBagCon = new GridBagConstraints();
    private JPanel gridBagPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JLabel csLabel = new JLabel();
    private JTable csTable = new JTable();
    private JScrollPane csTableScrollPane = new JScrollPane(this.csTable);
    private JLabel c1Label = new JLabel("Column Statistics 1");
    private JTable c1Table = new JTable();
    private JScrollPane c1TableScrollPane = new JScrollPane(this.c1Table);
    private JLabel c2Label = new JLabel("Column Statistics 2");
    private JTable c2Table = new JTable();
    private JScrollPane c2TableScrollPane = new JScrollPane(this.c2Table);

    public StatisticsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setParent(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("View Statistics");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StatisticsDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.csTable.setPreferredScrollableViewportSize(new Dimension(700, 50));
        this.c1Table.setPreferredScrollableViewportSize(new Dimension(700, 150));
        this.c2Table.setPreferredScrollableViewportSize(new Dimension(700, 150));
        this.gridBagPanel.setLayout(this.gridBagLO);
        this.gridBagCon.gridwidth = 0;
        this.gridBagCon.fill = 1;
        this.gridBagCon.weightx = 100.0;
        this.gridBagCon.weighty = 0.0;
        this.gridBagCon.gridx = 0;
        this.gridBagCon.gridy = 0;
        this.gridBagLO.setConstraints(this.csLabel, this.gridBagCon);
        this.gridBagPanel.add(this.csLabel);
        this.gridBagCon.weighty = 100.0;
        this.gridBagCon.gridy = 1;
        this.gridBagLO.setConstraints(this.csTableScrollPane, this.gridBagCon);
        this.gridBagPanel.add(this.csTableScrollPane);
        this.gridBagCon.weighty = 0.0;
        this.gridBagCon.gridy = 2;
        this.gridBagLO.setConstraints(this.c1Label, this.gridBagCon);
        this.gridBagPanel.add(this.c1Label);
        this.gridBagCon.weighty = 100.0;
        this.gridBagCon.gridy = 3;
        this.gridBagLO.setConstraints(this.c1TableScrollPane, this.gridBagCon);
        this.gridBagPanel.add(this.c1TableScrollPane);
        this.gridBagCon.weighty = 0.0;
        this.gridBagCon.gridy = 4;
        this.gridBagLO.setConstraints(this.c2Label, this.gridBagCon);
        this.gridBagPanel.add(this.c2Label);
        this.gridBagCon.weighty = 100.0;
        this.gridBagCon.gridy = 5;
        this.gridBagLO.setConstraints(this.c2TableScrollPane, this.gridBagCon);
        this.gridBagPanel.add(this.c2TableScrollPane);
        this.gridBagPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.getContentPane().add((Component)this.gridBagPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void initForEdit(ColumnSet columnSet, int maxRows) {
        this.currentColumnSet = columnSet;
        long csId = ((ColumnsetImpl)this.currentColumnSet).getId();
        String schema = this.currentColumnSet.getSchema();
        String tableName = this.currentColumnSet.getName();
        this.csLabel.setText("ColumnSet " + schema + "." + tableName);
        M4Interface myInterface = M4Interface.getInstance();
        if (myInterface == null) {
            logger.error((Object)"Could not initialize the M4 Interface");
        } else {
            logger.info((Object)"M4 Interface initialized");
        }
        String csSQL = "SELECT\tcss.csst_all AS \"all\", csst_ord AS \"ord\", csst_nom AS \"nom\", csst_time AS \"time\" FROM\t\tcolumnset_t cs ,\t\t\tcsstatist_t css WHERE\tcs.cs_id = " + csId + " " + "AND\t\tcs.cs_id = css.csst_csid ";
        try {
            this.csMap = myInterface.executeSQLQ(csSQL, maxRows);
            this.csColumnNames = (List)this.csMap.get("mmColumnNames");
            MapTableModel csModel = new MapTableModel();
            csModel.setMap(this.csMap);
            csModel.setColumnNames(this.csColumnNames);
            this.csTable.setModel(csModel);
            logger.info((Object)("Number of rows is " + csModel.getRowCount()));
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        String c1SQL = "SELECT\tc.col_name AS \"column name\" ,\t\t\tcst1.colst1_unique AS \"unique\",\tcst1.colst1_missing AS \"missing\" ,\t\t\tcst1.colst1_min AS \"min\", cst1.colst1_max AS \"max\" ,\t\t\tcst1.colst1_avg AS \"avg\", cst1.colst1_stddev AS \"stddev\" ,\t\t\tcst1.colst1_variance AS \"variance\", cst1.colst1_median AS \"median\" ,\t\t\tcst1.colst1_modal AS \"modal\" FROM\t\tcolumnset_t cs ,\t\t\tcolumn_t c ,\t\t\tcolstatist1_t cst1 WHERE\tcs.cs_id = " + csId + " " + "AND\t\tcs.cs_id = c.col_csid " + "AND\t\tc.col_id = cst1.colst1_colid";
        try {
            this.c1Map = myInterface.executeSQLQ(c1SQL, maxRows);
            this.c1ColumnNames = (List)this.c1Map.get("mmColumnNames");
            MapTableModel c1Model = new MapTableModel();
            c1Model.setMap(this.c1Map);
            c1Model.setColumnNames(this.c1ColumnNames);
            this.c1Table.setModel(c1Model);
            logger.info((Object)("Number of rows is " + c1Model.getRowCount()));
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        String c2SQL = "SELECT\tc.col_name AS \"column name\" ,\t\t\tcst2.colst2_distvalue AS \"distvalue\", cst2.colst2_distcount AS \"distcount\" ,\t\t\tcst2.colst2_distmin AS \"distmin\", cst2.colst2_distmax AS \"distmax\" FROM\t\tcolumnset_t cs ,\t\t\tcolumn_t c ,\t\t\tcolstatist2_t cst2 WHERE\tcs.cs_id = " + csId + " " + "AND\t\tcs.cs_id = c.col_csid " + "AND\t\tc.col_id = cst2.colst2_colid";
        try {
            this.c2Map = myInterface.executeSQLQ(c2SQL, maxRows);
            this.c2ColumnNames = (List)this.c2Map.get("mmColumnNames");
            MapTableModel c2Model = new MapTableModel();
            c2Model.setMap(this.c2Map);
            c2Model.setColumnNames(this.c2ColumnNames);
            this.c2Table.setModel(c2Model);
            logger.info((Object)("Number of rows is " + c2Model.getRowCount()));
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOK();
        }
    }

    private void doOK() {
        this.currentColumnSet = null;
        ((Component)this).setVisible(false);
    }

    public void close() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    private void setParent(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame();
        ((Component)testFrame).setBounds(10, 10, 60, 40);
        ((Component)testFrame).setVisible(true);
        M4Interface myInterface = M4Interface.getInstance();
        Case salesCase = null;
        try {
            salesCase = myInterface.findCaseForReadOnlyAccess("DM_SALES_PREDICTION", true);
        }
        catch (M4Interface.CaseLockedException e) {
            e.printStackTrace();
        }
        Concept shopSales = salesCase.getConcept("SHOP_SALE");
        ColumnSet shopSalesCS = shopSales.getColumnSet("DM_TIME_VALID");
        StatisticsDialog aDialog = new StatisticsDialog((Frame)testFrame, true);
        aDialog.initForEdit(shopSalesCS, 1000);
        aDialog.pack();
        ((Component)aDialog).setVisible(true);
        myInterface.releaseCase("DM_SALES_PREDICTION");
        System.exit(0);
    }
}

