/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.dialogs;

import com.syllogic.miningmart.concepteditor.dialogs.ColumnDialog;
import com.syllogic.miningmart.concepteditor.dialogs.ColumnSetColumnPanel;
import com.syllogic.miningmart.concepteditor.dialogs.ColumnSetPropertiesPanel;
import com.syllogic.miningmart.concepteditor.dialogs.DialogManager;
import com.syllogic.miningmart.concepteditor.util.Closeable;
import com.syllogic.miningmart.concepteditor.util.ESC_KeyListener;
import com.syllogic.miningmart.concepteditor.util.MyListCellRenderer;
import com.syllogic.miningmart.concepteditor.util.MyListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import miningmart.m4.Column;
import miningmart.m4.ColumnSet;
import miningmart.m4.StorageException;
import org.apache.log4j.Logger;

public class ColumnSetDialog
extends JDialog
implements ActionListener,
Closeable {
    private static Logger logger = Logger.getLogger((String)"ColumnSetDialog");
    private int numberOfProperties = 6;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel southPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private ColumnSetPropertiesPanel propertiesTab = new ColumnSetPropertiesPanel();
    private ColumnSetColumnPanel columnsTab = new ColumnSetColumnPanel();
    private MyListModel columnListModel = new MyListModel();
    private ColumnSet currentColumnSet;
    private DialogManager dialogManager;

    public ColumnSetDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initGUI();
    }

    public void initForDisplay(ColumnSet columnSet) {
        if (columnSet == null) {
            logger.error((Object)"Could not properly initialize ColumnSet dialog.");
            String message = "A initialization error occurred!\nCould properly initialize ColumnSet dialog.";
            JOptionPane.showMessageDialog(this, message, "Error", 2);
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        this.currentColumnSet = columnSet;
        this.propertiesTab.getNameTextField().setText(this.currentColumnSet.getName());
        this.propertiesTab.getSchemaTextField().setText(this.currentColumnSet.getSchema());
        String csType = this.currentColumnSet.getColumnSetType();
        csType = csType == null ? "<NONE...>" : (csType.equals("T") ? "TABLE" : (csType.equals("V") ? "VIEW" : (csType.equals("SN") ? "SNAPSHOT" : (csType.equals("MV") ? "MATERIALIZED VIEW" : "<NONE...>"))));
        this.propertiesTab.getTypeTextField().setText(csType);
        this.propertiesTab.getBranchTextField().setText(this.currentColumnSet.getMultiStepBranch());
        this.propertiesTab.getSQLTextArea().setText(this.currentColumnSet.getSqlString());
        this.fillColumnListModel();
    }

    private void fillColumnListModel() {
        this.columnListModel.clear();
        Collection allColumns = this.currentColumnSet.getAllColumns();
        Iterator i = allColumns.iterator();
        while (i.hasNext()) {
            Column aColumn = (Column)i.next();
            this.columnListModel.addElement(aColumn);
        }
    }

    private void initGUI() {
        this.setTitle("ColumnSet properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ColumnSetDialog.this.close();
            }
        });
        this.addKeyListener(new ESC_KeyListener(this));
        this.columnsTab.addActionListener(this);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170), 1));
        this.southPanel.add((Component)this.buttonPanel, "North");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.columnsTab.getColumnList().setModel(this.columnListModel);
        this.columnsTab.getColumnList().setCellRenderer(new MyListCellRenderer());
        this.tabbedPane.add((Component)new JScrollPane(this.propertiesTab), "Properties");
        this.tabbedPane.add((Component)new JScrollPane(this.columnsTab), "Columns");
        int preferredHeight = (this.numberOfProperties + 1) * 20 + 80;
        this.tabbedPane.setPreferredSize(new Dimension(500, preferredHeight));
    }

    public void close() {
        this.currentColumnSet = null;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.handleEvents(e.getActionCommand());
    }

    private void handleEvents(String command) {
        if (command.equalsIgnoreCase("OK")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK button accessed");
            }
            this.doOKExisting();
        } else if (command.equalsIgnoreCase("Cancel")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancel button");
            }
            this.doCancel();
        } else if (command.equalsIgnoreCase("ColumnProperties")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Show Column properties");
            }
            this.doShowColumnProperties();
        } else if (command.equalsIgnoreCase("DeleteColumn")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete Column button");
            }
            this.doDeleteColumn();
        }
    }

    private void doOKExisting() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OK button");
        }
        this.close();
    }

    private void doCancel() {
        this.close();
    }

    private void doDeleteColumn() {
        Object select = this.columnsTab.getColumnList().getSelectedValue();
        if (select == null) {
            return;
        }
        Column aColumn = (Column)select;
        String message = "Are you sure you want to delete Column: " + aColumn.getName() + "?";
        int choice = JOptionPane.showConfirmDialog(this, message, "Continue?", 0, 3);
        if (choice != 0) {
            return;
        }
        try {
            aColumn.delete();
        }
        catch (StorageException e) {
            logger.error((Object)"Could not delete Column.", (Throwable)e);
            message = "A data communication error occurred!\nCould not delete Column.";
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        }
        this.columnListModel.removeElement(aColumn);
    }

    private void doShowColumnProperties() {
        Object select = this.columnsTab.getColumnList().getSelectedValue();
        if (select == null) {
            return;
        }
        Column aColumn = (Column)select;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Column to be displayed : " + aColumn.getName()));
        }
        ColumnDialog aDialog = this.dialogManager.showColumnDialog(aColumn);
    }

    public void centralize() {
        Dimension d = this.getSize();
        Rectangle parentRec = this.getParent().getBounds();
        int x = parentRec.x + parentRec.width / 2 - d.width / 2;
        int y = parentRec.y + parentRec.height / 2 - d.height / 2;
        ((Component)this).setLocation(x >= 0 ? x : 0, y >= 0 ? y : 0);
    }

    public void setDialogManager(DialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }
}

