/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.miningmart.concepteditor.db;

import com.syllogic.miningmart.concepteditor.db.DBConnectInfo;
import com.syllogic.miningmart.concepteditor.db.DBObject;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.m4.hciImpl.HciDb;
import edu.udo.miningmart.m4.hciImpl.M4InterfaceImpl;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import miningmart.m4.M4Interface;
import org.apache.log4j.Logger;

public class DBUtil {
    private static Logger logger = Logger.getLogger((String)"DBUtil");

    public static List executeSQLQC1(DBConnectInfo dbConnectInfo, String sqlString, int maxRows) throws SQLException {
        List columnNames;
        String firstColumnName;
        Map tableData = DBUtil.executeSQLQ(dbConnectInfo, sqlString, maxRows);
        List firstColumnData = (List)tableData.get(firstColumnName = (columnNames = (List)tableData.get("mmColumnNames")).get(0).toString());
        return firstColumnData != null ? firstColumnData : new ArrayList();
    }

    public static Map executeSQLQ(DBConnectInfo dbConnectInfo, String sqlString, int maxRows) throws SQLException {
        HashMap aMap;
        block9: {
            ResultSet resultSet = null;
            aMap = new HashMap();
            int numColumns = 0;
            String columnName = "";
            try {
                try {
                    resultSet = DBUtil.getDbObjectFromM4Interface().executeBusinessSqlRead(sqlString);
                }
                catch (DbConnectionClosed dbcc) {
                    throw new SQLException(dbcc.getMessage());
                }
                ResultSetMetaData rsmd = resultSet.getMetaData();
                numColumns = rsmd.getColumnCount();
                int rowNum = 0;
                while (resultSet.next() && rowNum < maxRows) {
                    int i = 1;
                    while (i <= numColumns) {
                        columnName = rsmd.getColumnName(i);
                        ArrayList<Object> aList = (ArrayList<Object>)aMap.get(columnName);
                        if (aList == null) {
                            aList = new ArrayList<Object>();
                            aMap.put(columnName, aList);
                        }
                        aList.add(resultSet.getObject(i));
                        ++i;
                    }
                    ++rowNum;
                }
                ArrayList<String> cList = new ArrayList<String>();
                int i = 1;
                while (i <= numColumns) {
                    columnName = rsmd.getColumnName(i);
                    cList.add(columnName);
                    ++i;
                }
                aMap.put("mmColumnNames", cList);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            Object var11_16 = null;
            if (resultSet == null) break block9;
            resultSet.close();
        }
        return aMap;
    }

    public static String convertOracleOrPostgresDatatype(String dbDatatype) {
        if (dbDatatype.equalsIgnoreCase("VARCHAR2") || dbDatatype.equalsIgnoreCase("CHAR") || dbDatatype.equalsIgnoreCase("VARCHAR") || dbDatatype.equalsIgnoreCase("TEXT") || dbDatatype.equalsIgnoreCase("CHAR")) {
            return "STRING";
        }
        if (dbDatatype.equalsIgnoreCase("NUMBER") || dbDatatype.equalsIgnoreCase("FLOAT") || dbDatatype.equalsIgnoreCase("LONG") || dbDatatype.equalsIgnoreCase("NUMERIC")) {
            return "NUMBER";
        }
        if (dbDatatype.equalsIgnoreCase("DATE") || dbDatatype.equalsIgnoreCase("DATE") || dbDatatype.equalsIgnoreCase("TIME") || dbDatatype.equalsIgnoreCase("TIMESTAMP")) {
            return "DATE";
        }
        return null;
    }

    public static Collection getDBObjects() {
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        DBConnectInfo dbConnectInfo = DBConnectInfo.getDBConnectInfo();
        M4Interface m4Interface = M4Interface.getInstance();
        if (dbConnectInfo == null) {
            return dbObjects;
        }
        String username = dbConnectInfo.getUsername();
        int maxRows = 1000;
        try {
            String SELECT_ALL_TABLENAMES = DBUtil.getDbObjectFromM4Interface().getSelectStringAllBusDataTables();
            String SELECT_ALL_VIEWNAMES = DBUtil.getDbObjectFromM4Interface().getSelectStringAllBusDataViews();
            String SELECT_MM_TABLENAMES = "SELECT UPPER(OBJNAME) FROM DBTRASH_T WHERE\tOBJTYPE = 'T' AND UPPER(schemaname) = UPPER('" + username + "')";
            String SELECT_MM_VIEWNAMES = "SELECT UPPER(OBJNAME) FROM DBTRASH_T WHERE\tOBJTYPE = 'V' AND UPPER(schemaname) = UPPER('" + username + "')";
            List dbTables = DBUtil.executeSQLQC1(dbConnectInfo, SELECT_ALL_TABLENAMES, maxRows);
            List mmTables = m4Interface.executeSQLQC1(SELECT_MM_TABLENAMES, maxRows);
            if (mmTables != null) {
                dbTables.removeAll(mmTables);
            }
            Iterator it = dbTables.iterator();
            while (it.hasNext()) {
                DBObject aDBObject = new DBObject((String)it.next(), "TABLE");
                dbObjects.add(aDBObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Table added");
            }
            List dbViews = DBUtil.executeSQLQC1(dbConnectInfo, SELECT_ALL_VIEWNAMES, maxRows);
            List mmViews = m4Interface.executeSQLQC1(SELECT_MM_VIEWNAMES, maxRows);
            if (mmViews != null) {
                dbViews.removeAll(mmViews);
            }
            it = dbViews.iterator();
            while (it.hasNext()) {
                DBObject aDBObject = new DBObject((String)it.next(), "VIEW");
                dbObjects.add(aDBObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"View added");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Exception while executing SQL ", (Throwable)e);
        }
        return dbObjects;
    }

    public static String getSelectStringAllColumnsForDbObject(String dbObjectName) throws SQLException {
        return DBUtil.getDbObjectFromM4Interface().getSelectStringAllColumnsForDbObject(dbObjectName);
    }

    public static String getAttributeForColumnNames() throws SQLException {
        return DBUtil.getDbObjectFromM4Interface().getAttributeForColumnNames();
    }

    public static String getAttributeForColumnTypes() throws SQLException {
        return DBUtil.getDbObjectFromM4Interface().getAttributeForColumnTypes();
    }

    private static HciDb getDbObjectFromM4Interface() throws SQLException {
        DB myDB = ((M4InterfaceImpl)M4Interface.getInstance()).getM4db();
        if (!(myDB instanceof HciDb)) {
            throw new SQLException("ConceptEditor: DBUtil.java: Found a DB object of wrong type in M4 Interface instance!");
        }
        return (HciDb)myDB;
    }
}

