/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DragHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectionDragHandler
implements DragHandler {
    private static final int MOD_MASK = 47;
    private boolean itsIsDragging = false;
    private Point itsStartPoint;
    private Rectangle itsRect;

    public boolean isDragPoint(Diagram theDiagram, MouseEvent theEvent) {
        return (theEvent.getModifiers() & 0x2F) == 0 && theDiagram.findComponent(theEvent.getPoint()) == null && theDiagram.findRelation(theEvent.getPoint()) == null;
    }

    public boolean isDragging(Diagram theDiagram) {
        return this.itsIsDragging;
    }

    private void cleanup() {
        this.itsIsDragging = false;
        this.itsStartPoint = null;
        this.itsRect = null;
    }

    public void dragStart(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        this.itsStartPoint = evt.getPoint();
        this.itsRect = null;
        this.itsIsDragging = true;
    }

    public void drag(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (this.itsRect != null) {
            g2.draw(this.itsRect);
        }
        Point p2 = evt.getPoint();
        this.itsRect = new Rectangle(this.itsStartPoint.x, this.itsStartPoint.y, p2.x - this.itsStartPoint.x, p2.y - this.itsStartPoint.y);
        if (this.itsRect.width < 0) {
            this.itsRect.width = -this.itsRect.width;
            this.itsRect.x -= this.itsRect.width;
        }
        if (this.itsRect.height < 0) {
            this.itsRect.height = -this.itsRect.height;
            this.itsRect.y -= this.itsRect.height;
        }
        g2.draw(this.itsRect);
    }

    public void dragEnd(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (this.itsRect != null) {
            g2.draw(this.itsRect);
        }
        if (this.itsRect != null) {
            theDiagram.clearSelection();
            Iterator it = theDiagram.getModel().getComponents();
            ArrayList<DiagramComponent> aList = new ArrayList<DiagramComponent>();
            while (it.hasNext()) {
                DiagramComponent aComp = (DiagramComponent)it.next();
                Rectangle aCRect = theDiagram.getRectangle(aComp);
                if (!this.itsRect.contains(aCRect)) continue;
                aList.add(aComp);
            }
            theDiagram.setSelection(aList.toArray());
        }
        this.cleanup();
    }

    public void dragAbort(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        if (this.itsRect != null) {
            g2.draw(this.itsRect);
        }
        this.cleanup();
    }
}

