/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DragHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class MoveDragHandler
implements DragHandler {
    private static final int MOD_MASK = 47;
    private boolean itsIsDragging = false;
    private Point itsStartPoint;
    private Point itsDragPoint;

    public boolean isDragPoint(Diagram theDiagram, MouseEvent theEvent) {
        return (theEvent.getModifiers() & 0x2F) == 0 && theDiagram.findComponent(theEvent.getPoint()) != null;
    }

    public boolean isDragging(Diagram theDiagram) {
        return this.itsIsDragging;
    }

    private void cleanup() {
        this.itsIsDragging = false;
        this.itsStartPoint = null;
        this.itsDragPoint = null;
    }

    private void paintDragOutline(Diagram theDiagram, Graphics2D g2, Point thePlace) {
        g2.setXORMode(theDiagram.getBackground());
        g2.setColor(Color.black);
        Point anOffset = (Point)this.itsStartPoint.clone();
        anOffset.x = thePlace.x - anOffset.x;
        anOffset.y = thePlace.y - anOffset.y;
        Object[] aList = theDiagram.getSelectionModel().getSelection();
        int i = 0;
        while (i < aList.length) {
            DiagramComponent aComp;
            Rectangle aRect;
            if (aList[i] instanceof DiagramComponent && (aRect = theDiagram.getRectangle(aComp = (DiagramComponent)aList[i])) != null) {
                g2.drawRect(aRect.x + anOffset.x, aRect.y + anOffset.y, aRect.width, aRect.height);
            }
            ++i;
        }
    }

    public void dragStart(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        this.itsStartPoint = evt.getPoint();
        this.itsDragPoint = null;
        this.itsIsDragging = true;
    }

    public void drag(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        if (this.itsDragPoint == null) {
            DiagramComponent aComp = theDiagram.findComponent(evt.getPoint());
            if (!theDiagram.getSelectionModel().isSelected(aComp)) {
                theDiagram.clearSelection();
                theDiagram.getSelectionModel().addSelectedObject(aComp);
            }
        } else {
            this.paintDragOutline(theDiagram, g2, this.itsDragPoint);
        }
        this.itsDragPoint = evt.getPoint();
        this.paintDragOutline(theDiagram, g2, this.itsDragPoint);
    }

    public void dragEnd(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (!this.itsIsDragging) {
            return;
        }
        if (this.itsDragPoint != null) {
            this.paintDragOutline(theDiagram, g2, this.itsDragPoint);
        }
        Point anOffset = (Point)this.itsStartPoint.clone();
        anOffset.x = evt.getPoint().x - anOffset.x;
        anOffset.y = evt.getPoint().y - anOffset.y;
        Object[] aList = theDiagram.getSelection();
        int i = 0;
        while (i < aList.length) {
            if (aList[i] instanceof DiagramComponent) {
                DiagramComponent aComp = (DiagramComponent)aList[i];
                Rectangle aRect = theDiagram.getRectangle(aComp);
                aComp.setLocation(aRect.x + anOffset.x, aRect.y + anOffset.y);
            }
            ++i;
        }
        this.cleanup();
        theDiagram.repaintLater();
    }

    public void dragAbort(Diagram theDiagram, Graphics2D g2, MouseEvent evt) {
        if (this.itsDragPoint != null) {
            this.paintDragOutline(theDiagram, g2, this.itsDragPoint);
        }
        this.cleanup();
    }
}

