/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc.diagram;

import com.syllogic.jfc.Diagram;
import com.syllogic.jfc.diagram.DiagramSelectionModel;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultDiagramSelectionModel
implements DiagramSelectionModel {
    private Diagram itsDiagram;
    private Vector itsChangeListeners = new Vector();
    private Vector itsSelection = new Vector();

    public DefaultDiagramSelectionModel(Diagram theDiagram) {
        this.itsDiagram = theDiagram;
    }

    public void addChangeListener(ChangeListener l) {
        if (!this.itsChangeListeners.contains(l)) {
            this.itsChangeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.itsChangeListeners.contains(l)) {
            this.itsChangeListeners.remove(l);
        }
    }

    protected void fireChangeEvent() {
        ChangeEvent anEvent = new ChangeEvent(this.itsDiagram);
        Vector aVector = (Vector)this.itsChangeListeners.clone();
        int i = 0;
        while (i < aVector.size()) {
            ((ChangeListener)aVector.elementAt(i)).stateChanged(anEvent);
            ++i;
        }
    }

    public void clearSelection() {
        this.itsSelection.clear();
        this.fireChangeEvent();
    }

    public boolean isSelectionEmpty() {
        return this.itsSelection.isEmpty();
    }

    public boolean isSelected(Object theObject) {
        return this.itsSelection.contains(theObject);
    }

    public void addSelectedObject(Object theObject) {
        if (!this.itsSelection.contains(theObject)) {
            this.itsSelection.add(theObject);
        }
        this.fireChangeEvent();
    }

    public void removeSelectedObject(Object theObject) {
        if (this.itsSelection.contains(theObject)) {
            this.itsSelection.remove(theObject);
        }
        this.fireChangeEvent();
    }

    public Object[] getSelection() {
        return this.itsSelection.toArray();
    }
}

