/*
 * Decompiled with CFR 0.152.
 */
package com.syllogic.jfc;

import com.syllogic.jfc.diagram.ClickHandler;
import com.syllogic.jfc.diagram.ComponentRenderer;
import com.syllogic.jfc.diagram.DefaultComponentRenderer;
import com.syllogic.jfc.diagram.DefaultDiagramModel;
import com.syllogic.jfc.diagram.DefaultDiagramSelectionModel;
import com.syllogic.jfc.diagram.DefaultRelationRenderer;
import com.syllogic.jfc.diagram.DiagramComponent;
import com.syllogic.jfc.diagram.DiagramModel;
import com.syllogic.jfc.diagram.DiagramRelation;
import com.syllogic.jfc.diagram.DiagramSelectionModel;
import com.syllogic.jfc.diagram.DragHandler;
import com.syllogic.jfc.diagram.RelationRenderer;
import com.syllogic.jfc.event.DiagramEvent;
import com.syllogic.jfc.event.DiagramListener;
import com.syllogic.jfc.event.DiagramModelEvent;
import com.syllogic.jfc.event.DiagramModelListener;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class Diagram
extends JPanel {
    private DiagramModel itsModel;
    private CellRendererPane itsRendererPane = new CellRendererPane();
    private HashMap itsCRenderers = new HashMap();
    private HashMap itsRRenderers = new HashMap();
    private MouseListener itsMouseListener = new MyMouseListener();
    private MouseMotionListener itsMouseMotionListener = new MyMouseMotionListener();
    private DiagramModelListener itsDiagramModelListener = new MyDiagramModelListener();
    private JViewport itsViewport = new JViewport();
    private HashMap itsRectangles = new HashMap();
    private DiagramSelectionModel itsSelectionModel = new DefaultDiagramSelectionModel(this);
    private ArrayList itsDragHandlers = new ArrayList();
    private DragHandler itsDragHandler = null;
    private ArrayList itsClickHandlers = new ArrayList();
    private ArrayList listenerList = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;

    private void init() {
        this.add(this.itsRendererPane);
        this.itsCRenderers.put(class$java$lang$Object == null ? (class$java$lang$Object = Diagram.class$("java.lang.Object")) : class$java$lang$Object, new DefaultComponentRenderer());
        this.itsRRenderers.put(class$java$lang$Object == null ? (class$java$lang$Object = Diagram.class$("java.lang.Object")) : class$java$lang$Object, new DefaultRelationRenderer());
        this.addMouseListener(this.itsMouseListener);
        this.addMouseMotionListener(this.itsMouseMotionListener);
    }

    public DiagramModel getModel() {
        return this.itsModel;
    }

    public void setModel(DiagramModel theModel) {
        if (this.itsModel != null) {
            this.itsModel.removeDiagramModelListener(this.itsDiagramModelListener);
        }
        this.itsModel = theModel;
        if (this.itsModel != null) {
            this.itsModel.addDiagramModelListener(this.itsDiagramModelListener);
        }
        if (this.isVisible()) {
            this.updateUI();
        }
    }

    public Diagram(DiagramModel theModel) {
        super(null);
        this.setModel(theModel);
        this.init();
    }

    public Diagram() {
        this(new DefaultDiagramModel());
    }

    public ComponentRenderer getComponentRenderer(Class theClass) {
        ComponentRenderer aRenderer = (ComponentRenderer)this.itsCRenderers.get(theClass);
        while (aRenderer == null) {
            theClass = theClass.getSuperclass();
            aRenderer = (ComponentRenderer)this.itsCRenderers.get(theClass);
        }
        return aRenderer;
    }

    public RelationRenderer getRelationRenderer(Class theClass) {
        RelationRenderer aRenderer = (RelationRenderer)this.itsRRenderers.get(theClass);
        while (aRenderer == null) {
            theClass = theClass.getSuperclass();
            aRenderer = (RelationRenderer)this.itsRRenderers.get(theClass);
        }
        return aRenderer;
    }

    public void setComponentRenderer(Class theClass, ComponentRenderer theRenderer) {
        this.itsCRenderers.put(theClass, theRenderer);
    }

    public void setRelationRenderer(Class theClass, RelationRenderer theRenderer) {
        this.itsRRenderers.put(theClass, theRenderer);
    }

    public Rectangle getRectangle(DiagramComponent theComp) {
        Object o = this.itsRectangles.get(theComp);
        return o == null ? null : (Rectangle)o;
    }

    public DiagramComponent findComponent(int x, int y) {
        Iterator it = this.itsRectangles.keySet().iterator();
        while (it.hasNext()) {
            DiagramComponent aComp = (DiagramComponent)it.next();
            Rectangle aRect = (Rectangle)this.itsRectangles.get(aComp);
            if (!aRect.contains(x, y)) continue;
            return aComp;
        }
        return null;
    }

    public DiagramComponent findComponent(Point p) {
        return this.findComponent(p.x, p.y);
    }

    public DiagramRelation findRelation(int x, int y) {
        if (this.itsModel == null) {
            return null;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle aRect = new Rectangle(x - 2, y - 2, 5, 5);
        Iterator it = this.itsModel.getRelations();
        while (it.hasNext()) {
            Rectangle aRect1;
            Rectangle aRect0;
            DiagramRelation aRel = (DiagramRelation)it.next();
            RelationRenderer aRenderer = this.getRelationRenderer(aRel.getClass());
            if (!g2.hit(aRect, aRenderer.getShape(aRel, aRect0 = (Rectangle)this.itsRectangles.get(aRel.getFromComponent()), aRect1 = (Rectangle)this.itsRectangles.get(aRel.getToComponent()), this.itsSelectionModel.isSelected(aRel)), false)) continue;
            g2.dispose();
            return aRel;
        }
        g2.dispose();
        return null;
    }

    public DiagramRelation findRelation(Point p) {
        return this.findRelation(p.x, p.y);
    }

    public void setSelectionModel(DiagramSelectionModel theSelectionModel) {
        this.itsSelectionModel = theSelectionModel;
    }

    public DiagramSelectionModel getSelectionModel() {
        return this.itsSelectionModel;
    }

    public Object[] getSelection() {
        return this.itsSelectionModel.getSelection();
    }

    public void clearSelection() {
        this.itsSelectionModel.clearSelection();
        this.repaint();
    }

    public void setSelection(Object[] theSelection) {
        this.itsSelectionModel.clearSelection();
        int i = 0;
        while (i < theSelection.length) {
            this.itsSelectionModel.addSelectedObject(theSelection[i]);
            ++i;
        }
        this.repaint();
    }

    public void addDragHandler(DragHandler theHandler) {
        if (!this.itsDragHandlers.contains(theHandler)) {
            this.itsDragHandlers.add(theHandler);
        }
    }

    public void removeDragHandler(DragHandler theHandler) {
        if (this.itsDragHandlers.contains(theHandler)) {
            ((AbstractCollection)this.itsDragHandlers).remove(theHandler);
        }
    }

    protected void dragAbort(MouseEvent evt) {
        if (this.itsDragHandler != null) {
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            this.itsDragHandler.dragAbort(this, g2, evt);
            g2.dispose();
            this.itsDragHandler = null;
        }
    }

    protected void dragAbort() {
        this.dragAbort(null);
    }

    public void addClickHandler(ClickHandler theHandler) {
        if (!this.itsClickHandlers.contains(theHandler)) {
            this.itsClickHandlers.add(theHandler);
        }
    }

    public void removeClickHandler(ClickHandler theHandler) {
        if (this.itsClickHandlers.contains(theHandler)) {
            ((AbstractCollection)this.itsClickHandlers).remove(theHandler);
        }
    }

    protected void paintComponent(Graphics g) {
        Object aRenderer;
        super.paintComponent(g);
        if (this.itsModel == null) {
            return;
        }
        this.itsRectangles.clear();
        Iterator it = this.itsModel.getComponents();
        while (it.hasNext()) {
            DiagramComponent aComp = (DiagramComponent)it.next();
            aRenderer = this.getComponentRenderer(aComp.getClass());
            JComponent aHelp = aRenderer.getComponent(aComp, this.itsSelectionModel.isSelected(aComp));
            Rectangle aRect = new Rectangle(aComp.getLocation(), aHelp.getPreferredSize());
            this.itsRectangles.put(aComp, aRect);
            this.itsRendererPane.paintComponent(g, aHelp, this, aRect.x, aRect.y, aRect.width, aRect.height, true);
        }
        it = this.itsModel.getRelations();
        while (it.hasNext()) {
            DiagramRelation aRel = (DiagramRelation)it.next();
            aRenderer = this.getRelationRenderer(aRel.getClass());
            Rectangle aRect0 = (Rectangle)this.itsRectangles.get(aRel.getFromComponent());
            Rectangle aRect1 = (Rectangle)this.itsRectangles.get(aRel.getToComponent());
            Point view = this.itsViewport.getViewPosition();
            Rectangle aNewRect0 = new Rectangle(aRect0.x + view.x, aRect0.y + view.y, aRect0.width, aRect0.height);
            Rectangle aNewRect1 = new Rectangle(aRect1.x + view.x, aRect1.y + view.y, aRect1.width, aRect1.height);
            JComponent aHelp = aRenderer.getComponent(aRel, aNewRect0, aNewRect1, this.itsSelectionModel.isSelected(aRel));
            this.itsRendererPane.paintComponent(g, aHelp, this, this.getBounds());
        }
    }

    public void addDiagramListener(DiagramListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
        }
    }

    public void removeDiagramListener(DiagramListener l) {
        if (this.listenerList.contains(l)) {
            ((AbstractCollection)this.listenerList).remove(l);
        }
    }

    public void fireRelationRequested(DiagramComponent theFromComponent, DiagramComponent theToComponent) {
        DiagramEvent anEvent = new DiagramEvent((Object)this, theFromComponent, theToComponent);
        ArrayList aList = (ArrayList)this.listenerList.clone();
        int i = 0;
        while (i < aList.size()) {
            DiagramListener aListener = (DiagramListener)aList.get(i);
            aListener.relationRequested(anEvent);
            ++i;
        }
    }

    public void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Diagram.this.repaint();
            }
        });
    }

    public void setViewport(JViewport viewport) {
        this.itsViewport = viewport;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyDiagramModelListener
    implements DiagramModelListener {
        MyDiagramModelListener() {
        }

        public void componentsAdded(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }

        public void componentsRemoved(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }

        public void relationsAdded(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }

        public void relationsRemoved(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }

        public void componentsChanged(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }

        public void relationsChanged(DiagramModelEvent e) {
            Diagram.this.dragAbort();
            Diagram.this.repaintLater();
        }
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (Diagram.this.itsDragHandler != null) {
                Graphics2D g2 = (Graphics2D)Diagram.this.getGraphics();
                Diagram.this.itsDragHandler.drag(Diagram.this, g2, e);
                g2.dispose();
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int i = 0;
            while (i < Diagram.this.itsDragHandlers.size()) {
                DragHandler aHandler = (DragHandler)Diagram.this.itsDragHandlers.get(i);
                if (aHandler.isDragPoint(Diagram.this, e)) {
                    Diagram.this.itsDragHandler = aHandler;
                    Diagram.this.itsDragHandler.dragStart(Diagram.this, null, e);
                    break;
                }
                ++i;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (Diagram.this.itsDragHandler != null) {
                Graphics2D g2 = (Graphics2D)Diagram.this.getGraphics();
                Diagram.this.itsDragHandler.dragEnd(Diagram.this, g2, e);
                Diagram.this.itsDragHandler = null;
                g2.dispose();
            }
        }

        public void mouseClicked(MouseEvent e) {
            Diagram.this.dragAbort();
            int i = 0;
            while (i < Diagram.this.itsClickHandlers.size()) {
                ClickHandler aHandler = (ClickHandler)Diagram.this.itsClickHandlers.get(i);
                aHandler.click(Diagram.this, e);
                ++i;
            }
        }
    }
}

