/*
 * Decompiled with CFR 0.152.
 */
package cocon;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class CoUtil {
    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("ERROR: Cannot set native LAF: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("ERROR: cannot set Java LAF: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e) {
            System.out.println("ERROR: cannot set Motif LAF: ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    public static ImageIcon getIcon(String fileName, Class[] classes) {
        URL iconUrl = null;
        for (int i = 0; i < classes.length && (iconUrl = classes[i].getResource(fileName)) == null && (iconUrl = classes[i].getResource("images/".concat(String.valueOf(String.valueOf(fileName))))) == null && (iconUrl = classes[i].getResource("/cocon/images/".concat(String.valueOf(String.valueOf(fileName))))) == null && (iconUrl = classes[i].getResource("/images/".concat(String.valueOf(String.valueOf(fileName))))) == null; ++i) {
        }
        if (iconUrl == null) {
            if (!fileName.equals("empty.gif") && !fileName.equals("default.gif")) {
                return CoUtil.getIcon("empty.gif", classes);
            }
            if (!fileName.equals("default.gif")) {
                return CoUtil.getIcon("default.gif", classes);
            }
        }
        if (iconUrl != null) {
            return new ImageIcon(iconUrl);
        }
        return null;
    }

    public static double calcInformation(double[] distribution) {
        int i;
        double information = 0.0;
        for (i = 0; i < distribution.length; ++i) {
            information += distribution[i];
        }
        if (information <= 0.0) {
            return 0.0;
        }
        i = 0;
        while (i < distribution.length) {
            int n = i++;
            distribution[n] = distribution[n] / information;
        }
        information = 0.0;
        for (i = 0; i < distribution.length; ++i) {
            if (distribution[i] == 0.0) continue;
            information += distribution[i] * Math.log(distribution[i]);
        }
        information /= (double)distribution.length;
        return -(information /= Math.log(2.0));
    }

    public static double calcRelativeInformation(double[] distr1, double[] distr2) {
        return CoUtil.calcInformation(distr1);
    }

    public static boolean isSerializable(Object object) {
        if (object == null) {
            System.err.println("ERROR: isSerializable() NULL is specified as parameters.");
            return false;
        }
        if (!(object instanceof Serializable)) {
            System.err.println("ERROR: isSerializable() Object must implement Serializable interface.");
            return false;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("~Co~", ".tmp", new File(System.getProperty("user.dir", null)));
            tempFile.deleteOnExit();
        }
        catch (IOException ioe) {
            System.err.println("ERROR: isSerializable() Cannot create temporaty data file.");
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            ObjectOutputStream out_o = new ObjectOutputStream(out);
            out_o.writeObject(object);
            out_o.flush();
            out_o.flush();
            out_o.close();
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("ERROR: isSerializable() Cannot serialize object during file writing.");
            ioe.printStackTrace();
            boolean out_o = false;
            return out_o;
        }
        System.err.println("ERROR: isSerializable() Object has been successfully serialized and written into file.");
        try {
            FileInputStream in = new FileInputStream(tempFile);
            ObjectInputStream in_o = new ObjectInputStream(in);
            Object new_object = null;
            try {
                new_object = in_o.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("ERROR: isSerializable() Unknown class during reading the serialized object state.");
                cnfe.printStackTrace();
            }
            in_o.close();
            in.close();
        }
        catch (IOException ioe) {
            System.err.println("ERROR: isSerializable() Cannot serialize object during file reading.");
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        System.err.println("ERROR: isSerializable() Object has been successfully serialized and read from file.");
        return true;
    }

    public static void appendStringToFile(String fileName, String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(fileName, true));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    public static void appendStringToFile(File file, String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file.getPath(), true));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }
}

