/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import javax.swing.JFileChooser;
import miningmart.hci.gui.main.Application;

public class LaunchMiningMart {
    private static void print(String s) {
        System.out.println(s);
    }

    private static boolean mkdir(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            LaunchMiningMart.print("Creating directory '" + dir + "' ...");
            if (file.mkdir()) {
                LaunchMiningMart.print("Done!");
                return true;
            }
            LaunchMiningMart.print("Failed!");
            return false;
        }
        if (!file.isDirectory()) {
            LaunchMiningMart.print("Error: A file with target directory name '" + dir + "' exists!");
            return false;
        }
        return true;
    }

    private static void readPropertiesFile(File file) {
        try {
            String line;
            LineNumberReader lnr = new LineNumberReader(new FileReader(file));
            while ((line = lnr.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                int index = line.indexOf(61);
                if (index > -1) {
                    String var = line.substring(0, index).trim();
                    String val = line.substring(index + 1).trim();
                    System.setProperty(var, val);
                    continue;
                }
                if (line.length() <= 0) continue;
                LaunchMiningMart.print("Warning: Skipping line '" + line + "' in property file!");
            }
        }
        catch (IOException e) {
            System.err.println("IOException when trying to read properties file!\n");
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static File askForMmHome() {
        File mmHomeF;
        String mmHome = System.getProperty("MM_HOME");
        if (mmHome != null && mmHome.length() != 0 && (mmHomeF = new File(mmHome)).exists() && mmHomeF.isDirectory()) {
            return mmHomeF.getAbsoluteFile();
        }
        JFileChooser jfd = new JFileChooser();
        jfd.setDialogTitle("Please specify the MiningMart base directory!");
        jfd.setFileSelectionMode(1);
        LaunchMiningMart.print("Global MiningMart base directory not found, please select from dialog!");
        if (jfd.showOpenDialog(null) != 0) {
            return null;
        }
        File r = jfd.getSelectedFile();
        if (!r.exists() || !r.isDirectory()) {
            LaunchMiningMart.print("No directory found at the specified location!");
            return null;
        }
        LaunchMiningMart.print("Selected directory: " + r.getAbsolutePath());
        return r;
    }

    public static void main(String[] args) {
        String propertyFile;
        File file;
        LaunchMiningMart.print("MiningMart launcher: Checking if environment variables are set.");
        String mmLocal = System.getProperty("MM_LOCAL");
        if (mmLocal == null || mmLocal.length() == 0) {
            mmLocal = System.getProperty("user.home");
            if (mmLocal != null) {
                mmLocal = String.valueOf(mmLocal) + File.separator + ".mmart";
                LaunchMiningMart.print("Variable 'MM_LOCAL' not set. Trying to use the default value '" + mmLocal + "'");
            } else {
                LaunchMiningMart.print("Variable 'MM_LOCAL' not set and 'user.home' not available to determine default directory.");
                LaunchMiningMart.print("Please set the variable 'MM_LOCAL' to a local directory the MiningMart has write access to!");
                System.exit(-1);
            }
        }
        mmLocal = mmLocal.trim();
        String mmTemp = String.valueOf(mmLocal) + File.separator + "temp" + File.separator;
        String mmLog = String.valueOf(mmLocal) + File.separator + "log";
        boolean success = LaunchMiningMart.mkdir(mmLocal);
        if (success) {
            boolean bl = success = success && LaunchMiningMart.mkdir(mmTemp);
            if (success) {
                boolean bl2 = success = success && LaunchMiningMart.mkdir(mmLog);
            }
        }
        if (!success) {
            LaunchMiningMart.print("Could not create local directories!\n");
            System.exit(1);
        }
        if (!(file = new File(propertyFile = String.valueOf(mmLocal) + File.separator + "properties")).exists()) {
            LaunchMiningMart.print("No property file found at '" + propertyFile + "' !");
            File mmHome = LaunchMiningMart.askForMmHome();
            if (mmHome == null) {
                LaunchMiningMart.print("No valid choice of global MiningMart base directory, exiting!");
                System.exit(4);
            }
            LaunchMiningMart.print("Selection: '" + mmHome + "', writing to a new property file!");
            try {
                FileWriter fw = new FileWriter(file);
                fw.write("# The path to the MiningMart system directory:\n");
                fw.write("MM_HOME=" + mmHome.getAbsolutePath() + "\n\n");
                fw.write("# The path to the temporary directory:\n");
                fw.write("TEMP_DIR=" + mmTemp + "\n\n");
                fw.write("# The path to the log files:\n");
                fw.write("LOG_FILES=" + mmLog + "\n\n");
                fw.write("# The print verbosity:\n");
                fw.write("PRINT_VERBOSITY=15\n\n");
                fw.write("# Datbase configuration file:\n");
                fw.write("DB_CONFIG_PATH=" + mmLocal + File.separator + "db.config\n\n");
                fw.write("# Alias used by the HCI:\n");
                fw.write("spin.home=" + mmHome + "\n\n");
                fw.write("# A reference used by the compiler to find binaries used by some operators:\n");
                fw.write("ML_HOME=" + mmHome + File.separator + "compiler" + File.separator + "runtime" + File.separator + "\n");
                fw.close();
            }
            catch (IOException e) {
                System.err.println("Failed!");
                e.printStackTrace();
                System.exit(3);
            }
        }
        LaunchMiningMart.print("Property file found at '" + propertyFile + "' !");
        LaunchMiningMart.readPropertiesFile(new File(propertyFile));
        Application.main(new String[0]);
    }
}

