/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.visualization;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import javax.swing.JLabel;
import subgroupmining.Subgroup;
import subgroupmining.visualization.TwoKeyPlot;

class VisualSubgroup
extends JLabel {
    RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    NumberFormat nf = NumberFormat.getInstance();
    boolean selected = false;
    Subgroup sg;
    int x = 0;
    int y = 0;
    float share = 5.0f;
    Ellipse2D circle = new Ellipse2D.Float(0.0f, 0.0f, this.share, this.share);

    public VisualSubgroup(Subgroup sg, double maxconf, int mean) {
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.sg = sg;
        double d = sg.getConfidence();
        if (mean == 1) {
            d /= maxconf;
        }
        this.setToolTipText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<html> <p> Quality: ").concat(String.valueOf(this.nf.format(sg.getQuality())))).concat(String.valueOf("</p>"))).concat(String.valueOf("<p> Strength: "))).concat(String.valueOf(this.nf.format(d)))).concat(String.valueOf("</p>"))).concat(String.valueOf("<p> Support: "))).concat(String.valueOf(this.nf.format(sg.getConceptShare())))).concat(String.valueOf("</p>"))).concat(String.valueOf("<p> "))).concat(String.valueOf(sg.conceptToString()))).concat(String.valueOf("</p> </html>")));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setStroke(new BasicStroke(1.0f));
        int s = (int)this.sg.getQuality() * 10;
        int c = this.sg.getCluster();
        if (c > 0) {
            g.setColor(this.clcolor(c));
        } else {
            g.setColor(Color.black);
        }
        g.fill(this.circle);
        if (this.sg == TwoKeyPlot.current) {
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.yellow);
            g.draw(this.circle);
        } else {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.black);
            g.draw(this.circle);
        }
    }

    private Color clcolor(int c) {
        Color col = c == 1 ? Color.red : (c == 2 ? Color.cyan : (c == 3 ? Color.white : (c == 4 ? Color.magenta : (c == 5 ? Color.blue : (c == 6 ? Color.pink : (c == 7 ? Color.orange : (c == 8 ? Color.blue : (c == 9 ? Color.yellow : Color.darkGray))))))));
        return col;
    }
}

