/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.visualization;

import java.awt.BasicStroke;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import subgroupmining.AttributeMeta;
import subgroupmining.DataChooserPanel;
import subgroupmining.TableMeta;
import subgroupmining.visualization.Bar;
import subgroupmining.visualization.Triple;

public class BarPlot
extends JPanel {
    float x_origin = 25.0f;
    float y_origin = 210.0f;
    Vector vec;
    boolean[] discretes = new boolean[100];
    int ndisc;
    int popS;
    public int type;
    boolean plustarget;
    boolean conti;
    public int mode;
    public Checkbox cb1;
    public Checkbox cb2;
    public Checkbox cb3;
    public JButton jButtonD;
    NumberFormat nf = NumberFormat.getInstance();
    private String table;
    private String att;
    private DataChooserPanel dcp;

    public BarPlot(Vector vec, int type, boolean plustarget, int popS, boolean conti, String table, String att, DataChooserPanel dcp) {
        this.vec = vec;
        this.popS = popS;
        this.type = type;
        this.plustarget = plustarget;
        this.conti = conti;
        this.setLayout(null);
        this.table = table;
        this.att = att;
        this.dcp = dcp;
        this.nf.setMaximumFractionDigits(2);
        if (type > 1) {
            for (int i = 0; i < vec.size(); ++i) {
                this.discretes[i] = false;
            }
        }
        this.ndisc = 0;
    }

    public void paintComponent(Graphics graphics) {
        int i;
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        Line2D.Float y_axis = new Line2D.Float(this.x_origin, this.y_origin, this.x_origin, this.y_origin - (float)200);
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.black);
        g.draw(y_axis);
        g.setStroke(new BasicStroke(1.0f));
        g.drawString("  0", this.x_origin - (float)24, this.y_origin);
        if (!this.conti) {
            g.drawString("100", this.x_origin - (float)24, this.y_origin - (float)200);
        }
        for (i = 30; i < 210; i += 40) {
            g.drawLine((int)(this.x_origin - (float)2), i, (int)(this.x_origin + (float)2), i);
        }
        for (i = 50; i < 210; i += 40) {
            g.drawLine((int)(this.x_origin - (float)4), i, (int)(this.x_origin + (float)4), i);
            if (this.conti) continue;
            g.drawString(String.valueOf("").concat(String.valueOf((i - 10) / 2)), this.x_origin - (float)24, this.y_origin - (float)i + (float)10);
        }
        this.valueChart(g);
    }

    void valueChart(Graphics2D g) {
        int j;
        System.out.println("BAR chart");
        int nr = this.vec.size();
        int w = Math.min(575 / nr, 51) - 1;
        boolean text = w > 20;
        boolean at1 = this.cb1.getState();
        boolean at2 = this.plustarget && this.cb2.getState();
        boolean at3 = this.plustarget && this.cb3.getState();
        String val = "";
        int count = 0;
        double count1 = 0.0;
        double av = 0.0;
        int targ = 0;
        int ta = 0;
        if (!this.conti && (at2 || at3)) {
            for (j = 0; j < nr; ++j) {
                ta += ((Integer)((Triple)this.vec.get((int)j)).o3).intValue();
            }
        }
        if (this.conti) {
            for (j = 0; j < nr; ++j) {
                double d = (Double)((Triple)this.vec.get((int)j)).o3;
                double f = ((Integer)((Triple)this.vec.get((int)j)).o2).doubleValue();
                av += d * f / (double)this.popS;
            }
        }
        if (at2) {
            targ = ta;
        }
        if (this.mode == 1) {
            Triple.index = 2;
        } else if (this.mode == 2 && this.type > 1) {
            Triple.index = 1;
        } else if (this.mode == 2 && this.type == 1) {
            Triple.index = 0;
        } else if (this.mode == 3 && !this.conti) {
            Triple.index = 3;
        } else if (this.mode == 3 && this.conti) {
            Triple.index = 4;
        }
        Collections.sort(this.vec);
        if (this.ndisc > 0) {
            count = 0;
            count1 = 0.0;
            for (int k = 0; k < nr; ++k) {
                Triple trip = (Triple)this.vec.get(nr - k - 1);
                count += ((Integer)trip.o2).intValue();
                if (this.plustarget && !this.conti) {
                    count1 += ((Integer)trip.o3).doubleValue();
                } else if (this.plustarget && this.conti) {
                    count1 += ((Integer)trip.o2).doubleValue() * (Double)trip.o3;
                }
                if (this.discretes[k]) break;
            }
            if (this.plustarget && this.conti && count > 0) {
                count1 /= (double)count;
            }
            System.out.println(String.valueOf(String.valueOf(String.valueOf(" C: ").concat(String.valueOf(count))).concat(String.valueOf(" C1: "))).concat(String.valueOf(count1)));
        }
        for (int i = 0; i < nr; ++i) {
            Triple trip = (Triple)this.vec.get(nr - i - 1);
            val = this.type == 1 ? (String)trip.o1 : ((Double)trip.o1).toString();
            if (this.ndisc == 0) {
                count = (Integer)trip.o2;
                if (!this.plustarget) {
                    count1 = 0.0;
                } else if (!this.conti) {
                    count1 = ((Integer)trip.o3).doubleValue();
                } else if (this.conti) {
                    count1 = (Double)trip.o3;
                }
            }
            Bar bar = new Bar(i, w, text, this.popS, val, count, count1, targ, at1, av, this.conti);
            if (i == 0) {
                bar.setSize(w + 23, 240);
                bar.setLocation(29, 0);
            } else {
                bar.setSize(w + 3, 240);
                bar.setLocation(i * (w + 3) + 49, 0);
            }
            bar.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    BarPlot.this.bar_mouseClicked(e);
                }
            });
            this.add(bar);
            if (i >= nr - 1 || !this.discretes[i]) continue;
            count = 0;
            count1 = 0.0;
            for (int k = i + 1; k < nr; ++k) {
                trip = (Triple)this.vec.get(nr - k - 1);
                count += ((Integer)trip.o2).intValue();
                if (this.plustarget && !this.conti) {
                    count1 += ((Integer)trip.o3).doubleValue();
                } else if (this.plustarget && this.conti) {
                    count1 += ((Integer)trip.o2).doubleValue() * (Double)trip.o3;
                }
                if (this.discretes[k]) break;
            }
            if (this.plustarget && this.conti && count > 0) {
                count1 /= (double)count;
            }
            System.out.println(String.valueOf(String.valueOf(String.valueOf(" C: ").concat(String.valueOf(count))).concat(String.valueOf(" C1: "))).concat(String.valueOf(count1)));
        }
        if (at3) {
            float p0 = 0.0f;
            if (!this.conti) {
                p0 = (float)ta / (float)this.popS;
            }
            g.setColor(Color.red);
            int y0 = (int)(p0 * (float)200);
            if (this.conti) {
                y0 = 80;
            }
            g.setStroke(new BasicStroke(2.0f));
            g.drawLine((int)this.x_origin - 8, (int)this.y_origin - y0, (int)this.x_origin + (w + 3) * nr + 30, (int)this.y_origin - y0);
            g.setStroke(new BasicStroke(1.0f));
            float x0 = this.x_origin + (float)((w + 3) * nr) + (float)40;
            if (!this.conti) {
                g.drawString(String.valueOf("f(T): ").concat(String.valueOf(this.nf.format(p0 * (float)100))), x0, this.y_origin - (float)y0);
            } else {
                g.drawString(String.valueOf("Avg(T): ").concat(String.valueOf(this.nf.format(av))), x0, this.y_origin - (float)y0);
            }
        }
        this.validate();
    }

    void bar_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (this.type == 1) {
                JOptionPane.showMessageDialog(this, "Discretization is only possible for numerical attributes!");
                return;
            }
            if (this.mode != 2) {
                JOptionPane.showMessageDialog(this, "First sort by values before discretizing!");
                return;
            }
            Bar b0 = (Bar)e.getSource();
            int i = b0.init;
            if (this.discretes[i]) {
                this.discretes[i] = false;
                --this.ndisc;
            } else {
                this.discretes[i] = true;
                ++this.ndisc;
            }
            if (this.ndisc > 0) {
                this.jButtonD.setEnabled(true);
            } else {
                this.jButtonD.setEnabled(false);
            }
            this.removeAll();
            this.repaint();
            System.out.println(String.valueOf("#Discretes:  ").concat(String.valueOf(this.ndisc)));
            for (int j = 0; j < this.vec.size(); ++j) {
                if (!this.discretes[j]) continue;
                System.out.println(j);
            }
        }
    }

    public void saveD() {
        if (this.ndisc == 0) {
            JOptionPane.showMessageDialog(this, "No intervals defined!");
            return;
        }
        int nr = this.vec.size();
        if (!this.discretes[nr - 1]) {
            this.discretes[nr - 1] = true;
            ++this.ndisc;
        }
        System.out.println(String.valueOf("Number of intervals:  ").concat(String.valueOf(this.ndisc)));
        int k = 1;
        Vector<String> v = new Vector<String>();
        Vector<Integer> w = new Vector<Integer>();
        float max = 0.0f;
        float min = 0.0f;
        float d = 0.0f;
        if (this.type == 3) {
            max = this.dcp.getMax(this.table, this.att);
            min = this.dcp.getMin(this.table, this.att);
            d = (max - min) / (float)100;
        }
        for (int j = 0; j < nr - 1; ++j) {
            String value;
            if (!this.discretes[j]) continue;
            Triple trip = (Triple)this.vec.get(nr - j - 1);
            if (this.type == 2) {
                value = ((Double)trip.o1).toString();
            } else {
                Double vv = new Double(min + (float)j * d);
                value = vv.toString();
            }
            v.add(value);
            w.add(new Integer(j));
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Splitpoint ").concat(String.valueOf(k))).concat(String.valueOf(": "))).concat(String.valueOf(j + 1))).concat(String.valueOf(" Value: "))).concat(String.valueOf(value)));
            ++k;
        }
        this.dcp.storeDiscr(this.table, this.att, v, w);
        JOptionPane.showMessageDialog(this, "Discretization intervals stored.");
    }

    public void loadD() {
        AttributeMeta aM = this.dcp.getAttributeMeta(this.table, this.att);
        Vector v = aM.getDisc();
        Vector w = aM.getDiscInd();
        if (v == null) {
            TableMeta tM1;
            TableMeta tM = (TableMeta)this.dcp.db.metaDataMap.get(this.table);
            if (tM.metaflag && (tM1 = new TableMeta(this.table, this.dcp.db)).retrieve1Meta() == 1 && tM1.meta.get(this.att) != null) {
                v = ((AttributeMeta)tM1.meta.get(this.att)).getDisc();
                w = ((AttributeMeta)tM1.meta.get(this.att)).getDiscInd();
            }
        }
        if (v != null) {
            this.show(v, w);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf("No discretization intervals stored for ").concat(String.valueOf(this.att))).concat(String.valueOf(" !")));
        }
    }

    public void show(Vector v, Vector w) {
        int i;
        System.out.println(v.toString());
        System.out.println(w.toString());
        this.mode = 2;
        for (i = 0; i < 100; ++i) {
            this.discretes[i] = false;
        }
        this.ndisc = w.size();
        for (i = 0; i < this.ndisc; ++i) {
            int ind = (Integer)w.get(i);
            this.discretes[ind] = true;
        }
        this.removeAll();
        this.repaint();
    }
}

