/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining.assocrulevis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import subgroupmining.Subgroup;

public class XYPlot
extends JPanel {
    float x_origin = 10.0f;
    float y_origin = 320.0f;
    public int mean;
    public float p0 = 0.5f;
    public float maxconf = 1.0f;
    public Subgroup current;

    public XYPlot() {
        this.setLayout(null);
    }

    public void paintComponent(Graphics graphics) {
        int i;
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        float p1 = this.p0;
        if (this.mean == 1) {
            p1 /= this.maxconf;
        }
        Line2D.Float x_axis = new Line2D.Float(this.x_origin, this.y_origin, this.x_origin + (float)300, this.y_origin);
        Line2D.Float y_axis = new Line2D.Float(this.x_origin, this.y_origin, this.x_origin, this.y_origin - (float)300);
        Line2D.Float max1 = new Line2D.Float(this.x_origin, this.y_origin - (float)300, this.x_origin + this.p0 * (float)300, this.y_origin - (float)300);
        Line2D.Float max2 = new Line2D.Float(this.x_origin + this.p0 * (float)300, this.y_origin - (float)300, this.x_origin + (float)300, this.y_origin - this.p0 * (float)300);
        Line2D.Float max3 = new Line2D.Float(this.x_origin, this.y_origin - (float)300 * p1, this.x_origin + (float)300, this.y_origin - p1 * (float)300);
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.blue);
        g.draw(x_axis);
        g.setColor(Color.yellow);
        g.draw(y_axis);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.setColor(Color.red);
        g.setColor(Color.green);
        g.setColor(Color.black);
        for (i = 40; i < 330; i += 30) {
            g.drawLine(i, (int)(this.y_origin - (float)2), i, (int)(this.y_origin + (float)2));
        }
        for (i = 50; i < 310; i += 30) {
            g.drawLine((int)(this.x_origin - (float)2), i, (int)(this.x_origin + (float)2), i);
        }
        g.setColor(Color.blue);
        g.drawString("Support f(C)", this.x_origin + (float)70, this.y_origin - (float)10);
        g.setColor(Color.yellow);
        if (this.mean == 0) {
            g.drawString("Strength f(T|C)", this.x_origin - (float)8, 12.0f);
        } else {
            g.drawString("Strength: Avg(T|C) / max(S,Avg(T|S))", this.x_origin - (float)8, 12.0f);
        }
    }
}

