/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.NUMBER;
import subgroupmining.AttributeMeta;
import subgroupmining.QueryConstructor;

public class TableMeta
implements Serializable {
    private static final char pathSeparator = File.separatorChar;
    private static final File currentDir = new File(".");
    public Map meta = null;
    private final String table;
    private final Database db;
    public final boolean metaflag;

    private static final String metadataDirectory() throws IOException {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(currentDir.getCanonicalPath()).concat(String.valueOf(pathSeparator))).concat(String.valueOf("SubgroupMining"))).concat(String.valueOf(pathSeparator))).concat(String.valueOf("MetaData"));
    }

    protected int getInt(String key) {
        if (this.meta == null) {
            this.retrieveMeta();
        }
        return (Integer)this.meta.get(key);
    }

    public TableMeta(String table, Database db) {
        this.table = table;
        this.db = db;
        this.metaflag = this.hasMetadata();
        if (this.metaflag) {
            System.err.println(String.valueOf("Using metadata catalog for table ").concat(String.valueOf(table)));
        }
    }

    private final boolean hasMetadata() {
        try {
            boolean bl = this.db.getTableMetadata(this.table).hasMetadata();
            return bl;
        }
        catch (Throwable e) {
            System.err.println("WARNING: metadata catalog was not found.");
            boolean bl = false;
            return bl;
        }
    }

    public AttributeMeta getAttributeMeta(String name) {
        AttributeMeta am;
        if (this.meta == null) {
            this.retrieveMeta();
        }
        if ((am = (AttributeMeta)this.meta.get(name)) == null) {
            am = this.addAttribute(name);
            this.storeMeta();
        }
        return am;
    }

    public void retrieveMeta() {
        if (this.meta == null) {
            this.meta = new HashMap();
        }
        if (this.metaflag) {
            this.calcPopSize();
            return;
        }
        try {
            String file = new File(String.valueOf(String.valueOf(TableMeta.metadataDirectory()).concat(String.valueOf(pathSeparator))).concat(String.valueOf(this.table))).getCanonicalPath();
            System.out.println(String.valueOf(String.valueOf("Retrieving data from the file ").concat(String.valueOf(file))).concat(String.valueOf(" ... ")));
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(file));
            this.meta = (HashMap)input.readObject();
            input.close();
        }
        catch (Throwable e) {
            this.calcPopSize();
        }
    }

    public int retrieve1Meta() {
        try {
            String file = new File(String.valueOf(String.valueOf(TableMeta.metadataDirectory()).concat(String.valueOf(pathSeparator))).concat(String.valueOf(this.table))).getCanonicalPath();
            System.out.println(String.valueOf(String.valueOf("Retrieving data from the file ").concat(String.valueOf(file))).concat(String.valueOf(" ... ")));
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(file));
            this.meta = (HashMap)input.readObject();
            input.close();
        }
        catch (Throwable e) {
            int n = 0;
            return n;
        }
        return 1;
    }

    public void storeMeta() {
        if (this.meta == null || this.metaflag) {
            return;
        }
        this.store1Meta();
    }

    public void store1Meta() {
        System.out.println(String.valueOf(String.valueOf("Saving metadata for the table ").concat(String.valueOf(this.table))).concat(String.valueOf(" ... ")));
        if (!currentDir.exists()) {
            System.err.println("ERROR: can't get the current directory. Exiting ...");
            System.exit(-1);
        }
        try {
            String dir = TableMeta.metadataDirectory();
            File file = new File(String.valueOf(String.valueOf(dir).concat(String.valueOf(pathSeparator))).concat(String.valueOf(this.table)));
            boolean newDir = new File(dir).mkdirs();
            boolean newFile = file.createNewFile();
            System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Metadata file = ").concat(String.valueOf(file.getAbsoluteFile()))).concat(String.valueOf(" ("))).concat(String.valueOf(newDir ? "directory cretated, " : ""))).concat(String.valueOf(newFile ? "table file created" : "file existed"))).concat(String.valueOf(")")));
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(file.getAbsoluteFile()));
            if (this.meta != null) {
                output.writeObject(this.meta);
            }
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AttributeMeta addAttribute(String name) {
        AttributeMeta am = new AttributeMeta(name, this.table, this.metaflag);
        am.calculateMeta(this.db);
        this.meta.put(name, am);
        return am;
    }

    public void calcPopSize() {
        if (this.metaflag) {
            try {
                NUMBER rowCnt = this.db.getTableMetadata(this.table).getMetadata().getRowCnt();
                this.meta.put("***", new Integer(rowCnt.intValue()));
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("ERROR in TableMeta: can't execute calcPopSize(). Exiting ...");
                System.exit(-1);
            }
        }
        ResultSet rs = this.db.select(QueryConstructor.makePopSizeQuery(this.table));
        try {
            while (rs.next()) {
                this.meta.put("***", new Integer(rs.getInt(1)));
            }
            this.storeMeta();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

