/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import subgroupmining.CausalNet;
import subgroupmining.DataAccess;
import subgroupmining.DataChooserPanel;
import subgroupmining.HypothesisStore;
import subgroupmining.RelationGraph;
import subgroupmining.SearchManager;
import subgroupmining.SubgroupMiningFrame_AboutBox;
import subgroupmining.SubgroupMiningFrame_CSBox;
import subgroupmining.SubgroupMiningFrame_DSBox;
import subgroupmining.SubgroupMiningFrame_OVBox;
import subgroupmining.SubgroupMiningFrame_QPBox;
import subgroupmining.SubgroupMiningFrame_SPBox;
import subgroupmining.visualization.TwoKeyPlot;

public class SubgroupMiningFrame
extends JFrame {
    JPanel contentPane;
    JMenuBar menuBar1 = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem menuFileOpenTask = new JMenuItem();
    JMenuItem menuFileSaveTask = new JMenuItem();
    JMenuItem menuFileOpenRTask = new JMenuItem();
    JMenuItem menuFileSaveRTask = new JMenuItem();
    JMenuItem menuFileExit = new JMenuItem();
    JMenu menuHelp = new JMenu();
    JMenuItem menuHelpAbout = new JMenuItem();
    JMenuItem menuHelpOverview = new JMenuItem();
    JMenuItem menuHelpDataSelection = new JMenuItem();
    JMenuItem menuHelpSearchParameters = new JMenuItem();
    JMenuItem menuHelpQualityParameters = new JMenuItem();
    JMenuItem menuHelpClusterSuppress = new JMenuItem();
    JToolBar toolBar = new JToolBar();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JButton jButton3 = new JButton();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    ImageIcon image4;
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel parameterPanel = new JPanel();
    JPanel dataSelectionPanel = new JPanel();
    JPanel resultsPanel = new JPanel();
    JLabel minimumSupport = new JLabel();
    JTextField minConfidenceField = new JTextField();
    JLabel minimumQual = new JLabel();
    JTextField minQualField = new JTextField();
    JLabel minimumQualImp = new JLabel();
    JTextField minQualImpField = new JTextField();
    JLabel minimumQualExp = new JLabel();
    JTextField minQualExpField = new JTextField();
    JLabel minimumQualImpExp = new JLabel();
    JTextField minQualImpExpField = new JTextField();
    JLabel numberExp = new JLabel();
    JTextField numberExpField = new JTextField();
    JLabel minimumSim = new JLabel();
    JTextField minSimField = new JTextField();
    JLabel clusterF = new JLabel();
    JTextField clusterFField = new JTextField();
    JLabel extendedF = new JLabel();
    JTextField extendedFField = new JTextField();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField minSupportField = new JTextField();
    JTextField searchDepthField = new JTextField();
    JLabel numberHypotheses = new JLabel();
    JTextField numberHypothesesField = new JTextField();
    Database db;
    Database dbnew;
    HypothesisStore store = null;
    Map task = new HashMap();
    DataChooserPanel dcp;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea resultField = new JTextArea();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton visualizeButton = new JButton();
    JButton suppressButton = new JButton();
    JButton jButton4 = new JButton();
    String id = "zone_id";
    TwoKeyPlot twoKeyPlot = new TwoKeyPlot();
    SearchManager sm;
    int ncluster = 0;
    JLabel jLabel1 = new JLabel();
    JTextField expandLevelField = new JTextField();
    JLabel jLabel4 = new JLabel();
    JTextField currentLevelField = new JTextField();
    JPanel qualityPanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    JPanel jPanel1 = new JPanel();
    Border border2;
    TitledBorder titledBorder2;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JTable jTable1 = new JTable();

    public SubgroupMiningFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.image1 = new ImageIcon(Class.forName("subgroupmining.SubgroupMiningFrame").getResource("c_agent_off.gif"));
        this.image2 = new ImageIcon(Class.forName("subgroupmining.SubgroupMiningFrame").getResource("c_offer_on.gif"));
        this.image3 = new ImageIcon(Class.forName("subgroupmining.SubgroupMiningFrame").getResource("c_wanted_on.gif"));
        this.image4 = new ImageIcon(Class.forName("subgroupmining.SubgroupMiningFrame").getResource("c_article_on.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.border1 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.titledBorder1 = new TitledBorder(this.border1, "Quality");
        this.border2 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.titledBorder2 = new TitledBorder(this.border2, "Search Parameters");
        this.contentPane.setLayout(this.borderLayout1);
        this.setTitle("Multirelational Causal Subgroup Mining");
        this.statusBar.setText(" ");
        this.menuFile.setText("File");
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.fileExit_actionPerformed(e);
            }
        });
        this.menuFileOpenTask.setText("Open Task Definition");
        this.menuFileOpenTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.fileOpenTask_actionPerformed(e);
            }
        });
        this.menuFileSaveTask.setText("Save Task Definition");
        this.menuFileSaveTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.fileSaveTask_actionPerformed(e);
            }
        });
        this.menuFileOpenRTask.setText("Open Search Results");
        this.menuFileOpenRTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.fileOpenRTask_actionPerformed(e);
            }
        });
        this.menuFileSaveRTask.setText("Save Search Results");
        this.menuFileSaveRTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.fileSaveRTask_actionPerformed(e);
            }
        });
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        this.menuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpAbout_actionPerformed(e);
            }
        });
        this.menuHelpOverview.setText("Overview");
        this.menuHelpOverview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpOverview_actionPerformed(e);
            }
        });
        this.menuHelpDataSelection.setText("Data Selection");
        this.menuHelpDataSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpDataSelection_actionPerformed(e);
            }
        });
        this.menuHelpSearchParameters.setText("Search Parameters");
        this.menuHelpSearchParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpSearchParameters_actionPerformed(e);
            }
        });
        this.menuHelpQualityParameters.setText("Quality Parameters");
        this.menuHelpQualityParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpQualityParameters_actionPerformed(e);
            }
        });
        this.menuHelpClusterSuppress.setText("Cluster&Suppress");
        this.menuHelpClusterSuppress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.helpClusterSuppress_actionPerformed(e);
            }
        });
        this.jButton1.setIcon(this.image4);
        this.jButton1.setText("DB Connection");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton1.setToolTipText("Access Database");
        this.jButton2.setIcon(this.image1);
        this.jButton2.setText("New search");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.jButton2_actionPerformed(e);
            }
        });
        this.jButton2.setToolTipText("Start a new search space");
        this.jButton3.setIcon(this.image3);
        this.jButton3.setText("Search on");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.jButton3_actionPerformed(e);
            }
        });
        this.jButton3.setToolTipText("Expand search from current depth");
        this.minimumSupport.setToolTipText("Set Minimum Support");
        this.minimumSupport.setDisplayedMnemonic('S');
        this.minimumSupport.setText("Minimum Support");
        this.minConfidenceField.setText("0.1");
        this.parameterPanel.setLayout(this.gridBagLayout3);
        this.jLabel2.setToolTipText("Set minimum confidence value");
        this.jLabel2.setDisplayedMnemonic('C');
        this.jLabel2.setText("Minimum Confidence");
        this.minimumQual.setToolTipText("Set minimum quality value");
        this.minimumQual.setDisplayedMnemonic('Q');
        this.minimumQual.setText("Minimum Quality");
        this.minimumQualImp.setToolTipText("Set minimum quality improvement for specialization");
        this.minimumQualImp.setDisplayedMnemonic('I');
        this.minimumQualImp.setText("Minimum QualityImp");
        this.minimumQualExp.setToolTipText("Set minimum quality to be expanded");
        this.minimumQualExp.setDisplayedMnemonic('E');
        this.minimumQualExp.setText("Min. Expansion Quality");
        this.minimumQualImpExp.setToolTipText("Set minimum quality improvement to be expanded");
        this.minimumQualImpExp.setText("Min.Improvement ExpQual");
        this.numberExp.setToolTipText("Set number of hypotheses to be expanded");
        this.numberExp.setText("Number Expansions");
        this.minimumSim.setToolTipText("Set minimum overlap to be clustered");
        this.minimumSim.setText("Min. Cluster Overlap");
        this.extendedF.setToolTipText("Set Extended Search Option");
        this.extendedF.setText("Extended Search");
        this.clusterF.setToolTipText("Set Cluster Option for Refinement");
        this.clusterF.setText("Cluster Option");
        this.jLabel3.setToolTipText("Set search depth");
        this.jLabel3.setDisplayedMnemonic('D');
        this.jLabel3.setText("Search Depth");
        this.minSupportField.setText("0.01");
        this.minQualField.setText("3.0");
        this.minQualImpField.setText("2.0");
        this.searchDepthField.setText("2");
        this.minQualExpField.setText("0.0");
        this.minQualImpExpField.setText("0.0");
        this.numberExpField.setText("30");
        this.minSimField.setText("0.4");
        this.clusterFField.setText("0");
        this.extendedFField.setText("0");
        this.numberHypotheses.setToolTipText("Set number of best hypothesis to be retained");
        this.numberHypotheses.setDisplayedMnemonic('N');
        this.numberHypotheses.setText("Number Hypotheses");
        this.numberHypothesesField.setText("10");
        this.contentPane.setPreferredSize(new Dimension(600, 400));
        this.resultsPanel.setLayout(this.borderLayout2);
        this.resultField.setRows(1000);
        this.resultField.setMinimumSize(new Dimension(800, 600));
        this.visualizeButton.setIcon(this.image2);
        this.visualizeButton.setText("Cluster Subgroups");
        this.visualizeButton.setToolTipText("Successive clustering with decreased similarity threshold");
        this.visualizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.visualizeButton_actionPerformed(e);
            }
        });
        this.suppressButton.setIcon(this.image2);
        this.suppressButton.setText("Suppress Subgroups");
        this.suppressButton.setToolTipText("Bayesian net to suppress subgroups");
        this.suppressButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubgroupMiningFrame.this.suppressButton_actionPerformed(e);
            }
        });
        this.jButton4.setText("jButton4");
        this.jLabel4.setToolTipText("Change the current search level and search on from this level");
        this.jLabel4.setDisplayedMnemonic('L');
        this.jLabel4.setText("Current Level");
        this.currentLevelField.setText("0");
        this.qualityPanel.setBorder(this.titledBorder1);
        this.qualityPanel.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.toolBar.add(this.jButton1);
        this.toolBar.add(this.jButton2);
        this.toolBar.add(this.jButton3);
        this.toolBar.add(this.visualizeButton);
        this.toolBar.add(this.suppressButton);
        this.menuFile.add(this.menuFileOpenTask);
        this.menuFile.add(this.menuFileOpenRTask);
        this.menuFile.add(this.menuFileSaveTask);
        this.menuFile.add(this.menuFileSaveRTask);
        this.menuFile.add(this.menuFileExit);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuHelp.add(this.menuHelpOverview);
        this.menuHelp.add(this.menuHelpDataSelection);
        this.menuHelp.add(this.menuHelpSearchParameters);
        this.menuHelp.add(this.menuHelpQualityParameters);
        this.menuHelp.add(this.menuHelpClusterSuppress);
        this.menuBar1.add(this.menuFile);
        this.menuBar1.add(this.menuHelp);
        this.setJMenuBar(this.menuBar1);
        this.contentPane.add((Component)this.toolBar, "North");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.parameterPanel, "Parameters");
        this.parameterPanel.add((Component)this.qualityPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.qualityPanel.add((Component)this.minSupportField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumSupport, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minConfidenceField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minQualField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumQual, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minQualImpField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumQualImp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minQualExpField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumQualExp, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minQualImpExpField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumQualImpExp, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.qualityPanel.add((Component)this.minSimField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 25, 0));
        this.qualityPanel.add((Component)this.minimumSim, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.parameterPanel.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.searchDepthField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 25, 0));
        this.jPanel1.add((Component)this.numberHypotheses, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.currentLevelField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 25, 0));
        this.jPanel1.add((Component)this.numberHypothesesField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 20, 0));
        this.jPanel1.add((Component)this.extendedF, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.extendedFField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 20, 0));
        this.jPanel1.add((Component)this.clusterF, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.clusterFField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 20, 0));
        this.jPanel1.add((Component)this.numberExp, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.numberExpField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 20, 0));
        this.jTabbedPane1.add((Component)this.dataSelectionPanel, "Data Selection");
        this.jTabbedPane1.add((Component)this.resultsPanel, "Results");
        this.resultsPanel.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.add((Component)this.twoKeyPlot, "Visualization");
        this.jScrollPane1.getViewport().add((Component)this.resultField, null);
        this.setSize(850, 600);
    }

    public void fileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void fileOpenTask_actionPerformed(ActionEvent e) {
        if (this.db == null) {
            JOptionPane.showMessageDialog(this, "No database open: First access database!");
            return;
        }
        String path = null;
        FileDialog fd = new FileDialog((Frame)this, "Load a task specification", 0);
        fd.setDirectory("D:\\SubgroupMining\\Tasks\\");
        fd.show();
        String filename = fd.getFile();
        if (filename != null) {
            String dirname = fd.getDirectory();
            path = String.valueOf(dirname).concat(String.valueOf(filename));
            try {
                FileInputStream stream = new FileInputStream(path);
                ObjectInputStream input = new ObjectInputStream(stream);
                this.task = (HashMap)input.readObject();
                input.close();
                String odb = (String)this.task.get("db");
                if (!odb.equals(this.db.getHost())) {
                    JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf("Wrong current database: ").concat(String.valueOf(odb))).concat(String.valueOf(" needed")));
                } else {
                    this.restoreTask();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "No valid Task File");
            }
        }
        fd.dispose();
    }

    public void fileOpenRTask_actionPerformed(ActionEvent e) {
        if (this.db == null) {
            JOptionPane.showMessageDialog(this, "No database open: First access database!");
            return;
        }
        String path = null;
        FileDialog fd = new FileDialog((Frame)this, "Load search results and task specification", 0);
        fd.setDirectory("D:\\SubgroupMining\\Results\\");
        fd.show();
        String filename = fd.getFile();
        if (filename != null) {
            String dirname = fd.getDirectory();
            path = String.valueOf(dirname).concat(String.valueOf(filename));
            try {
                FileInputStream stream = new FileInputStream(path);
                ObjectInputStream input = new ObjectInputStream(stream);
                this.task = (HashMap)input.readObject();
                input.close();
                this.store = (HypothesisStore)this.task.get("hs");
                String odb = (String)this.task.get("db");
                if (!odb.equals(this.db.getHost())) {
                    JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf("Wrong current database: ").concat(String.valueOf(odb))).concat(String.valueOf(" needed")));
                } else {
                    this.restoreTask();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "No valid Result File");
            }
            this.startSearch(3);
        }
        fd.dispose();
    }

    public void fileSaveTask_actionPerformed(ActionEvent e) {
        String path = null;
        FileDialog fd = new FileDialog((Frame)this, "Save the task specification", 1);
        fd.setDirectory("D:\\SubgroupMining\\Tasks\\");
        fd.show();
        String filename = fd.getFile();
        if (filename != null) {
            String dirname = fd.getDirectory();
            path = String.valueOf(dirname).concat(String.valueOf(filename));
            try {
                FileOutputStream stream = new FileOutputStream(path);
                ObjectOutputStream output = new ObjectOutputStream(stream);
                this.task = new HashMap();
                this.task.put("db", this.db.getHost());
                Map object = this.generateTask();
                if (object != null) {
                    output.writeObject(object);
                    JOptionPane.showMessageDialog(this, "Task File written");
                }
                output.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fd.dispose();
    }

    public void fileSaveRTask_actionPerformed(ActionEvent e) {
        if (this.db == null || this.sm == null) {
            JOptionPane.showMessageDialog(this, "No database or search space open");
            return;
        }
        if (this.sm.bestHypothesisList == null) {
            JOptionPane.showMessageDialog(this, "No search results available");
            return;
        }
        String path = null;
        FileDialog fd = new FileDialog((Frame)this, "Save results and task specification", 1);
        fd.setDirectory("D:\\SubgroupMining\\Results\\");
        fd.show();
        String filename = fd.getFile();
        if (filename != null) {
            String dirname = fd.getDirectory();
            path = String.valueOf(dirname).concat(String.valueOf(filename));
            try {
                FileOutputStream stream = new FileOutputStream(path);
                ObjectOutputStream output = new ObjectOutputStream(stream);
                this.task = new HashMap();
                this.task.put("db", this.db.getHost());
                this.task.put("hs", this.sm.bestHypothesisList);
                this.task.put("ps", new Double(this.sm.populationSize));
                this.task.put("t#", new Integer(this.sm.targets));
                Map object = this.generateTask();
                if (object != null) {
                    output.writeObject(object);
                    JOptionPane.showMessageDialog(this, "Result File written");
                }
                output.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fd.dispose();
    }

    public void helpAbout_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_AboutBox dlg = new SubgroupMiningFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void helpOverview_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_OVBox dlg = new SubgroupMiningFrame_OVBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void helpDataSelection_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_DSBox dlg = new SubgroupMiningFrame_DSBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void helpSearchParameters_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_SPBox dlg = new SubgroupMiningFrame_SPBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void helpQualityParameters_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_QPBox dlg = new SubgroupMiningFrame_QPBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void helpClusterSuppress_actionPerformed(ActionEvent e) {
        SubgroupMiningFrame_CSBox dlg = new SubgroupMiningFrame_CSBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        int option;
        DataAccess dataAccess = new DataAccess();
        this.dbnew = dataAccess.makeDBConnection();
        if (this.dbnew != null) {
            System.out.println(this.dbnew.getHost());
        }
        if (this.db != null) {
            System.out.println(this.db.getHost());
        }
        if (this.dbnew != null && this.db != null && !this.dbnew.getHost().equals(this.db.getHost()) && (option = JOptionPane.showConfirmDialog(this, " New Database selected. Really replace old database?")) != 0) {
            return;
        }
        if (this.dbnew != null && this.db != null && this.dbnew.getHost().equals(this.db.getHost())) {
            return;
        }
        this.db = this.dbnew;
        if (this.db != null && !this.db.getHost().equals("")) {
            this.dataSelectionPanel.removeAll();
            this.dcp = new DataChooserPanel(this.db);
            this.dataSelectionPanel.add(this.dcp);
            this.dataSelectionPanel.invalidate();
            this.jTabbedPane1.setSelectedIndex(0);
            this.jTabbedPane1.setSelectedIndex(1);
        } else {
            JOptionPane.showMessageDialog(this, "No connection");
        }
    }

    void jButton2_actionPerformed(ActionEvent e) {
        if (this.db == null) {
            JOptionPane.showMessageDialog(this, "Please access database before starting search!");
            this.jButton1_actionPerformed(null);
            return;
        }
        if (this.dcp == null || this.dcp.getParameters().size() == 0) {
            JOptionPane.showMessageDialog(this, "Please select data before starting search!");
            this.jTabbedPane1.setSelectedIndex(1);
            return;
        }
        this.startSearch(0);
    }

    void jButton3_actionPerformed(ActionEvent e) {
        if (this.sm == null) {
            JOptionPane.showMessageDialog(this, "No search space open, new search started!");
            this.jButton2_actionPerformed(null);
            return;
        }
        this.sm.expHypothesisList = this.twoKeyPlot.getSelectedHypotheses();
        this.startSearch(1);
    }

    void startSearch(int mode) {
        int extendedflag;
        int clusterflag;
        int numExp;
        int currentLevel;
        int depth;
        int numHypo;
        double minSim;
        double minQualImpExp;
        double minQualExp;
        double minQualI;
        double minQual;
        double minCon;
        double minSup;
        try {
            minSup = Double.parseDouble(this.minSupportField.getText());
            minCon = Double.parseDouble(this.minConfidenceField.getText());
            minQual = Double.parseDouble(this.minQualField.getText());
            minQualI = Double.parseDouble(this.minQualImpField.getText());
            minQualExp = Double.parseDouble(this.minQualExpField.getText());
            minQualImpExp = Double.parseDouble(this.minQualImpExpField.getText());
            minSim = Double.parseDouble(this.minSimField.getText());
            numHypo = Integer.parseInt(this.numberHypothesesField.getText());
            depth = Integer.parseInt(this.searchDepthField.getText());
            currentLevel = Integer.parseInt(this.currentLevelField.getText());
            numExp = Integer.parseInt(this.numberExpField.getText());
            clusterflag = Integer.parseInt(this.clusterFField.getText());
            extendedflag = Integer.parseInt(this.extendedFField.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid number in search or quality parameters!");
            return;
        }
        Map parameters = this.dcp.getParameters();
        String table = (String)parameters.get("tableName");
        Vector columnNames = (Vector)parameters.get("columnNames");
        String target = (String)parameters.get("target Attribute");
        String targetvalue = (String)parameters.get("target Value");
        if (targetvalue == "MEANPATTERN" && this.dcp.getType(table, target) != 3) {
            JOptionPane.showMessageDialog(this, "TargetVariable should be continuous when no target value selected!");
            return;
        }
        if (mode == 0 || mode == 3) {
            if (mode == 0 && currentLevel != 0) {
                currentLevel = 0;
            }
            System.out.println("start search");
            this.sm = new SearchManager(this.db, table, columnNames, target, currentLevel, depth, minSup, minCon, minQual, minQualI, numHypo, minQualExp, minQualImpExp, numExp, minSim, extendedflag, clusterflag, this.twoKeyPlot);
            this.sm.dcp = this.dcp;
            System.out.println(targetvalue);
            this.sm.setTargetValue(targetvalue.trim());
            this.sm.setResultArea(this.resultField);
            this.sm.init();
        } else if (mode == 1) {
            if (currentLevel > this.sm.getCurrentDepth()) {
                JOptionPane.showMessageDialog(this, "Current level larger than search depth!");
                return;
            }
            if (!table.equals(this.sm.getTable())) {
                JOptionPane.showMessageDialog(this, "Do not select a new table!");
                return;
            }
            this.sm.setAttributeSpace(columnNames);
            this.sm.target = target;
            this.sm.setSearchDepth(depth);
            this.sm.setCurrentDepth(currentLevel);
            this.sm.setMinConfidence(minCon);
            this.sm.setMinSupport(minSup);
            this.sm.setMinQuality(minQual);
            this.sm.setMinQualityI(minQualI);
            this.sm.setNumberHypotheses(numHypo);
            this.sm.setMinQualExp(minQualExp);
            this.sm.setMinQualImpExp(minQualImpExp);
            this.sm.setNumExp(numExp);
            this.sm.setMinSim(minSim);
            this.sm.setClusterflag(clusterflag);
            this.sm.setExtendedflag(extendedflag);
            this.sm.setTargetValue(targetvalue.trim());
        }
        this.jTabbedPane1.setSelectedIndex(2);
        this.resultField.append("Subgroups\n");
        this.resultField.append(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("current level: ").concat(String.valueOf(currentLevel))).concat(String.valueOf(" depth: "))).concat(String.valueOf(depth))).concat(String.valueOf(" minSupport: "))).concat(String.valueOf(minSup))).concat(String.valueOf(" minConfidence: "))).concat(String.valueOf(minCon))).concat(String.valueOf(" minQuality: "))).concat(String.valueOf(minQual))).concat(String.valueOf(" minQualityImp: "))).concat(String.valueOf(minQualI))).concat(String.valueOf(" number Hypothesis: "))).concat(String.valueOf(numHypo))).concat(String.valueOf(" Extended Search: "))).concat(String.valueOf(extendedflag))).concat(String.valueOf(" Cluster: "))).concat(String.valueOf(clusterflag))).concat(String.valueOf(" number Exp: "))).concat(String.valueOf(numExp))).concat(String.valueOf(" min. Similarity: "))).concat(String.valueOf(minSim))).concat(String.valueOf(" minQuality Exp.: "))).concat(String.valueOf(minQualExp))).concat(String.valueOf(" minQualImpExp: "))).concat(String.valueOf(minQualImpExp))).concat(String.valueOf("\n")));
        this.resultField.append(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Target: ").concat(String.valueOf(target))).concat(String.valueOf(" = "))).concat(String.valueOf(targetvalue))).concat(String.valueOf("\n")));
        this.invalidate();
        if (mode != 3) {
            this.store = this.sm.search();
        }
        this.ncluster = 0;
        if (this.store.size() == 0) {
            JOptionPane.showMessageDialog(this, "No results for these search parameters and data selection!");
            return;
        }
        System.out.println("start two key");
        this.twoKeyPlot.visualizeSubgroups(this.store);
        this.currentLevelField.setText(String.valueOf("").concat(String.valueOf(this.sm.getCurrentDepth())));
        if (mode == 3) {
            this.sm.bestHypothesisList = this.store;
            this.sm.expHypothesisList = (HypothesisStore)this.store.clone();
            this.resultField.append(String.valueOf(this.sm.bestHypothesisList.toString()).concat(String.valueOf("\n")));
            this.sm.bestHypothesisList.addInstances(table, this.sm.id, this.db);
            Double pS = (Double)this.task.get("ps");
            Integer ta = (Integer)this.task.get("t#");
            this.sm.causalNet = new CausalNet(this.sm.id, this.db, target, targetvalue, ta, table, this.store, this.resultField, this.sm.rootHypothesis, pS, this.sm.getMinSim(), this.dcp.rg, this.dcp, this.twoKeyPlot);
        }
    }

    void visualizeButton_actionPerformed(ActionEvent e) {
        int flag = this.sm.causalNet.cluster(this.ncluster);
        if (flag == -1) {
            JOptionPane.showMessageDialog(this, "No further cluster found");
            this.ncluster = 0;
            return;
        }
        this.ncluster = flag;
    }

    void suppressButton_actionPerformed(ActionEvent e) {
        if (this.sm == null) {
            JOptionPane.showMessageDialog(this, "No search performed!");
        } else {
            int option = JOptionPane.showConfirmDialog(this, " Suppress by conditional independence?");
            int ns = option != 0 ? this.sm.causalNet.suppress1() : this.sm.causalNet.suppress();
            String s = String.valueOf("").concat(String.valueOf(ns));
            JOptionPane.showMessageDialog(this, String.valueOf(s).concat(String.valueOf(" subgroups suppressed")));
        }
    }

    Map generateTask() {
        if (this.genSearchParameters() > 0) {
            return null;
        }
        if (this.genQualityParameters() > 0) {
            return null;
        }
        if (this.genPrimSpec() > 0) {
            return null;
        }
        this.genMultiSpec();
        return this.task;
    }

    int genSearchParameters() {
        Integer extendedflag;
        Integer clusterflag;
        Integer numExp;
        Integer currentLevel;
        Integer depth;
        Integer numHypo;
        try {
            numHypo = new Integer(Integer.parseInt(this.numberHypothesesField.getText()));
            depth = new Integer(Integer.parseInt(this.searchDepthField.getText()));
            currentLevel = new Integer(Integer.parseInt(this.currentLevelField.getText()));
            numExp = new Integer(Integer.parseInt(this.numberExpField.getText()));
            clusterflag = new Integer(Integer.parseInt(this.clusterFField.getText()));
            extendedflag = new Integer(Integer.parseInt(this.extendedFField.getText()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "A search parameter is no integer value");
            int n = 1;
            return n;
        }
        this.task.put("nH", numHypo);
        this.task.put("d", depth);
        this.task.put("c", currentLevel);
        this.task.put("nE", numExp);
        this.task.put("cf", clusterflag);
        this.task.put("ef", extendedflag);
        return 0;
    }

    int genQualityParameters() {
        Double minSim;
        Double minQualImpExp;
        Double minQualExp;
        Double minQualI;
        Double minQual;
        Double minSup;
        Double minCon;
        try {
            minCon = new Double(Double.parseDouble(this.minConfidenceField.getText()));
            minSup = new Double(Double.parseDouble(this.minSupportField.getText()));
            minQual = new Double(Double.parseDouble(this.minQualField.getText()));
            minQualI = new Double(Double.parseDouble(this.minQualImpField.getText()));
            minQualExp = new Double(Double.parseDouble(this.minQualExpField.getText()));
            minQualImpExp = new Double(Double.parseDouble(this.minQualImpExpField.getText()));
            minSim = new Double(Double.parseDouble(this.minSimField.getText()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "A quality parameter is no numeric value");
            int n = 1;
            return n;
        }
        this.task.put("mc", minCon);
        this.task.put("msu", minSup);
        this.task.put("mq", minQual);
        this.task.put("mqi", minQualI);
        this.task.put("mqe", minQualExp);
        this.task.put("mqei", minQualImpExp);
        this.task.put("msi", minSim);
        return 0;
    }

    int genPrimSpec() {
        String load = "";
        if (this.dcp == null) {
            JOptionPane.showMessageDialog(this, "No data selected");
            return 1;
        }
        if (this.dcp.tableList.getSelectedValue() != null) {
            load = this.dcp.tableList.getSelectedValue().toString();
        }
        if (!load.equals("") && this.dcp.addFieldList.getSelectedValue() != null) {
            if (this.dcp.valueList.getSelectedValue() == null) {
                this.task.put("tv", "MEANPATTERN");
            } else {
                this.task.put("tv", this.dcp.valueList.getSelectedValue().toString());
            }
            this.task.put("t", this.dcp.addFieldList.getSelectedValue().toString());
            this.task.put("tN", load);
            Vector v1 = (Vector)this.dcp.addColumnNames.clone();
            v1.remove(this.dcp.addFieldList.getSelectedValue());
            this.task.put("cN", v1);
            return 0;
        }
        JOptionPane.showMessageDialog(this, "No table or target attribute specified");
        return 1;
    }

    void genMultiSpec() {
        if (this.dcp.rg == null) {
            JOptionPane.showMessageDialog(this, "Single relational case: No multirelational Graph defined");
        }
        this.task.put("rg", this.dcp.rg);
    }

    void restoreTask() {
        Integer i = (Integer)this.task.get("nH");
        String s = i.toString();
        this.numberHypothesesField.setText(s);
        i = (Integer)this.task.get("d");
        s = i.toString();
        this.searchDepthField.setText(s);
        i = (Integer)this.task.get("c");
        s = i.toString();
        this.currentLevelField.setText(s);
        i = (Integer)this.task.get("nE");
        s = i.toString();
        this.numberExpField.setText(s);
        i = (Integer)this.task.get("cf");
        s = i.toString();
        this.clusterFField.setText(s);
        i = (Integer)this.task.get("ef");
        s = i.toString();
        this.extendedFField.setText(s);
        Double d = (Double)this.task.get("mc");
        s = d.toString();
        this.minConfidenceField.setText(s);
        d = (Double)this.task.get("msu");
        s = d.toString();
        this.minSupportField.setText(s);
        d = (Double)this.task.get("mq");
        s = d.toString();
        this.minQualField.setText(s);
        d = (Double)this.task.get("mqi");
        s = d.toString();
        this.minQualImpField.setText(s);
        d = (Double)this.task.get("mqe");
        s = d.toString();
        this.minQualExpField.setText(s);
        d = (Double)this.task.get("mqei");
        s = d.toString();
        this.minQualImpExpField.setText(s);
        d = (Double)this.task.get("msi");
        s = d.toString();
        this.minSimField.setText(s);
        this.parameterPanel.invalidate();
        this.dcp.parameters.put("tableName", (String)this.task.get("tN"));
        this.dcp.parameters.put("columnNames", (Vector)this.task.get("cN"));
        this.dcp.parameters.put("target Attribute", (String)this.task.get("t"));
        this.dcp.parameters.put("target Value", (String)this.task.get("tv"));
        this.dcp.resetPrimButton_actionPerformed(null);
        this.dcp.rg = (RelationGraph)this.task.get("rg");
        if (this.dcp.rg == null) {
            System.out.println("No Relation Graph");
            this.dcp.relationNames = new Vector();
            this.dcp.linkNames = new Vector();
            this.dcp.r1.setText("");
            this.dcp.r2.setText("");
            this.dcp.linkrel1 = new Vector();
            this.dcp.linkrel2 = new Vector();
            this.dcp.linkconjs = new Vector();
            this.dcp.linkconds = new Vector();
            this.dcp.linkatts = new Vector();
            this.dcp.flag = false;
            this.dcp.relationList.setListData(this.dcp.relationNames);
            this.dcp.linkList.setListData(this.dcp.linkNames);
            this.dcp.relationList.invalidate();
            this.dcp.linkList.invalidate();
            this.dcp.flag = true;
        } else {
            this.dcp.resetRG();
        }
    }
}

