/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.io.Serializable;
import java.sql.ResultSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import subgroupmining.Attribute;
import subgroupmining.Concept;
import subgroupmining.DataChooserPanel;
import subgroupmining.Link;
import subgroupmining.QueryConstructor;
import subgroupmining.RelationGraph;
import subgroupmining.Selector;

public class Subgroup
implements Comparable,
Serializable {
    private long ID = -1L;
    private Selector target;
    private ArrayList conceptset;
    public Vector instances;
    private ArrayList linkset;
    private double quality;
    private double confidence;
    private double conceptShare = 1.0;
    private double conceptSize;
    private double p0;
    private double v0;
    private double variance;
    private int cluster = 0;
    protected ArrayList subgroupSizes;
    protected ArrayList targetValues;
    protected boolean selected = false;
    static transient NumberFormat nf = NumberFormat.getInstance();

    public Subgroup() {
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        this.subgroupSizes = new ArrayList();
        this.targetValues = new ArrayList();
        this.conceptset = new ArrayList();
        this.linkset = new ArrayList();
    }

    public Subgroup(int targets) {
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        this.conceptset = new ArrayList();
        this.linkset = new ArrayList();
        this.subgroupSizes = new ArrayList(targets);
        for (int i = 0; i < targets; ++i) {
            this.subgroupSizes.add(new Double(0.0));
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean val) {
        this.selected = val;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double c) {
        this.confidence = c;
    }

    public int getCluster() {
        return this.cluster;
    }

    public void setCluster(int c) {
        this.cluster = c;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double c) {
        this.variance = c;
    }

    public double getQuality() {
        return this.quality;
    }

    public double getP0() {
        return this.p0;
    }

    public double getV0() {
        return this.v0;
    }

    public double calculateQuality(Subgroup root) {
        if (root == null) {
            this.quality = 0.0;
            return this.quality;
        }
        this.p0 = root.getConfidence();
        this.v0 = root.getVariance();
        double n = root.getConceptSize();
        double n1 = 0.0;
        if (this.conceptSize < n) {
            n1 = n / (n - this.conceptSize);
        }
        this.quality = Math.sqrt(this.conceptSize * n1 / this.v0) * (this.confidence - this.p0);
        return this.quality;
    }

    public void setID(long ID) {
        this.ID = ID;
    }

    public long getID() {
        return this.ID;
    }

    public Vector getInstances() {
        return this.instances;
    }

    public int compareTo(Object object) {
        double qual = ((Subgroup)object).getQuality();
        if (this.quality > qual) {
            return -1;
        }
        if (qual > this.quality) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        Subgroup h = (Subgroup)object;
        int dim = this.getConceptset().size();
        if (h.getConceptset().size() != dim || !h.getTarget().equals(this.getTarget())) {
            return false;
        }
        for (int i = 0; i < dim; ++i) {
            boolean iflag = false;
            Concept iconcept = (Concept)this.getConceptset().get(i);
            int ilinkid = ((Link)this.getLinkset().get(i)).getID();
            for (int j = 0; j < dim; ++j) {
                Concept jconcept = (Concept)h.getConceptset().get(j);
                int jlinkid = ((Link)h.getLinkset().get(j)).getID();
                if (!iconcept.equals(jconcept) || ilinkid != jlinkid) continue;
                iflag = true;
                break;
            }
            if (iflag) continue;
            return false;
        }
        return true;
    }

    public boolean notaxonomy(Attribute attribute) {
        int dim = this.getConceptset().size();
        for (int i = 1; i < dim; ++i) {
            Link link = (Link)this.linkset.get(i);
            if (!link.getAtt().equals(attribute)) continue;
            return false;
        }
        return true;
    }

    public boolean notaxonomy(Link link) {
        if (link.getType() != 1) {
            return true;
        }
        int dim = this.getConceptset().size();
        for (int i = 1; i < dim; ++i) {
            Link link1 = (Link)this.linkset.get(i);
            if (!link1.getAtt().equals(link.getAtt())) continue;
            return false;
        }
        Concept concept = (Concept)this.getConceptset().get(0);
        return !concept.containsAttribute(link.getAtt());
    }

    public String makeWhere(String table) {
        String where = " where ";
        int dim = this.getConceptset().size();
        ArrayList linkset = this.getLinkset();
        int flag = 0;
        int iand = 0;
        for (int cind = 0; cind < dim; ++cind) {
            String modrelname;
            Link link = (Link)linkset.get(cind);
            if (dim == 1) {
                modrelname = table;
            } else {
                String relname = link.getSuccessor().getName();
                modrelname = QueryConstructor.modifyRelname(relname, cind, linkset);
                flag = QueryConstructor.countRelname(relname, cind, linkset);
            }
            Concept concept = (Concept)this.getConceptset().get(cind);
            if (concept.size() > 0) {
                Iterator it = concept.iterator();
                Selector selector = (Selector)it.next();
                if (iand > 0) {
                    where = String.valueOf(where).concat(String.valueOf(" AND "));
                } else {
                    ++iand;
                }
                where = String.valueOf(where).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(modrelname).concat(String.valueOf("."))).concat(String.valueOf(selector.getAttribute()))).concat(String.valueOf("='"))).concat(String.valueOf(selector.getValue()))).concat(String.valueOf("'"))));
                while (it.hasNext()) {
                    selector = (Selector)it.next();
                    where = String.valueOf(where).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" AND ").concat(String.valueOf(modrelname))).concat(String.valueOf("."))).concat(String.valueOf(selector.getAttribute()))).concat(String.valueOf("='"))).concat(String.valueOf(selector.getValue()))).concat(String.valueOf("'"))));
                }
            }
            if (cind <= 0) continue;
            where = String.valueOf(where).concat(String.valueOf(String.valueOf(" AND ").concat(String.valueOf(link.getLinkCondition(flag)))));
        }
        return where;
    }

    public String makeFrom(String table) {
        String from = " from ";
        int dim = this.getConceptset().size();
        if (dim == 1) {
            from = String.valueOf(from).concat(String.valueOf(table));
            return from;
        }
        ArrayList linkset = this.getLinkset();
        for (int cind = 0; cind < dim; ++cind) {
            Link link = (Link)linkset.get(cind);
            String relname = link.getSuccessor().getName();
            String modrelname = QueryConstructor.modifyRelname(relname, cind, linkset);
            from = cind == 0 ? String.valueOf(from).concat(String.valueOf(relname)) : (relname.equals(modrelname) ? String.valueOf(from).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(relname)))) : String.valueOf(from).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(", ").concat(String.valueOf(relname))).concat(String.valueOf(" "))).concat(String.valueOf(modrelname)))));
        }
        return from;
    }

    public Vector addInstances(String table, String id, Database db) {
        String sql = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("select DISTINCT ").concat(String.valueOf(table))).concat(String.valueOf("."))).concat(String.valueOf(id))).concat(String.valueOf(this.makeFrom(table)))).concat(String.valueOf(this.makeWhere(table)));
        ResultSet rs = db.select(sql);
        this.instances = new Vector();
        try {
            while (rs.next()) {
                this.instances.add(rs.getObject(id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.instances;
    }

    public Vector addInstances1(RelationGraph rg, DataChooserPanel dcp, String table, String id, Database db) {
        String sql;
        String from;
        String key = "ZONE_ID";
        if (id != null) {
            key = id;
        }
        String where = " where ";
        if (this.getConceptset().size() < 2) {
            from = String.valueOf(" from ").concat(String.valueOf(table));
            Concept concept = (Concept)this.getConceptset().get(0);
            where = String.valueOf(where).concat(String.valueOf(concept.toSQLString(dcp, table)));
            sql = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("select ").concat(String.valueOf(table))).concat(String.valueOf("."))).concat(String.valueOf(key))).concat(String.valueOf(from))).concat(String.valueOf(where));
        } else {
            from = QueryConstructor.makeFrom(rg, this);
            where = QueryConstructor.makeWhere(rg, table, dcp, this);
            sql = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("select DISTINCT ").concat(String.valueOf(table))).concat(String.valueOf("."))).concat(String.valueOf(id))).concat(String.valueOf(from))).concat(String.valueOf(where));
        }
        ResultSet rs = db.select(sql);
        this.instances = new Vector();
        try {
            while (rs.next()) {
                this.instances.add(rs.getObject(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.instances;
    }

    public String toString() {
        int dim = this.getConceptset().size();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < dim; ++i) {
            Link link = (Link)this.getLinkset().get(i);
            if (i > 0) {
                s.append("; ");
                if (link.getType() == 1) {
                    if (link.getParent().getID() > 0) {
                        s.append(link.getParent().getName());
                        s.append(".");
                    }
                } else {
                    s.append(link.getSuccessor().getName());
                    s.append(".");
                }
            }
            Concept concept = (Concept)this.getConceptset().get(i);
            if (link.getType() == 1) {
                s.append(link.getAtt().getName());
                s.append("=");
                Selector sel = (Selector)concept.iterator().next();
                s.append(sel.getValue());
                continue;
            }
            s.append(concept.toString());
        }
        s.append(" ->");
        s.append(this.target.toString());
        s.append(String.valueOf(" Q: ").concat(String.valueOf(nf.format(this.quality))));
        s.append(String.valueOf(" CS: ").concat(String.valueOf(nf.format(this.conceptSize))));
        s.append(String.valueOf(" C: ").concat(String.valueOf(nf.format(this.confidence))));
        s.append(String.valueOf(" C0: ").concat(String.valueOf(nf.format(this.p0))));
        if (this.variance >= 0.0) {
            s.append(String.valueOf(" VAR: ").concat(String.valueOf(nf.format(this.variance))));
        } else {
            s.append(String.valueOf(" SG: ").concat(String.valueOf(nf.format(this.getSubgroupSize(0)))));
        }
        return s.toString();
    }

    public String toString1() {
        int dim = this.getConceptset().size();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < dim; ++i) {
            Link link = (Link)this.getLinkset().get(i);
            if (i > 0) {
                s.append("; ");
                s.append(link.getSuccessor().getName());
                s.append(".");
            }
            Concept concept = (Concept)this.getConceptset().get(i);
            s.append(concept.toString());
        }
        return s.toString();
    }

    public String conceptToString() {
        Iterator it = this.getConceptset().iterator();
        Iterator it1 = this.getLinkset().iterator();
        StringBuffer s = new StringBuffer();
        while (it.hasNext()) {
            Concept concept = (Concept)it.next();
            Link link = (Link)it1.next();
            if (link.getType() == 1) {
                s.append(link.getAtt().getName());
                s.append("=");
                Selector sel = (Selector)concept.iterator().next();
                s.append(sel.getValue());
            } else {
                s.append(concept.toString());
            }
            s.append(' ');
        }
        return s.toString();
    }

    public int getConceptDim() {
        Iterator it = this.getConceptset().iterator();
        int dim = 0;
        while (it.hasNext()) {
            dim += ((Concept)it.next()).size();
        }
        return dim;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setTarget(Selector newTarget) {
        this.target = newTarget;
    }

    public Selector getTarget() {
        return this.target;
    }

    public ArrayList getConceptset() {
        return this.conceptset;
    }

    public void addConceptset(ArrayList conceptset) {
        for (int i = 0; i < conceptset.size(); ++i) {
            Concept concept = (Concept)conceptset.get(i);
            Concept concept2 = new Concept();
            concept2.addAll(concept);
            this.conceptset.add(i, concept2);
        }
    }

    public ArrayList getLinkset() {
        return this.linkset;
    }

    public void addLink(Link link) {
        this.linkset.add(link);
    }

    public void addLinkset(ArrayList linkset) {
        for (int i = 0; i < linkset.size(); ++i) {
            Link link = (Link)linkset.get(i);
            this.linkset.add(i, link);
        }
    }

    public void setConceptSize(double newConceptSize) {
        this.conceptSize = newConceptSize;
    }

    public double getConceptSize() {
        if (this.conceptSize == 0.0) {
            for (int i = 0; i < this.subgroupSizes.size(); ++i) {
                Double size = (Double)this.subgroupSizes.get(i);
                this.conceptSize += size.doubleValue();
            }
        }
        return this.conceptSize;
    }

    public void setSubgroupSize(int ind, double newSubgroupSize) {
        Double size = new Double(newSubgroupSize);
        this.subgroupSizes.set(ind, size);
    }

    public int getTid(String targetval) {
        int i;
        for (i = 0; i < this.targetValues.size() && !this.targetValues.get(i).equals(targetval); ++i) {
        }
        return i;
    }

    public double getSubgroupSize(int ind) {
        Double d = (Double)this.subgroupSizes.get(ind);
        return d;
    }

    public double getConceptShare() {
        return this.conceptShare;
    }

    public void calculateValues(Subgroup root) {
        this.calculateConfidence();
        this.calculateConceptShare(root);
        this.calculateQuality(root);
    }

    public double calculateConfidence() {
        this.confidence = this.getConceptSize() == 0.0 ? 0.0 : this.getSubgroupSize(0) / this.conceptSize;
        return this.confidence;
    }

    public double calculateConceptShare(Subgroup root) {
        if (root != null) {
            this.conceptShare = this.getConceptSize() / root.getConceptSize();
        }
        return this.conceptShare;
    }
}

