/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextArea;
import subgroupmining.Attribute;
import subgroupmining.AttributeMeta;
import subgroupmining.CausalNet;
import subgroupmining.Concept;
import subgroupmining.DataChooserPanel;
import subgroupmining.HypothesisStore;
import subgroupmining.Link;
import subgroupmining.QueryConstructor;
import subgroupmining.Relation;
import subgroupmining.RelationGraph;
import subgroupmining.Selector;
import subgroupmining.Subgroup;
import subgroupmining.SubgroupPair;
import subgroupmining.visualization.TwoKeyPlot;

public class SearchManager {
    protected int currentDepth = 0;
    protected int searchDepth = 0;
    private int laststep = 0;
    public Database db;
    protected String target = "";
    protected int targets;
    private int numberHypotheses;
    private double minConfidence;
    private double minQuality;
    private double minQualityI;
    private double minSupport;
    private double minimumQualExp;
    private double minimumQualImpExp;
    private double minimumSim;
    private int numberExp;
    private int clusterflag;
    private int extendedflag;
    private String table;
    private Vector attributeSpace;
    public HypothesisStore bestHypothesisList = new HypothesisStore();
    public HypothesisStore expHypothesisList = new HypothesisStore();
    private JTextArea resultArea;
    protected Subgroup rootHypothesis = new Subgroup();
    protected double populationSize = 0.0;
    public RelationGraph theRelationGraph;
    public CausalNet causalNet;
    public DataChooserPanel dcp;
    private int targetind = 0;
    public String targetValue = "";
    public String id = null;
    private boolean standalone = true;
    public long subgroupId = 0L;
    public int querytype = 4;
    public TwoKeyPlot twoKeyPlot;

    public SearchManager(Database db, String table, Vector attributeSpace, String target, int current, int searchDepth, double minSupport, double minConfidence, double minQuality, double minQualityI, int numberHypotheses, double minQualExp, double minQualImpExp, int numExp, double minSim, int extendedflag, int clusterflag, TwoKeyPlot tkp) {
        this.db = db;
        this.table = table;
        this.attributeSpace = attributeSpace;
        this.currentDepth = current;
        this.searchDepth = searchDepth;
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.minQuality = minQuality;
        this.minQualityI = minQualityI;
        this.numberHypotheses = numberHypotheses;
        this.minimumQualExp = minQualExp;
        this.minimumQualImpExp = minQualImpExp;
        this.numberExp = numExp;
        this.minimumSim = minSim;
        this.clusterflag = clusterflag;
        this.extendedflag = extendedflag;
        this.target = target;
        this.twoKeyPlot = tkp;
    }

    public void init() {
        if (this.id != null) {
            this.standalone = false;
        }
        this.rootHypothesis.setID(0L);
        this.populationSize = this.dcp.getPopSize(this.table);
        System.out.println(String.valueOf("popS: ").concat(String.valueOf(this.populationSize)));
        this.rootHypothesis.setConceptSize(this.populationSize);
        if (this.standalone) {
            this.theRelationGraph = this.dcp.rg;
        }
        if (this.theRelationGraph != null && this.standalone) {
            this.id = this.dcp.selectedKey;
        }
        this.twoKeyPlot.targetValue = this.targetValue;
        if (this.dcp.getType(this.table, this.target) == 3) {
            Double av = new Double(this.dcp.getAverage(this.table, this.target));
            System.out.println(String.valueOf("Avg: ").concat(String.valueOf(av)));
            Double va = new Double(this.dcp.getVariance(this.table, this.target));
            System.out.println(String.valueOf("Var: ").concat(String.valueOf(va)));
            this.rootHypothesis.setConfidence(av);
            this.rootHypothesis.setVariance(va);
            Selector selector = new Selector(this.target, "HIGH");
            this.rootHypothesis.setTarget(selector);
            this.rootHypothesis.calculateQuality(null);
            this.targets = 1;
        } else {
            this.targets = this.dcp.getNr(this.table, this.target);
            System.out.println(String.valueOf("targets: ").concat(String.valueOf(this.targets)));
            for (int i1 = 0; i1 < this.targets; ++i1) {
                String tval = (String)this.dcp.getValueList(this.table, this.target).get(i1);
                int n = (Integer)this.dcp.getCounts(this.table, this.target).get(i1);
                if (tval.equals(this.targetValue)) {
                    this.targetind = i1;
                    Selector selector = new Selector(this.target, tval);
                    this.rootHypothesis.setTarget(selector);
                }
                this.rootHypothesis.subgroupSizes.add(new Double(n));
                this.rootHypothesis.targetValues.add(tval);
            }
            if (this.targetind > 0 && this.targetind < this.targets) {
                double size0 = this.rootHypothesis.getSubgroupSize(0);
                double sizet = this.rootHypothesis.getSubgroupSize(this.targetind);
                this.rootHypothesis.setSubgroupSize(0, sizet);
                this.rootHypothesis.setSubgroupSize(this.targetind, size0);
                String value0 = (String)this.rootHypothesis.targetValues.get(0);
                String valuet = (String)this.rootHypothesis.targetValues.get(this.targetind);
                this.rootHypothesis.targetValues.set(0, valuet);
                this.rootHypothesis.targetValues.set(this.targetind, value0);
            }
            this.rootHypothesis.calculateValues(null);
            double v = this.rootHypothesis.getConfidence() * (1.0 - this.rootHypothesis.getConfidence());
            this.rootHypothesis.setVariance(v);
        }
    }

    public void organize(List newHypotheses) {
        Collections.sort(newHypotheses);
        int i0 = 0;
        int i1 = 0;
        System.out.println(String.valueOf("new Hypotheses: ").concat(String.valueOf(newHypotheses.size())));
        System.out.println(String.valueOf(" ").concat(String.valueOf(this.getNumExp())));
        this.expHypothesisList = new HypothesisStore();
        HypothesisStore expHypothesisList0 = new HypothesisStore();
        for (int i = 0; i < newHypotheses.size(); ++i) {
            SubgroupPair sp = (SubgroupPair)newHypotheses.get(i);
            Subgroup subgroup = sp.getSuccessor();
            double q = sp.getQuality();
            if (i0 < this.numberHypotheses) {
                System.out.println(String.valueOf("i0:  ").concat(String.valueOf(i0)));
                if (this.getExtendedflag() == 0.0) {
                    this.bestHypothesisList.add(sp.getSuccessor());
                    ++i0;
                    if (this.getClusterflag() == 0.0) {
                        this.expHypothesisList.add(sp.getSuccessor());
                    } else {
                        expHypothesisList0.add(sp.getSuccessor());
                    }
                } else if (q >= this.minQualityI && subgroup.getQuality() >= this.minQuality) {
                    this.bestHypothesisList.add(sp.getSuccessor());
                    ++i0;
                }
            }
            if (!(this.getExtendedflag() > 0.0) || i1 >= this.getNumExp()) continue;
            System.out.println(String.valueOf("i1:  ").concat(String.valueOf(i1)));
            if (q < this.getMinQualImpExp() || subgroup.getQuality() < this.getMinQualExp()) continue;
            if (this.getClusterflag() == 0.0) {
                this.expHypothesisList.add(sp.getSuccessor());
            } else {
                expHypothesisList0.add(sp.getSuccessor());
            }
            ++i1;
        }
        int i2 = i1;
        if (this.getExtendedflag() == 0.0) {
            i2 = i0;
        }
        System.out.println(String.valueOf(String.valueOf(String.valueOf("new Results: ").concat(String.valueOf(i0))).concat(String.valueOf(" Expansions: "))).concat(String.valueOf(i2)));
        if (this.laststep == 1 || this.getClusterflag() == 0.0) {
            return;
        }
        CausalNet causalNetExp = new CausalNet(this.id, this.db, this.target, this.targetValue, this.targets, this.table, expHypothesisList0, this.resultArea, this.rootHypothesis, this.populationSize, this.getMinSim(), this.theRelationGraph, this.dcp, this.twoKeyPlot);
        int n = 0;
        n = causalNetExp.cluster(n);
        while (n > 0) {
            n = causalNetExp.cluster(n);
        }
        for (int i3 = 0; i3 < expHypothesisList0.size(); ++i3) {
            int j3 = 0;
            double max = -1.0;
            Subgroup maxsub = new Subgroup();
            int el = causalNetExp.getclust(i3, j3);
            while (el != -1) {
                Subgroup sub = (Subgroup)expHypothesisList0.get(el);
                double qual = sub.getQuality();
                if (qual > max) {
                    maxsub = sub;
                    max = qual;
                }
                el = causalNetExp.getclust(i3, ++j3);
            }
            if (j3 <= 0) continue;
            this.expHypothesisList.add(maxsub);
        }
        System.out.println(String.valueOf("Expansions after clustering: ").concat(String.valueOf(this.expHypothesisList.size())));
    }

    public ArrayList expand(int depth) {
        Subgroup igroup;
        int i;
        String query;
        Subgroup currentSubgroup = new Subgroup();
        ArrayList newSubgroups = new ArrayList();
        ArrayList<Subgroup> initialSubgroups = new ArrayList<Subgroup>();
        if (this.expHypothesisList.size() > 0) {
            for (int i2 = 0; i2 < this.expHypothesisList.size(); ++i2) {
                currentSubgroup = (Subgroup)this.expHypothesisList.get(i2);
                if (currentSubgroup.getConceptDim() != depth) continue;
                initialSubgroups.add(currentSubgroup);
            }
            if (initialSubgroups.size() <= 0) {
                return null;
            }
        }
        long rootID = this.rootHypothesis.getID();
        if (this.querytype == 1) {
            query = QueryConstructor.makeQuery(this.attributeSpace, initialSubgroups, this.target, this.targetValue, this.table, rootID, this.dcp);
            if (!query.equals(new String(""))) {
                this.dbQuery(query, initialSubgroups, newSubgroups);
            }
        } else if (this.querytype > 1) {
            if (initialSubgroups.size() == 0) {
                query = QueryConstructor.makeQuery(this.querytype, this.attributeSpace, this.rootHypothesis, this.target, this.targetValue, this.table, rootID, this.dcp);
                if (!query.equals(new String(""))) {
                    this.dbQuery(query, this.rootHypothesis, newSubgroups);
                }
            } else {
                for (i = 0; i < initialSubgroups.size(); ++i) {
                    igroup = (Subgroup)initialSubgroups.get(i);
                    System.out.println(String.valueOf("Single rel. expand group: ").concat(String.valueOf(igroup.getID())));
                    query = QueryConstructor.makeQuery(this.querytype, this.attributeSpace, igroup, this.target, this.targetValue, this.table, rootID, this.dcp);
                    if (query.equals(new String(""))) continue;
                    this.dbQuery(query, igroup, newSubgroups);
                }
            }
        }
        if (this.theRelationGraph != null) {
            if (this.querytype == 1) {
                String query2;
                String query1 = QueryConstructor.makeQuery(this.id, initialSubgroups, rootID, this.target, this.targetValue, this.theRelationGraph, this.dcp);
                if (!query1.equals(new String(""))) {
                    this.dbQuery(query1, initialSubgroups, newSubgroups);
                }
                if (!(query2 = QueryConstructor.makeQuery2(this.id, initialSubgroups, rootID, this.target, this.targetValue, this.theRelationGraph, this.dcp)).equals(new String(""))) {
                    this.dbQuery(query2, initialSubgroups, newSubgroups);
                }
            } else if (this.querytype > 1) {
                if (initialSubgroups.size() == 0) {
                    System.out.println("New links for root");
                    Relation rel = new Relation(this.table);
                    ArrayList newlinks = this.theRelationGraph.getlinks(rel);
                    for (int j = 0; j < newlinks.size(); ++j) {
                        Link link = (Link)newlinks.get(j);
                        System.out.println(String.valueOf("Link: ").concat(String.valueOf(link.getID())));
                        String table2 = link.getSuccessor().getName();
                        Vector iattributes = link.attributes;
                        int alength = iattributes.size();
                        for (int j1 = 0; j1 < alength; ++j1) {
                            String att = (String)iattributes.get(j1);
                            int typ = this.dcp.getType(table2, att);
                            System.out.println(String.valueOf(String.valueOf(String.valueOf("Type: ").concat(String.valueOf(att))).concat(String.valueOf(" "))).concat(String.valueOf(typ)));
                            if (typ == 0 || (query = QueryConstructor.makeQueryL2N(this.querytype, this.id, link, att, this.rootHypothesis, this.target, this.targetValue, this.table, this.theRelationGraph, this.dcp)).equals(new String(""))) continue;
                            this.dbQuery(query, link, att, link.getID(), 1, this.rootHypothesis, newSubgroups);
                        }
                    }
                }
                for (i = 0; i < initialSubgroups.size(); ++i) {
                    Link link;
                    igroup = (Subgroup)initialSubgroups.get(i);
                    System.out.println(String.valueOf("Multirel. expand group: ").concat(String.valueOf(igroup.getID())));
                    ArrayList linkset = igroup.getLinkset();
                    ArrayList conceptset = igroup.getConceptset();
                    int dim = conceptset.size();
                    if (dim > 1) {
                        query = QueryConstructor.makeQueryL2(this.querytype, this.id, this.attributeSpace, igroup, this.target, this.targetValue, this.table, this.theRelationGraph, this.dcp);
                        if (!query.equals(new String(""))) {
                            this.dbQuery(query, null, null, 0, 0, igroup, newSubgroups);
                        }
                        for (int i1 = 1; i1 < dim; ++i1) {
                            Link link2 = (Link)linkset.get(i1);
                            Concept conc = (Concept)conceptset.get(i1);
                            Vector iattributes = link2.attributes;
                            int maxconj = link2.getMaxConjunctions();
                            if (conc.size() >= maxconj) continue;
                            for (int i2 = 0; i2 < iattributes.size(); ++i2) {
                                String att = (String)iattributes.get(i2);
                                query = QueryConstructor.makeQueryL2(this.querytype, this.id, link2, i1, att, igroup, this.target, this.targetValue, this.table, rootID, this.theRelationGraph, this.dcp);
                                if (query.equals(new String(""))) continue;
                                this.dbQuery(query, link2, att, link2.getID(), i1, igroup, newSubgroups);
                            }
                        }
                    }
                    ArrayList<Link> newlinks = new ArrayList<Link>();
                    Relation rel = new Relation(this.table);
                    for (int lind = 0; lind < dim; ++lind) {
                        if (lind > 0) {
                            link = (Link)linkset.get(lind);
                            rel = link.getSuccessor();
                            System.out.println(String.valueOf("New Link to Relation: ").concat(String.valueOf(rel.getName())));
                        }
                        ArrayList newlinks0 = new ArrayList();
                        newlinks0 = this.theRelationGraph.getlinks(rel);
                        for (int j = 0; j < newlinks0.size(); ++j) {
                            Link l1 = (Link)newlinks0.get(j);
                            boolean flag = false;
                            for (int k = 1; k < dim; ++k) {
                                if (!l1.equals((Link)linkset.get(k))) continue;
                                flag = true;
                            }
                            if (flag) continue;
                            newlinks.add(l1);
                        }
                    }
                    for (int j = 0; j < newlinks.size(); ++j) {
                        link = (Link)newlinks.get(j);
                        String table2 = link.getSuccessor().getName();
                        Vector iattributes = link.attributes;
                        int alength = iattributes.size();
                        for (int j1 = 0; j1 < alength; ++j1) {
                            String att = (String)iattributes.get(j1);
                            int typ = this.dcp.getType(table2, att);
                            if (typ == 0 || (query = QueryConstructor.makeQueryL2N(this.querytype, this.id, link, att, igroup, this.target, this.targetValue, this.table, this.theRelationGraph, this.dcp)).equals(new String(""))) continue;
                            this.dbQuery(query, link, att, link.getID(), dim, igroup, newSubgroups);
                        }
                    }
                }
            }
        }
        return newSubgroups;
    }

    protected void dbQuery(String query, ArrayList initialSubgroups, List newSubgroups) {
        Calendar ctime1 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime1.getTime())));
        Subgroup currentSubgroup = new Subgroup(this.targets);
        Subgroup newSubgroup = new Subgroup(this.targets);
        SubgroupPair sp = new SubgroupPair();
        String sl = this.targetValue;
        if (this.targetValue == "MEANPATTERN") {
            sl = "HIGH";
        }
        Selector tselector = new Selector(this.target, sl);
        ArrayList<SubgroupPair> tempnewSubgroups = new ArrayList<SubgroupPair>();
        ResultSet rs = this.db.select(query);
        Calendar ctime2 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime2.getTime())));
        int pid = -1;
        String ptax = "@";
        String patt = " ";
        String pval = " ";
        int mean = 0;
        if (this.targetValue == "MEANPATTERN") {
            mean = 1;
        }
        try {
            while (rs.next()) {
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" ").concat(String.valueOf(rs.getInt(1)))).concat(String.valueOf(rs.getString(2)))).concat(String.valueOf(rs.getString(3)))).concat(String.valueOf(" "))).concat(String.valueOf(rs.getString(4)))).concat(String.valueOf(" "))).concat(String.valueOf(rs.getString(5)))).concat(String.valueOf(" "))).concat(String.valueOf(rs.getString(6))));
                int id = rs.getInt(1);
                String tax = "";
                String att = rs.getString(3);
                String val = rs.getString(4).trim();
                int linkid = rs.getInt(7 + mean);
                Link link = new Link();
                int conceptsetID = rs.getInt(8 + mean);
                if (!(id == pid && tax.equals(ptax) && att.equals(patt) && val.equals(pval))) {
                    ArrayList linklist;
                    newSubgroup = new Subgroup(this.targets);
                    if (pid >= 0) {
                        tempnewSubgroups.add(sp);
                    }
                    if (id != pid && initialSubgroups.size() > 0) {
                        for (int j = 0; j < initialSubgroups.size() && (currentSubgroup = (Subgroup)initialSubgroups.get(j)).getID() != (long)id; ++j) {
                        }
                    }
                    pid = id;
                    ptax = tax;
                    patt = att;
                    pval = val;
                    newSubgroup.addConceptset(currentSubgroup.getConceptset());
                    newSubgroup.addLinkset(currentSubgroup.getLinkset());
                    Selector selector = new Selector(att, val);
                    int nel = conceptsetID - newSubgroup.getConceptset().size() + 1;
                    if (nel > 1) {
                        newSubgroup.getConceptset().add(new Concept());
                        if (this.theRelationGraph != null) {
                            linklist = this.theRelationGraph.links;
                            link = (Link)linklist.get(0);
                            newSubgroup.addLink(link);
                        }
                    }
                    if (nel > 0) {
                        newSubgroup.getConceptset().add(new Concept());
                        if (this.theRelationGraph != null) {
                            linklist = this.theRelationGraph.links;
                            for (int j1 = 0; j1 < linklist.size() && (link = (Link)linklist.get(j1)).getID() != linkid; ++j1) {
                            }
                            newSubgroup.addLink(link);
                        } else {
                            newSubgroup.addLink(new Link());
                        }
                    }
                    ((Concept)newSubgroup.getConceptset().get(conceptsetID)).add(selector);
                    newSubgroup.setTarget(tselector);
                    sp = new SubgroupPair(currentSubgroup, newSubgroup);
                }
                if (mean == 0) {
                    double subgroupSize = rs.getDouble(6);
                    String ctargetval = rs.getString(5).trim();
                    int tid = this.rootHypothesis.getTid(ctargetval);
                    newSubgroup.setSubgroupSize(tid, subgroupSize);
                    continue;
                }
                newSubgroup.setConceptSize(rs.getDouble(5));
                newSubgroup.setConfidence(rs.getDouble(6));
                newSubgroup.setVariance(rs.getDouble(7));
                newSubgroup.calculateConceptShare(this.rootHypothesis);
                newSubgroup.calculateQuality(this.rootHypothesis);
            }
            tempnewSubgroups.add(sp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dbQueryPost(tempnewSubgroups, mean, newSubgroups);
    }

    protected void dbQuery(String query, Subgroup iSubgroup, List newSubgroups) {
        String low = "low";
        String high = "high";
        Vector<String> v2 = new Vector<String>();
        v2.add(low);
        v2.add(high);
        Calendar ctime1 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime1.getTime())));
        Subgroup newSubgroup = new Subgroup(this.targets);
        SubgroupPair sp = new SubgroupPair();
        String sl = this.targetValue;
        if (this.targetValue == "MEANPATTERN") {
            sl = "HIGH";
        }
        Selector tselector = new Selector(this.target, sl);
        ArrayList<SubgroupPair> tempnewSubgroups = new ArrayList<SubgroupPair>();
        ResultSet rs = this.db.select(query);
        Calendar ctime2 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime2.getTime())));
        int mean = 0;
        int alength = this.attributeSpace.size();
        if (this.targetValue == "MEANPATTERN") {
            mean = 1;
        }
        int flag = 0;
        int qit = 1;
        if (this.querytype == 4 && mean == 0) {
            qit = 2;
        }
        try {
            while (rs.next()) {
                int pos = 2;
                String ctargetval = rs.getString(1).trim();
                for (int it = 0; it < qit; ++it) {
                    int pos1 = 0;
                    for (int i = 0; i < alength; ++i) {
                        Vector<String> values;
                        String an = (String)this.attributeSpace.get(i);
                        Attribute a = new Attribute(an);
                        int atype = this.dcp.getType(this.table, an);
                        if (atype == 0 || iSubgroup.getID() > (long)0 && ((Concept)iSubgroup.getConceptset().get(0)).containsAttribute(a)) continue;
                        Vector disc = null;
                        if (this.dcp.currentTM != null && this.dcp.currentTM.meta != null && this.dcp.currentTM.meta.get(an) != null) {
                            disc = ((AttributeMeta)this.dcp.currentTM.meta.get(an)).getDisc();
                        }
                        if (disc != null) {
                            String vvv;
                            values = new Vector();
                            for (int i7 = 0; i7 < disc.size(); ++i7) {
                                vvv = i7 == 0 ? String.valueOf(String.valueOf(String.valueOf(i7 + 1).concat(String.valueOf("(<="))).concat(String.valueOf((String)disc.get(i7)))).concat(String.valueOf(")")) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i7 + 1).concat(String.valueOf("("))).concat(String.valueOf((String)disc.get(i7 - 1)))).concat(String.valueOf(","))).concat(String.valueOf((String)disc.get(i7)))).concat(String.valueOf(")"));
                                values.add(vvv);
                            }
                            vvv = String.valueOf(String.valueOf(String.valueOf(disc.size() + 1).concat(String.valueOf("(>"))).concat(String.valueOf((String)disc.get(disc.size() - 1)))).concat(String.valueOf(")"));
                            values.add(vvv);
                        } else {
                            values = atype == 3 ? v2 : this.dcp.getValues(this.table, an);
                        }
                        for (int i2 = 0; i2 < values.size(); ++i2) {
                            String val = (String)values.get(i2);
                            if (flag == 0) {
                                newSubgroup = new Subgroup(this.targets);
                                newSubgroup.addConceptset(iSubgroup.getConceptset());
                                newSubgroup.addLinkset(iSubgroup.getLinkset());
                                if (iSubgroup.getConceptset().size() == 0) {
                                    newSubgroup.getConceptset().add(new Concept());
                                    Link l0 = new Link();
                                    if (this.theRelationGraph != null) {
                                        l0 = (Link)this.theRelationGraph.links.get(0);
                                    }
                                    newSubgroup.addLink(l0);
                                }
                                Selector selector = new Selector(an, val);
                                ((Concept)newSubgroup.getConceptset().get(0)).add(selector);
                                newSubgroup.setTarget(tselector);
                                sp = new SubgroupPair(iSubgroup, newSubgroup);
                            } else {
                                sp = (SubgroupPair)tempnewSubgroups.get(pos1);
                                ++pos1;
                                newSubgroup = sp.getSuccessor();
                            }
                            if (mean == 0) {
                                double subgroupSize = rs.getDouble(pos);
                                ++pos;
                                if (this.querytype != 4) {
                                    int tid = this.rootHypothesis.getTid(ctargetval);
                                    newSubgroup.setSubgroupSize(tid, subgroupSize);
                                } else if (flag == 0) {
                                    newSubgroup.setConceptSize(subgroupSize);
                                } else {
                                    newSubgroup.setSubgroupSize(0, subgroupSize);
                                    newSubgroup.setSubgroupSize(1, newSubgroup.getConceptSize() - subgroupSize);
                                }
                            } else {
                                double cs = rs.getDouble(pos);
                                newSubgroup.setConceptSize(cs);
                                ++pos;
                                double conf = 0.0;
                                if (cs > 0.0) {
                                    conf = rs.getDouble(pos) / cs;
                                }
                                ++pos;
                                newSubgroup.setConfidence(conf);
                                newSubgroup.calculateConceptShare(this.rootHypothesis);
                                newSubgroup.calculateQuality(this.rootHypothesis);
                            }
                            if (flag != 0) continue;
                            tempnewSubgroups.add(sp);
                        }
                    }
                    ++flag;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dbQueryPost(tempnewSubgroups, mean, newSubgroups);
    }

    protected void dbQuery(String query, Object link0, Object att0, int linkid, int conceptsetID, Subgroup iSubgroup, List newSubgroups) {
        Link link = new Link();
        String att = "";
        if (link0 != null) {
            link = (Link)link0;
            att = (String)att0;
        }
        String low = "low";
        String high = "high";
        Vector v2 = new Vector();
        v2.add(low);
        v2.add(high);
        Calendar ctime1 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime1.getTime())));
        Subgroup newSubgroup = new Subgroup(this.targets);
        SubgroupPair sp = new SubgroupPair();
        int mean = 0;
        String sl = this.targetValue;
        if (this.targetValue == "MEANPATTERN") {
            sl = "HIGH";
            mean = 1;
        }
        Selector tselector = new Selector(this.target, sl);
        ArrayList<SubgroupPair> tempnewSubgroups = new ArrayList<SubgroupPair>();
        ResultSet rs = this.db.select(query);
        Calendar ctime2 = Calendar.getInstance();
        System.out.println(String.valueOf("Time: ").concat(String.valueOf(ctime2.getTime())));
        Vector as = new Vector();
        String table1 = this.table;
        if (link0 == null) {
            as = this.attributeSpace;
        } else {
            as.add(att);
            table1 = link.getSuccessor().getName();
        }
        int alength = as.size();
        int flag = 0;
        int qit = 1;
        try {
            while (rs.next()) {
                int pos = 2;
                String ctargetval = rs.getString(1).trim();
                if (this.querytype == 4 && mean == 0 && ctargetval.equals("@")) {
                    qit = 2;
                }
                for (int it = 0; it < qit; ++it) {
                    int pos1 = 0;
                    for (int i = 0; i < alength; ++i) {
                        String an = (String)as.get(i);
                        Attribute a = new Attribute(an);
                        int atype = this.dcp.getType(table1, an);
                        if (atype == 0 || link0 == null && ((Concept)iSubgroup.getConceptset().get(0)).containsAttribute(a)) continue;
                        Vector values = atype == 3 ? v2 : this.dcp.getValues(table1, an);
                        for (int i2 = 0; i2 < values.size(); ++i2) {
                            String val = (String)values.get(i2);
                            if (flag == 0) {
                                ArrayList linklist;
                                newSubgroup = new Subgroup(this.targets);
                                newSubgroup.addConceptset(iSubgroup.getConceptset());
                                newSubgroup.addLinkset(iSubgroup.getLinkset());
                                int nel = conceptsetID - newSubgroup.getConceptset().size() + 1;
                                if (nel > 1) {
                                    newSubgroup.getConceptset().add(new Concept());
                                    if (this.theRelationGraph != null) {
                                        linklist = this.theRelationGraph.links;
                                        link = (Link)linklist.get(0);
                                        newSubgroup.addLink(link);
                                    }
                                }
                                if (nel > 0) {
                                    newSubgroup.getConceptset().add(new Concept());
                                    if (this.theRelationGraph != null) {
                                        linklist = this.theRelationGraph.links;
                                        for (int j1 = 0; j1 < linklist.size() && (link = (Link)linklist.get(j1)).getID() != linkid; ++j1) {
                                        }
                                        newSubgroup.addLink(link);
                                    } else {
                                        newSubgroup.addLink(new Link());
                                    }
                                }
                                Selector selector = new Selector(an, val);
                                ((Concept)newSubgroup.getConceptset().get(conceptsetID)).add(selector);
                                newSubgroup.setTarget(tselector);
                                sp = new SubgroupPair(iSubgroup, newSubgroup);
                            } else {
                                sp = (SubgroupPair)tempnewSubgroups.get(pos1);
                                ++pos1;
                                newSubgroup = sp.getSuccessor();
                            }
                            if (mean == 0) {
                                double subgroupSize = rs.getDouble(pos);
                                ++pos;
                                if (this.querytype != 4 || !ctargetval.equals("@")) {
                                    int tid = this.rootHypothesis.getTid(ctargetval);
                                    newSubgroup.setSubgroupSize(tid, subgroupSize);
                                } else if (flag == 0) {
                                    newSubgroup.setConceptSize(subgroupSize);
                                } else {
                                    newSubgroup.setSubgroupSize(0, subgroupSize);
                                    newSubgroup.setSubgroupSize(1, newSubgroup.getConceptSize() - subgroupSize);
                                }
                            } else {
                                double cs = rs.getDouble(pos);
                                newSubgroup.setConceptSize(cs);
                                ++pos;
                                double conf = 0.0;
                                if (cs > 0.0) {
                                    conf = rs.getDouble(pos) / cs;
                                }
                                ++pos;
                                newSubgroup.setConfidence(conf);
                                newSubgroup.calculateConceptShare(this.rootHypothesis);
                                newSubgroup.calculateQuality(this.rootHypothesis);
                            }
                            if (flag != 0) continue;
                            tempnewSubgroups.add(sp);
                        }
                    }
                    ++flag;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dbQueryPost(tempnewSubgroups, mean, newSubgroups);
    }

    protected void dbQueryPost(ArrayList tempnewSubgroups, int mean, List newSubgroups) {
        for (int i = 0; i < tempnewSubgroups.size(); ++i) {
            SubgroupPair sp = (SubgroupPair)tempnewSubgroups.get(i);
            if (newSubgroups.contains(sp)) continue;
            Subgroup subgroup = sp.getSuccessor();
            Subgroup parent = sp.getParent();
            if (mean == 0) {
                subgroup.calculateValues(this.rootHypothesis);
            }
            double q = sp.calculateQuality();
            System.out.println(String.valueOf(String.valueOf(" ").concat(String.valueOf(subgroup.toString()))).concat(String.valueOf(q)));
            if (this.getExtendedflag() == 0.0 && q <= this.getMinQualityI() || this.getExtendedflag() > 0.0 && q <= Math.min(this.getMinQualityI(), this.getMinQualImpExp()) || subgroup.getConceptShare() <= this.minSupport || subgroup.getConfidence() <= this.minConfidence || this.getExtendedflag() == 0.0 && subgroup.getQuality() <= this.getMinQuality() || this.getExtendedflag() > 0.0 && subgroup.getQuality() <= Math.min(this.getMinQuality(), this.getMinQualExp()) || mean == 0 && subgroup.getConfidence() > 0.95) continue;
            newSubgroups.add(sp);
            subgroup.setID(this.getNewId());
        }
    }

    public void setNumberHypotheses(int newNumberHypotheses) {
        this.numberHypotheses = newNumberHypotheses;
    }

    public int getNumberHypotheses() {
        return this.numberHypotheses;
    }

    public void setMinConfidence(double newMinConfidence) {
        this.minConfidence = newMinConfidence;
    }

    public double getMinConfidence() {
        return this.minConfidence;
    }

    public void setMinQuality(double newMinQuality) {
        this.minQuality = newMinQuality;
    }

    public double getMinQuality() {
        return this.minQuality;
    }

    public void setMinQualityI(double newMinQualityI) {
        this.minQualityI = newMinQualityI;
    }

    public double getMinQualityI() {
        return this.minQualityI;
    }

    public void setMinQualExp(double newMinQual) {
        this.minimumQualExp = newMinQual;
    }

    public double getMinQualExp() {
        return this.minimumQualExp;
    }

    public void setMinQualImpExp(double newMinQual) {
        this.minimumQualImpExp = newMinQual;
    }

    public double getMinQualImpExp() {
        return this.minimumQualImpExp;
    }

    public void setNumExp(int newNum) {
        this.numberExp = newNum;
    }

    public int getNumExp() {
        return this.numberExp;
    }

    public void setMinSim(double newSim) {
        this.minimumSim = newSim;
    }

    public double getMinSim() {
        return this.minimumSim;
    }

    public void setClusterflag(int newflag) {
        this.clusterflag = newflag;
    }

    public double getClusterflag() {
        return this.clusterflag;
    }

    public void setExtendedflag(int newflag) {
        this.extendedflag = newflag;
    }

    public double getExtendedflag() {
        return this.extendedflag;
    }

    public long getNewId() {
        ++this.subgroupId;
        return this.subgroupId;
    }

    public void setMinSupport(double newMinSupport) {
        this.minSupport = newMinSupport;
    }

    public double getMinSupport() {
        return this.minSupport;
    }

    public void setSearchDepth(int newSearchDepth) {
        this.searchDepth = newSearchDepth;
    }

    public void setCurrentDepth(int newCurrentDepth) {
        this.currentDepth = newCurrentDepth;
    }

    public int getSearchDepth() {
        return this.searchDepth;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public void setTable(String newTable) {
        this.table = newTable;
    }

    public String getTable() {
        return this.table;
    }

    public void setTargetValue(String tval) {
        this.targetValue = tval;
    }

    public void setAttributeSpace(Vector attributeSpace) {
        this.attributeSpace = attributeSpace;
    }

    public Vector getAttributeSpace() {
        return this.attributeSpace;
    }

    public HypothesisStore search() {
        this.init();
        for (int i = 0; i < this.searchDepth; ++i) {
            System.out.println(String.valueOf("SearchDepth: ").concat(String.valueOf(this.currentDepth)));
            ArrayList newHypotheses = this.expand(this.currentDepth);
            if (newHypotheses == null) break;
            if (i == this.searchDepth - 1) {
                this.laststep = 1;
            }
            this.organize(newHypotheses);
            if (this.expHypothesisList.size() == 0) break;
            ++this.currentDepth;
            this.laststep = 0;
        }
        this.resultArea.append(String.valueOf(this.bestHypothesisList.toString()).concat(String.valueOf("\n")));
        if (!this.standalone) {
            this.bestHypothesisList.addInstances1(this.theRelationGraph, this.dcp, this.table, this.id, this.db);
        }
        HypothesisStore bHL = (HypothesisStore)this.bestHypothesisList.clone();
        this.causalNet = new CausalNet(this.id, this.db, this.target, this.targetValue, this.targets, this.table, bHL, this.resultArea, this.rootHypothesis, this.populationSize, this.getMinSim(), this.theRelationGraph, this.dcp, this.twoKeyPlot);
        return this.bestHypothesisList;
    }

    public void setResultArea(JTextArea resultArea) {
        this.resultArea = resultArea;
    }
}

