/*
 * Decompiled with CFR 0.152.
 */
package subgroupmining;

import database.Database;
import de.dbo.jserver.subgroupmining.SubgroupMetadata;
import de.dbo.jserver.subgroupmining.object.db.TableAttributeValue;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Vector;
import subgroupmining.QueryConstructor;

public class AttributeMeta
implements Serializable {
    public String table;
    public String name;
    public boolean metaflag;
    public int type;
    public String average;
    public String variance;
    public float max;
    public float min;
    private int nr;
    private String[] v;
    private Vector d = null;
    private Vector dind = null;
    private int[] n;
    private SubgroupMetadata sM = null;

    public AttributeMeta(String name, String table, boolean metaflag) {
        this.name = name;
        this.table = table;
        this.metaflag = metaflag;
    }

    public int getNr() {
        return this.nr;
    }

    public Vector getCounts() {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < this.n.length; ++i) {
            v.add(new Integer(this.n[i]));
        }
        return v;
    }

    public int getCount(String val) {
        for (int i = 0; i < this.nr; ++i) {
            if (!this.v[i].equals(val)) continue;
            return this.n[i];
        }
        return -1;
    }

    public Vector getValues() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.nr; ++i) {
            v.add(this.v[i]);
        }
        return v;
    }

    public Vector getDisc() {
        return this.d;
    }

    public Vector getDiscInd() {
        return this.dind;
    }

    public void setDisc(Vector v, Vector w) {
        this.d = (Vector)v.clone();
        this.dind = (Vector)w.clone();
    }

    public void calculateMeta(Database db) {
        int limit = 50;
        this.type = this.calcType(db);
        if (this.type == 0) {
            return;
        }
        this.nr = this.calcNr(db);
        if (this.nr == 0) {
            return;
        }
        if (this.type == 1 && this.nr > limit) {
            this.type = 0;
        } else if (this.type == 2 && this.nr > limit) {
            this.type = 3;
            this.calcAV(db);
            if (this.nr < 101) {
                this.calcVal(db);
            }
        } else {
            this.calcVal(db);
        }
    }

    public int calcType(Database db) {
        int b = 0;
        if (this.metaflag) {
            try {
                SubgroupMetadata sM = db.getTableMetadata(this.table);
                b = sM.getType(this.name);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            if (b == 0) {
                return 1;
            }
            if (b == 1) {
                return 2;
            }
            return 0;
        }
        try {
            ResultSet rs = db.getMetaData().getColumns(null, null, this.table, null);
            while (rs.next()) {
                String a = rs.getString(4);
                String t = rs.getString(5);
                if (!a.equals(this.name)) continue;
                if (t.equals("1") || t.equals("12")) {
                    b = 1;
                    break;
                }
                if (!t.equals("3")) break;
                b = 2;
                break;
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public int calcNr(Database db) {
        int nr = 0;
        if (this.metaflag) {
            try {
                SubgroupMetadata sM = db.getTableMetadata(this.table);
                nr = sM.getNumberOfValues(this.name);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            return nr;
        }
        String query = QueryConstructor.makeNrQuery(this.name, this.table);
        ResultSet rs = db.select(query);
        try {
            while (rs.next()) {
                nr = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nr;
    }

    public void calcAV(Database db) {
        if (this.metaflag) {
            try {
                SubgroupMetadata sM = db.getTableMetadata(this.table);
                this.average = sM.getAverage(this.name).toString();
                this.variance = sM.getVariance(this.name).toString();
                this.min = sM.getMin(this.name).floatValue();
                this.max = sM.getMax(this.name).floatValue();
                if (this.nr < 101) {
                    return;
                }
                this.n = sM.getDiscr(this.name);
                return;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return;
            }
        }
        String query = QueryConstructor.makeAVQuery(this.name, this.table);
        ResultSet rs = db.select(query);
        try {
            while (rs.next()) {
                this.average = rs.getString(1);
                this.variance = rs.getString(2);
                this.max = rs.getFloat(3);
                this.min = rs.getFloat(4);
                System.out.println(String.valueOf(String.valueOf(String.valueOf("Max: ").concat(String.valueOf(this.max))).concat(String.valueOf(" Min: "))).concat(String.valueOf(this.min)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.nr < 101) {
            return;
        }
        query = QueryConstructor.makeDiscQuery(this.name, this.table, this.min, this.max);
        rs = db.select(query);
        this.n = new int[100];
        try {
            while (rs.next()) {
                this.n[0] = rs.getInt(1);
                int cs = this.n[0];
                System.out.println(String.valueOf("N1 :").concat(String.valueOf(this.n[0])));
                for (int i = 1; i < 100; ++i) {
                    this.n[i] = rs.getInt(i + 1) - cs;
                    cs += this.n[i];
                    System.out.println(String.valueOf("N:").concat(String.valueOf(this.n[i])));
                }
                System.out.println(String.valueOf("NT:").concat(String.valueOf(cs)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void calcVal(Database db) {
        this.v = new String[this.nr];
        this.n = new int[this.nr];
        int i = 0;
        if (this.metaflag) {
            try {
                SubgroupMetadata sM = db.getTableMetadata(this.table);
                TableAttributeValue[] tavArray = sM.getValue(this.name);
                int m = tavArray.length;
                for (int j = 0; j < m; ++j) {
                    int occur = tavArray[j].getOccurences().intValue();
                    String x = tavArray[j].getStringValue();
                    this.v[j] = x.trim();
                    this.n[j] = occur;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            return;
        }
        String query = QueryConstructor.makeValQuery(this.name, this.table);
        ResultSet rs = db.select(query);
        try {
            while (rs.next()) {
                this.v[i] = rs.getString(1).trim();
                this.n[i] = rs.getInt(2);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

