/*
 * Decompiled with CFR 0.152.
 */
package de.dbo.sm;

import de.dbo.sm.SourceDatabase;
import de.dbo.sm.SubgroupMiningParams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JTextArea;
import subgroupmining.DataChooserPanel;
import subgroupmining.HypothesisStore;
import subgroupmining.SearchManager;
import subgroupmining.visualization.TwoKeyPlot;

public class Start {
    public final SubgroupMiningParams params;
    public final SourceDatabase database;
    public HypothesisStore hypothesisStore;
    private final boolean dbg;
    private final File logFile;
    private PrintStream sysout = null;

    public Start(SourceDatabase database, SubgroupMiningParams params, boolean dbg) {
        this.params = params;
        this.database = database;
        this.logFile = this.getLogFile();
        this.dbg = dbg;
    }

    public Start(Connection conn, SubgroupMiningParams params, boolean dbg) {
        this.params = params;
        this.database = new SourceDatabase(conn);
        this.logFile = this.getLogFile();
        this.dbg = dbg;
    }

    private void redirectPrinting() {
        try {
            this.sysout = System.out;
            PrintStream file = new PrintStream(new FileOutputStream(this.logFile));
            System.setOut(file);
            if (!this.dbg) {
                System.out.close();
            }
        }
        catch (Throwable e) {
            System.err.println("ERROR: can't redirect output stream to a file");
            e.printStackTrace();
        }
    }

    private void setNormalPrinting() {
        System.out.flush();
        System.out.close();
        System.setOut(this.sysout);
        if (!this.dbg && this.logFile.exists()) {
            this.logFile.delete();
        }
    }

    public int doit() {
        this.redirectPrinting();
        int ret = this.doit_intern();
        this.setNormalPrinting();
        return ret;
    }

    private File getLogFile() {
        File ret;
        File dir = new File(String.valueOf("SubgroupMining").concat(String.valueOf(File.separator)));
        if (!dir.exists()) {
            try {
                if (dir.mkdir()) {
                    System.out.println("Directory for Subgroup-Mining created.");
                }
            }
            catch (Throwable e) {
                System.err.println("Can't create directory for Subgroup-Mining:\n");
                e.printStackTrace();
            }
        }
        if ((ret = new File(String.valueOf(String.valueOf("SubgroupMining").concat(String.valueOf(File.separator))).concat(String.valueOf("log")))).exists()) {
            ret.delete();
        } else {
            try {
                ret.createNewFile();
                System.out.println("Log file for Subgroup-Mining created.");
            }
            catch (Throwable e) {
                System.err.println("Can't create log file for Sungroup-Mining:\n");
                e.printStackTrace();
            }
        }
        return ret;
    }

    private int doit_intern() {
        SearchManager searchManager = new SearchManager(this.database.database, this.params.RELATION, this.params.ATTRIBUTE_SPACE, this.params.TARGET_ATTRIBUTE, 0, this.params.searchDepth, this.params.minSupport, this.params.minConfidence, 1.0, 1.0, this.params.numHypotheses, 0.0, 0.0, 30, 0.6666666666666666, 0, 0, new TwoKeyPlot());
        searchManager.theRelationGraph = null;
        searchManager.targetValue = this.params.TARGET_VALUE;
        searchManager.id = this.params.ID_ATTRIBUTE;
        JTextArea resultField = new JTextArea();
        searchManager.setResultArea(resultField);
        searchManager.dcp = new DataChooserPanel(this.database.database);
        this.hypothesisStore = searchManager.search();
        if (this.hypothesisStore == null) {
            System.out.println("ERROR in \"de.dbo.sm.Start\": NO RESULTS!");
            return -1;
        }
        if (this.hypothesisStore.size() == 0) {
            System.out.println("No intresting subgroups have been found.\nThe dataset does not contain any interesting subgroups. Try to change some parameters.");
            return 0;
        }
        System.out.println("Subgroup patterns have been generated.");
        System.out.println(String.valueOf(String.valueOf("The result has ").concat(String.valueOf(this.hypothesisStore.size()))).concat(String.valueOf(" items.")));
        if (this.params.ruleClusters) {
            int clusterCount = 0;
            while (clusterCount >= 0) {
                clusterCount = searchManager.causalNet.cluster(clusterCount);
            }
            System.out.println("Subgroup clusters have been generated.");
        }
        return 0;
    }

    public String getResultAsString() {
        return this.hypothesisStore.toString();
    }

    public ArrayList getResult() {
        return this.hypothesisStore;
    }
}

