/*
 * Decompiled with CFR 0.152.
 */
package de.dbo.sm;

import database.DBConnectionDescriptor;
import database.Database;
import java.sql.Connection;

public class SourceDatabase {
    public final Database database;
    private final DBConnectionDescriptor connectionDescriptor = new DBConnectionDescriptor();

    public SourceDatabase(String databaseType, String databaseDriver, String databaseUser, String databasePassword, String databaseUrl) {
        this.connectionDescriptor.setType(databaseType);
        this.connectionDescriptor.setDriver(databaseDriver);
        this.connectionDescriptor.setUser(databaseUser);
        this.connectionDescriptor.setPassword(databasePassword);
        this.connectionDescriptor.setHostString(databaseUrl);
        this.database = new Database(this.connectionDescriptor);
    }

    public SourceDatabase(String databaseUser, String databasePassword, String databaseUrl) {
        this("Oracle", "oracle.jdbc.driver.OracleDriver", databaseUser, databasePassword, databaseUrl);
    }

    public SourceDatabase(Connection conn) {
        try {
            this.connectionDescriptor.setType("Oracle");
            this.connectionDescriptor.setDriver("oracle.jdbc.driver.OracleDriver");
            this.connectionDescriptor.setUser(conn.getMetaData().getUserName());
            this.connectionDescriptor.setPassword(conn.getMetaData().getUserName());
            this.connectionDescriptor.setHostString(SourceDatabase.getKomishURL(conn.getMetaData().getURL()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("ERROR: cannot setup database in de.dbo.sm.SourceDatabase");
        }
        this.database = new Database(this.connectionDescriptor);
    }

    private static final String getKomishURL(String URL2) {
        return URL2.substring(URL2.indexOf("@") + 1);
    }
}

