/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBConnectDialog;
import database.DBDataSet;
import database.DataTableChooser;
import database.Database;
import java.io.File;
import java.sql.ResultSet;
import javax.swing.JDialog;

public class JDBCConnector
extends JDialog {
    private Database db;
    private File file;

    public JDBCConnector() {
        this.setModal(true);
        this.makeDBConnection();
        System.out.println("Quit JDBC Dialog ");
        if (this.getFile() != null) {
            System.out.println(this.getFile().toString());
        }
    }

    public static void main(String[] args) {
        new JDBCConnector();
    }

    protected void makeDBConnection() {
        DBConnectDialog dbc = new DBConnectDialog(null, "", true);
        dbc.setVisible(true);
        if (dbc.getDescriptor() != null) {
            this.db = new Database(dbc.getDescriptor());
            if (this.db.getConnection() != null) {
                this.file = this.selectTable();
            }
        }
    }

    protected File selectTable() {
        DataTableChooser dtc = new DataTableChooser(this.db);
        if (!dtc.getLoad().equals("")) {
            return this.submit(dtc.getSql(), dtc.getLoad());
        }
        return null;
    }

    private File submit(String sqlString, String tableName) {
        ResultSet rs = this.db.select(String.valueOf(sqlString).concat(String.valueOf(tableName)));
        return new DBDataSet(rs).transferToFile(this.getFileName(), tableName);
    }

    public File getFile() {
        return this.file;
    }

    private String getFileName() {
        return "file.pl";
    }

    private String getDirectory() {
        return "c:\\tmp\\";
    }
}

