/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBConnectionDescriptor;
import de.dbo.jserver.subgroupmining.SubgroupMetadata;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Database
implements Serializable {
    private transient SubgroupMetadata metadataDriver = null;
    private String theTable = null;
    public Map metaDataMap;
    private String user = "";
    public String host = "";
    protected String driver;
    protected Connection connection;
    protected DatabaseMetaData dbmd;
    protected Statement statement;

    public Database() {
    }

    public Database(Connection connection) {
        try {
            this.setConnection(connection);
            this.statement = connection.createStatement();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public void setHost(String hoststr) {
        this.host = hoststr;
    }

    public String getHost() {
        return this.host;
    }

    public Database(String driver) {
        this.setDriver(driver);
    }

    public Database(Connection connection, String driver) {
        this.setDriver(driver);
        try {
            this.setConnection(connection);
            this.statement = connection.createStatement();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public Database(DBConnectionDescriptor descriptor) {
        this.setDriver(descriptor.getDriver());
        this.user = descriptor.getUser();
        this.connect(descriptor.getUser(), descriptor.getPassword(), descriptor.getHostString(), descriptor.getType());
        if (this.connection != null) {
            this.setHost(descriptor.getHostString());
            this.metaDataMap = new HashMap();
        } else {
            this.setHost("");
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void closeStatement() {
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public ResultSet select(String SQL) {
        try {
            System.out.print(String.valueOf("Execute: ").concat(String.valueOf(SQL)));
            ResultSet resultSet = this.statement.executeQuery(SQL);
            System.out.println(" ...ok");
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (SQLException e) {
            System.out.println(" ...error");
            JOptionPane.showMessageDialog(null, e.getMessage());
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    public int update(String SQL) {
        int updated = 0;
        try {
            System.out.println(String.valueOf("SQL statement: ").concat(String.valueOf(SQL)));
            updated = this.statement.executeUpdate(SQL);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return updated;
    }

    public int delete(String SQL) {
        return this.update(SQL);
    }

    public int insert(String SQL) {
        return this.update(SQL);
    }

    public Connection connect(String name, String passwd, String host, String type) {
        if (type.equals("Oracle")) {
            return this.connect(String.valueOf("jdbc:oracle:thin:@").concat(String.valueOf(host)), name, passwd);
        }
        if (type.equals("ODBC")) {
            return this.connect(String.valueOf("jdbc:odbc:").concat(String.valueOf(host)), name, passwd);
        }
        if (type.equals("Sybase")) {
            return this.connect(String.valueOf("jdbc:sybase:Tds:").concat(String.valueOf(host)), name, passwd);
        }
        return null;
    }

    public Connection connect(String ConnectString, String user, String passwd) {
        this.user = user;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.valueOf("Driver class not found: ").concat(String.valueOf(this.driver)));
        }
        try {
            this.connection = DriverManager.getConnection(ConnectString, user, passwd);
            this.statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return this.connection;
    }

    public Connection connect(String ConnectString) {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.valueOf("Driver class not found: ").concat(String.valueOf(this.driver)));
        }
        try {
            this.connection = DriverManager.getConnection(ConnectString);
            this.statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        return this.connection;
    }

    public DatabaseMetaData getMetaData() {
        try {
            if (this.dbmd == null) {
                this.dbmd = this.connection.getMetaData();
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            DatabaseMetaData databaseMetaData = null;
            return databaseMetaData;
        }
        return this.dbmd;
    }

    public ResultSet getOraTables() {
        try {
            ResultSet resultSet;
            ResultSet resultSet2 = resultSet = this.connection.createStatement().executeQuery("select object_name from user_objects where (object_type LIKE '%TABLE%' or object_type like '%VIEW%') ");
            return resultSet2;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    public ResultSet getTables_COPY() {
        try {
            ResultSet resultSet;
            String[] types = new String[]{"TABLE", "VIEW"};
            ResultSet resultSet2 = resultSet = this.getMetaData().getTables(null, null, null, types);
            return resultSet2;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    public Properties getTableDescription(ResultSet rs) {
        Properties description = new Properties();
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columns = metaData.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                String name = metaData.getColumnName(i);
                String type = metaData.getColumnTypeName(i);
                description.put(name, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return description;
    }

    public static Vector result2Vector(ResultSet rs) {
        Vector table = new Vector();
        int i = 0;
        try {
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Vector<Object> row = new Vector<Object>(columns);
                for (i = 1; i <= columns; ++i) {
                    row.addElement(rs.getObject(i));
                }
                table.addElement(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    public void disconnect() {
        try {
            this.connection.close();
            System.out.println("Disconnected");
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    int delete(String table, String field, String condition) {
        int deleted = this.delete(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("delete from ").concat(String.valueOf(table))).concat(String.valueOf(" where "))).concat(String.valueOf(field))).concat(String.valueOf("='"))).concat(String.valueOf(condition))).concat(String.valueOf("'")));
        return deleted;
    }

    public SubgroupMetadata getTableMetadata(String table) {
        if (this.checkMetadata(table)) {
            return this.metadataDriver;
        }
        System.out.print(String.valueOf(String.valueOf("Opennnig metadata for table ").concat(String.valueOf(table))).concat(String.valueOf(" ... ")));
        try {
            this.metadataDriver = new SubgroupMetadata(this.connection, this.connection.getMetaData().getUserName(), table);
            System.out.println("DONE.");
        }
        catch (SQLException e) {
            System.err.println(String.valueOf("ERROR: can't open metadata for table ").concat(String.valueOf(table)));
            System.err.println(e.getMessage());
            this.metadataDriver = null;
        }
        this.theTable = table;
        return this.metadataDriver;
    }

    private final boolean checkMetadata(String table) {
        if (this.theTable != null && this.theTable.equals(table) && this.metadataDriver != null) {
            return true;
        }
        this.theTable = null;
        this.metadataDriver = null;
        return false;
    }
}

