/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Database;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataTableChooser
extends JDialog {
    JPanel panel1 = new JPanel();
    JList tableList = new JList();
    JList ignoreFieldList = new JList();
    JList addFieldList = new JList();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JToolBar jToolBar1 = new JToolBar();
    JButton loadButton = new JButton();
    JButton cancelButton = new JButton();
    JButton closeButton = new JButton();
    JButton Help = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel3 = new JLabel();
    JScrollPane sp1 = new JScrollPane(this.tableList);
    JScrollPane sp2 = new JScrollPane(this.ignoreFieldList);
    JScrollPane sp3 = new JScrollPane(this.addFieldList);
    Database db;
    DatabaseMetaData metaData;
    String load = "";
    String sql = "";
    Vector addColumnNames = new Vector();
    Vector ignoreColumnNames = new Vector();

    public DataTableChooser() {
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DataTableChooser(Database db) {
        this.db = db;
        this.setModal(true);
        Vector<String> tableModel = new Vector<String>();
        try {
            ResultSet rs = db.getOraTables();
            this.metaData = db.getConnection().getMetaData();
            while (rs.next()) {
                tableModel.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
        this.tableList.setListData(tableModel);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.tableList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tableList.setToolTipText("Tables in Database");
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataTableChooser.this.tableList_valueChanged(e);
            }
        });
        this.ignoreFieldList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.ignoreFieldList.setToolTipText("Fields to ignore from import");
        this.ignoreFieldList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataTableChooser.this.ignoreFieldList_mouseClicked(e);
            }
        });
        this.ignoreFieldList.setVisible(true);
        this.addFieldList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addFieldList.setToolTipText("Fields to include in import");
        this.addFieldList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataTableChooser.this.addFieldList_mouseClicked(e);
            }
        });
        this.addFieldList.setVisible(true);
        this.jLabel1.setText("Table");
        this.jLabel2.setText("Ignore Fields");
        this.loadButton.setToolTipText("Start import");
        this.loadButton.setMnemonic('L');
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableChooser.this.loadButton_actionPerformed(e);
            }
        });
        this.cancelButton.setToolTipText("Cancel loading");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableChooser.this.cancelButton_actionPerformed(e);
            }
        });
        this.cancelButton.setVisible(false);
        this.closeButton.setToolTipText("Close Dialog");
        this.closeButton.setMnemonic('S');
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableChooser.this.closeButton_actionPerformed(e);
            }
        });
        this.ignoreFieldList.setVisible(true);
        this.Help.setVisible(false);
        this.panel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Include fields");
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.sp1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.panel1.add((Component)this.sp2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.panel1.add((Component)this.sp3, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel1.add((Component)this.jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel1.add((Component)this.jToolBar1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jToolBar1.add((Component)this.loadButton, null);
        this.jToolBar1.add((Component)this.closeButton, null);
        this.panel1.add((Component)this.jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.pack();
        this.setVisible(true);
    }

    public String getLoad() {
        return this.load;
    }

    public String getSql() {
        return this.sql;
    }

    void loadButton_actionPerformed(ActionEvent e) {
        this.load = this.tableList.getSelectedValue().toString();
        StringBuffer sqlString = new StringBuffer("select ");
        if (this.ignoreColumnNames.size() == 0) {
            sqlString.append(" * ");
        } else {
            for (int i = 0; i < this.addColumnNames.size(); ++i) {
                sqlString.append(this.addColumnNames.elementAt(i));
                if (i >= this.addColumnNames.size() - 1) continue;
                sqlString.append(',');
            }
        }
        sqlString.append(" from ");
        this.sql = sqlString.toString();
        this.setVisible(false);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.load = "";
        this.setVisible(false);
        this.dispose();
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.load = "";
        this.setVisible(false);
        this.dispose();
    }

    void addFieldList_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.ignoreColumnNames.add(this.addFieldList.getSelectedValue());
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
            this.addColumnNames.remove(this.addFieldList.getSelectedIndex());
            this.addFieldList.setListData(this.addColumnNames);
            this.addFieldList.invalidate();
        }
    }

    void ignoreFieldList_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.addColumnNames.add(this.ignoreFieldList.getSelectedValue());
            this.addFieldList.setListData(this.addColumnNames);
            this.addFieldList.invalidate();
            this.ignoreColumnNames.remove(this.ignoreFieldList.getSelectedIndex());
            this.ignoreFieldList.setListData(this.ignoreColumnNames);
            this.ignoreFieldList.invalidate();
        }
    }

    void tableList_valueChanged(ListSelectionEvent e) {
        this.addColumnNames = new Vector();
        try {
            ResultSet meta = this.db.getMetaData().getColumns(null, null, this.tableList.getSelectedValue().toString(), null);
            while (meta.next()) {
                this.addColumnNames.add(meta.getString(4));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addFieldList.setListData(this.addColumnNames);
        this.addFieldList.invalidate();
        this.ignoreColumnNames = new Vector();
        this.ignoreFieldList.setListData(this.ignoreColumnNames);
        this.ignoreFieldList.invalidate();
    }
}

