/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import miningmart.storedProcedures.BusinessDbConnectionSource;

public class DbConnector {
    private static final boolean debugMessages = false;
    private final Connection con;

    public DbConnector(BusinessDbConnectionSource dbc) throws SQLException {
        try {
            this.con = dbc == null ? DriverManager.getConnection("jdbc:default:connection:") : dbc.getDatabaseConnectionForData();
        }
        catch (Exception e) {
            throw new SQLException("Exception in class miningmart.storedProcedures.DbConnector when trying to connect to DB: " + e.getMessage());
        }
        if (this.con == null) {
            throw new SQLException("Database connection failed!");
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    public void close() {
        Connection c = this.getConnection();
        try {
            if (c != null && !c.isClosed()) {
                c.commit();
                c.close();
            }
        }
        catch (SQLException e) {
            DbConnector.infoOutput("Closing Connection in class DbConnector failed:\n" + e);
        }
    }

    public static void infoOutput(String out) {
    }
}

