/*
 * Decompiled with CFR 0.152.
 */
package miningmart.storedProcedures;

import miningmart.storedProcedures.DataType;

class Attribute {
    private final String name;
    private final short dataType;
    private final short internalType;

    public Attribute(String name, short dataType, short internalType) {
        this.name = name;
        this.dataType = dataType;
        this.internalType = internalType;
    }

    public String getName() {
        return this.name;
    }

    public short getDataType() {
        return this.dataType;
    }

    public String getDataTypeName() {
        return DataType.getNameFor(this.dataType);
    }

    public boolean isConvertable() {
        return this.getConvertedInput() != null && this.getConvertedOutput("") != null;
    }

    public String getConvertedInput() {
        if (this.getDataType() == this.internalType) {
            if (this.getDataType() == 1) {
                return "to_char(" + this.getName() + ", 'DD.MM.YYYY HH24:MI:SS')";
            }
            return this.getName();
        }
        if (this.getDataType() == 1 && this.internalType == 0) {
            return "m4_date_to_timestamp(" + this.getName() + ")";
        }
        if (this.getDataType() == 0 && this.internalType == 1) {
            return "to_char(m4_timestamp_to_date(" + this.getName() + "), 'DD.MM.YYYY HH24:MI:SS')";
        }
        return null;
    }

    public String getConvertedOutput(String value) {
        if (value == null) {
            return "NULL";
        }
        if (this.getDataType() == this.internalType) {
            if (this.getDataType() == 1) {
                return "to_date('" + value + "', 'DD.MM.YYYY HH24:MI:SS')";
            }
            return value;
        }
        if (this.internalType == 0 && this.getDataType() == 1) {
            return "m4_timestamp_to_date(" + value + ")";
        }
        if (this.internalType == 1 && this.getDataType() == 0) {
            return "m4_date_to_timestamp(to_date('" + value + "', 'DD.MM.YYYY HH24:MI:SS'))";
        }
        return null;
    }

    public String getConvertedOutput(double value) {
        return this.getConvertedOutput(Double.toString(value));
    }

    public String getConvertedOutput(int value) {
        return this.getConvertedOutput(Integer.toString(value));
    }

    public String getConvertedOutput(long value) {
        return this.getConvertedOutput(Long.toString(value));
    }

    public String getConvertedOutput(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof String) {
            return this.getConvertedOutput((String)obj);
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return this.getConvertedOutput(d);
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return this.getConvertedOutput(i);
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return this.getConvertedOutput(l);
        }
        return null;
    }
}

