/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;

public class DbConfigEditorWindow
extends JFrame {
    private static final String[][] mapping;
    private final HashMap values;
    private final ActionListener saveAction;
    private JPanel panel;
    private JTextField[] theGuiValues;

    static {
        String[][] stringArrayArray = new String[9][];
        String[] stringArray = new String[3];
        stringArray[0] = "dbName";
        stringArray[1] = "Name of your database (SID):";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"jdbcDriver", "JDBC driver:", "jdbc:oracle:thin"};
        String[] stringArray2 = new String[3];
        stringArray2[0] = "dbHost";
        stringArray2[1] = "Host of your database:";
        stringArrayArray[2] = stringArray2;
        stringArrayArray[3] = new String[]{"dbPort", "Port of your database:", "1521"};
        String[] stringArray3 = new String[3];
        stringArray3[1] = "";
        stringArrayArray[4] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = "m4User";
        stringArray4[1] = "User of the M4 schema";
        stringArrayArray[5] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = "m4Pass";
        stringArray5[1] = "Password of the M4 schema";
        stringArrayArray[6] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = "busUser";
        stringArray6[1] = "User of business schema";
        stringArrayArray[7] = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[0] = "busPass";
        stringArray7[1] = "Password of the business schema";
        stringArrayArray[8] = stringArray7;
        mapping = stringArrayArray;
    }

    DbConfigEditorWindow(HashMap values, ActionListener saveAction) {
        this.values = values;
        this.saveAction = saveAction;
    }

    private String getValueFor(String variable) {
        return (String)this.values.get(variable);
    }

    private void setVariable(String variable, String value) {
        this.values.put(variable, value);
    }

    void prepareWindow() {
        if (this.panel == null) {
            this.panel = this.createMainPanel();
            this.getContentPane().add(this.panel);
        } else {
            this.setValues();
        }
        this.pack();
    }

    void saveButtonAction() {
        if (this.saveAction != null) {
            int i = 0;
            while (i < mapping.length) {
                String var = mapping[i][0];
                if (var != null) {
                    String value = this.theGuiValues[i].getText().trim();
                    this.values.put(var, value);
                }
                ++i;
            }
            this.saveAction.actionPerformed(null);
        }
        this.dispose();
        JOptionPane.showMessageDialog(Application.frame, "It is recommended to restart\nthe system after changing the\ndatabase settings!", "Please restart!", 1);
        this.cancelButtonAction();
    }

    void cancelButtonAction() {
        this.dispose();
        this.values.clear();
    }

    private JPanel createMainPanel() {
        int mappingLength = mapping.length;
        this.theGuiValues = new JTextField[mappingLength];
        JPanel theFields = new JPanel();
        JPanel theNames = new JPanel();
        JPanel theValues = new JPanel();
        theNames.setLayout(new GridLayout(mappingLength, 1));
        theValues.setLayout(new GridLayout(mappingLength, 1));
        int i = 0;
        while (i < mappingLength) {
            JTextField valueTa;
            String[] currentMapping = mapping[i];
            String name = currentMapping[1];
            if (currentMapping[0] != null) {
                JTextField nameTa = new JTextField(name);
                nameTa.setEditable(false);
                theNames.add(nameTa);
                String value = this.getValueFor(currentMapping[0]);
                if ((value == null || value.length() == 0) && (value = currentMapping[2]) == null) {
                    value = "";
                }
                valueTa = currentMapping[0].equals("m4Pass") || currentMapping[0].equals("busPass") ? new JPasswordField(value, 40) : new JTextField(value, 40);
                valueTa.setEditable(true);
                theValues.add(valueTa);
            } else {
                theNames.add(new JPanel());
                theValues.add(new JPanel());
                valueTa = new JTextField("", 40);
            }
            this.theGuiValues[i] = valueTa;
            ++i;
        }
        theFields.setLayout(new BorderLayout());
        theFields.add((Component)theNames, "West");
        theFields.add((Component)theValues, "Center");
        JPanel theButtons = new JPanel();
        theButtons.setLayout(new BorderLayout());
        JPanel center = new JPanel(new GridLayout(1, 2));
        JButton saveButton = new JButton("Continue");
        JButton cancelButton = new JButton("Cancel");
        center.add(saveButton);
        center.add(cancelButton);
        theButtons.add((Component)center, "Center");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditorWindow.this.saveButtonAction();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditorWindow.this.cancelButtonAction();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)theFields, "North");
        panel.add((Component)theButtons, "South");
        return panel;
    }

    private void setValues() {
        int i = 0;
        while (i < mapping.length) {
            String[] currentMapping = mapping[i];
            String varName = currentMapping[0];
            if (varName != null) {
                String value = this.getValueFor(varName);
                if ((value == null || value.length() == 0) && (value = currentMapping[2]) == null) {
                    value = "";
                }
                this.theGuiValues[i].setText(value);
            }
            ++i;
        }
    }
}

