/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import edu.udo.miningmart.db.ConfigReader;
import edu.udo.miningmart.m4.hciImpl.M4InterfaceImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import miningmart.hci.util.DbConfigEditorWindow;
import miningmart.m4.M4Interface;

public class DbConfigEditor {
    static final String VAR_DB_NAME = "dbName";
    static final String VAR_DB_HOST = "dbHost";
    static final String VAR_DB_PORT = "dbPort";
    static final String VAR_DB_DRIV = "jdbcDriver";
    static final String VAR_M4_USER = "m4User";
    static final String VAR_M4_PASS = "m4Pass";
    static final String VAR_BUS_USER = "busUser";
    static final String VAR_BUS_PASS = "busPass";
    String[] fileVars;
    private final HashMap values;
    private final File dbConfig;
    private final DbConfigEditorWindow frame;

    public DbConfigEditor() {
        String[] stringArray = new String[11];
        stringArray[0] = VAR_DB_NAME;
        stringArray[1] = VAR_M4_USER;
        stringArray[2] = VAR_M4_PASS;
        stringArray[3] = VAR_DB_DRIV;
        stringArray[4] = VAR_DB_HOST;
        stringArray[6] = VAR_DB_NAME;
        stringArray[7] = VAR_BUS_USER;
        stringArray[8] = VAR_BUS_PASS;
        stringArray[9] = VAR_DB_DRIV;
        stringArray[10] = VAR_DB_HOST;
        this.fileVars = stringArray;
        this.values = new HashMap();
        String dbcFileS = System.getProperty("DB_CONFIG_PATH");
        File f = null;
        if (dbcFileS != null && dbcFileS.length() > 0) {
            f = new File(dbcFileS);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    f = null;
                }
            } else if (!f.isFile()) {
                f = null;
            }
        }
        this.dbConfig = f;
        this.frame = new DbConfigEditorWindow(this.values, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbConfigEditor.this.save();
            }
        });
    }

    private String getValueFor(String variable) {
        return (String)this.values.get(variable);
    }

    private void setVariable(String variable, String value) {
        this.values.put(variable, value);
    }

    private void readValues() {
        try {
            this.readValuesFromFile();
            this.mapFileVariableToGui();
        }
        catch (IOException e) {
            System.err.println("IOException in DbConfigEditor:\n");
            e.printStackTrace();
        }
    }

    private void readValuesFromFile() throws IOException {
        block5: {
            ConfigReader cfr = null;
            try {
                cfr = new ConfigReader(this.dbConfig.getAbsolutePath());
                int i = 0;
                while (i < this.fileVars.length && cfr.hasMoreLines()) {
                    String line = cfr.getLine();
                    if (this.fileVars[i] != null && line != null && line.trim().length() > 0) {
                        this.setVariable(this.fileVars[i], line);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (cfr != null) {
                    cfr.close();
                }
                throw throwable;
            }
            Object var5_6 = null;
            if (cfr == null) break block5;
            cfr.close();
        }
    }

    private void mapFileVariableToGui() {
        String jdbcDriver;
        String hostAndPort = this.getValueFor(VAR_DB_HOST);
        if (hostAndPort != null && hostAndPort.length() > 0) {
            String port;
            String host;
            int index = hostAndPort.indexOf(":");
            if (index == -1) {
                host = hostAndPort;
                port = "";
            } else {
                host = hostAndPort.substring(0, index).trim();
                port = hostAndPort.substring(index + 1).trim();
            }
            if (host.startsWith("@")) {
                host = host.substring(1);
            }
            if (port.endsWith(":")) {
                port = port.substring(0, port.length() - 1);
            }
            this.setVariable(VAR_DB_HOST, host);
            this.setVariable(VAR_DB_PORT, port);
        }
        if ((jdbcDriver = this.getValueFor(VAR_DB_DRIV)) != null && jdbcDriver.endsWith(":")) {
            jdbcDriver = jdbcDriver.substring(0, jdbcDriver.length() - 1);
            this.setVariable(VAR_DB_DRIV, jdbcDriver);
        }
    }

    private void save() {
        M4InterfaceImpl m4i;
        this.dbConfig.delete();
        OutputStreamWriter out = null;
        try {
            try {
                this.dbConfig.createNewFile();
                out = new FileWriter(this.dbConfig);
                String[] lines = new String[this.fileVars.length];
                int i = 0;
                while (i < lines.length) {
                    String line = null;
                    if (this.fileVars[i] != null) {
                        line = this.getValueFor(this.fileVars[i]);
                    }
                    lines[i] = line == null ? "" : line;
                    ++i;
                }
                String host = lines[4].trim();
                String port = this.getValueFor(VAR_DB_PORT);
                if (!host.startsWith("@")) {
                    host = "@" + host;
                }
                if (port != null) {
                    host = (port = port.trim()).startsWith(":") ? String.valueOf(host) + port : String.valueOf(host) + ":" + port;
                }
                if (!host.endsWith(":")) {
                    host = String.valueOf(host) + ":";
                }
                lines[4] = host;
                lines[10] = host;
                String jdbcDriver = lines[3].trim();
                if (!jdbcDriver.endsWith(":")) {
                    jdbcDriver = String.valueOf(jdbcDriver) + ":";
                }
                lines[3] = jdbcDriver;
                lines[9] = jdbcDriver;
                int i2 = 0;
                while (i2 < lines.length) {
                    out.write(String.valueOf(lines[i2]) + "\n");
                    ++i2;
                }
            }
            catch (IOException e) {
                System.err.println("IOException in DbConfigEditor:\n");
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        Object var9_11 = null;
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if ((m4i = (M4InterfaceImpl)M4Interface.getInstance()) != null) {
            m4i.getNewDbConnection();
        }
    }

    public void init() {
        if (this.dbConfig == null) {
            System.err.println("Could not find db.config file. Please make sure the environment variable 'DB_CONFIG_PATH' is set and that the specified file is accessible.");
            return;
        }
        this.readValues();
        this.frame.prepareWindow();
        this.frame.show();
    }
}

