/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.util;

import edu.udo.miningmart.m4.hciImpl.CaseImpl;
import edu.udo.miningmart.m4.utils.M4Xml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import miningmart.hci.gui.main.Application;
import miningmart.m4.Case;

public class CaseExporter {
    Case caseToExport;
    Writer exportWriter;
    int retVal = 0;
    private boolean withColumns = false;
    private boolean noFile = true;

    public void init() {
        JFileChooser chooser = new JFileChooser(Application.systemHome);
        this.retVal = chooser.showSaveDialog(Application.frame);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        this.noFile = false;
        String filename = file.getPath();
        try {
            FileWriter f = new FileWriter(filename);
            this.exportWriter = new BufferedWriter(f);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            this.retVal = 2;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.retVal = 2;
        }
    }

    public int exportCase(Case caseToExport) {
        block3: {
            if (this.noFile) {
                return -1;
            }
            this.caseToExport = caseToExport;
            try {
                CaseImpl m4case = (CaseImpl)this.caseToExport;
                M4Xml.exportCase(m4case, this.exportWriter);
            }
            catch (IOException ioe) {
                int val = JOptionPane.showConfirmDialog(Application.frame, "Error while writing Object", "This may cause more errors\nor makes the file unusable.\nContinue anyway?", 2);
                ioe.printStackTrace();
                this.retVal = 2;
                if (val != 2) break block3;
                return 2;
            }
        }
        return this.retVal;
    }
}

