/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.timeSeries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.main.DataChooser;
import miningmart.hci.gui.util.ChangeInputConceptButton;
import miningmart.hci.gui.util.MmDataList;
import miningmart.hci.gui.util.RestrictedTextField;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.timeSeries.WindowingOperator;
import miningmart.m4.BaseAttribute;
import miningmart.m4.Concept;

public class WindowingOperatorView
extends MMStepView {
    JTextField inputConceptName = new JTextField("", 20);
    JTextField timeBaseAttrib = new JTextField("", 15);
    JTextField valueBaseAttrib = new JTextField("", 15);
    JTextField windowSize = new JTextField("", 5);
    JTextField distance = new JTextField("", 5);
    RestrictedTextField timeStart = new RestrictedTextField("", 10);
    RestrictedTextField timeEnd = new RestrictedTextField("", 10);
    MmDataList windowedValues = new MmDataList();
    RestrictedTextField outputConceptName = new RestrictedTextField("", 20);
    ChangeInputConceptButton changeConceptButton = new ChangeInputConceptButton("Change");
    JButton changeTBAButton = new JButton("Change");
    JButton changeVBAButton = new JButton("Change");
    private WindowingOperator op;
    private DataChooser chooser;

    public WindowingOperatorView(WindowingOperator op) {
        this.op = op;
        this.initControls();
        this.updateView();
    }

    public void initControls() {
        super.initControls(this.op.loopable);
        this.label = new JLabel("Inputs");
        this.insets = new Insets(0, 0, 10, 0);
        this.constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.inputConceptName.setEditable(false);
        this.inputConceptName.setBackground(Color.white);
        this.label = new JLabel("InputConcept", 2);
        this.label.setLabelFor(this.inputConceptName);
        this.insets = new Insets(0, 5, 5, 0);
        this.constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.inputConceptName, this.constraints);
        this.constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.changeConceptButton.addActionListener(this);
        this.panel.add((Component)this.changeConceptButton, this.constraints);
        this.timeBaseAttrib.setEditable(false);
        this.timeBaseAttrib.setBackground(Color.white);
        this.label = new JLabel("TimeBaseAttrib", 2);
        this.label.setLabelFor(this.timeBaseAttrib);
        this.constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeBaseAttrib, this.constraints);
        this.changeTBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeTBAButton, this.constraints);
        this.valueBaseAttrib.setEditable(false);
        this.valueBaseAttrib.setBackground(Color.white);
        this.label = new JLabel("ValueBaseAttrib", 2);
        this.label.setLabelFor(this.valueBaseAttrib);
        this.constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.valueBaseAttrib, this.constraints);
        this.changeVBAButton.addActionListener(this);
        this.constraints = new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.changeVBAButton, this.constraints);
        this.label = new JLabel("WindowSize", 2);
        this.label.setLabelFor(this.windowSize);
        this.constraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.windowSize, this.constraints);
        this.windowSize.addActionListener(this);
        this.windowSize.setToolTipText("Please approve your input by pressing <return>");
        this.label = new JLabel("Distance", 2);
        this.label.setLabelFor(this.distance);
        this.constraints = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.distance, this.constraints);
        this.label = new JLabel("Outputs");
        this.insets = new Insets(15, 0, 5, 0);
        this.constraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.insets = new Insets(0, 5, 5, 0);
        this.label = new JLabel("WindowedValues");
        this.label.setLabelFor(this.windowedValues);
        this.constraints = new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("TimeStart");
        this.label.setLabelFor(this.timeStart);
        this.constraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("TimeEnd");
        this.label.setLabelFor(this.timeEnd);
        this.constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.label = new JLabel("OutputConcept");
        this.label.setLabelFor(this.outputConceptName);
        this.constraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.label, this.constraints);
        this.constraints = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeStart, this.constraints);
        this.constraints = new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.timeEnd, this.constraints);
        this.constraints = new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.panel.add((Component)this.outputConceptName, this.constraints);
        this.scrollPane = new JScrollPane(this.windowedValues);
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        this.scrollPane.setMinimumSize(this.scrollPaneSize);
        this.constraints = new GridBagConstraints(3, 7, 1, 4, 0.0, 0.0, 17, 2, this.insets, 0, 0);
        this.panel.add((Component)this.scrollPane, this.constraints);
        boolean enable = !Application.mmWorkspace.isReadOnly();
        this.changeConceptButton.setEnabled(enable);
        this.changeTBAButton.setEnabled(enable);
        this.changeVBAButton.setEnabled(enable);
        this.outputConceptName.setEditable(enable);
        this.windowSize.setEditable(enable);
        this.distance.setEditable(enable);
        this.timeStart.setEditable(enable);
        this.timeEnd.setEditable(enable);
        if (!enable) {
            this.outputConceptName.setBackground(Color.white);
            this.windowSize.setBackground(Color.white);
            this.distance.setBackground(Color.white);
            this.timeStart.setBackground(Color.white);
            this.timeEnd.setBackground(Color.white);
        }
        this.panel.revalidate();
    }

    public void updateView() {
        super.updateView();
        if (this.op.theInputConcept != null) {
            this.inputConceptName.setText(this.op.theInputConcept.getName());
        } else {
            this.inputConceptName.setText("");
        }
        if (this.op.timeBaseAttrib != null) {
            this.timeBaseAttrib.setText(this.op.timeBaseAttrib.getName());
        } else {
            this.timeBaseAttrib.setText("");
        }
        if (this.op.valueBaseAttrib != null) {
            this.valueBaseAttrib.setText(this.op.valueBaseAttrib.getName());
        } else {
            this.valueBaseAttrib.setText("");
        }
        if (this.op.windowedValuesBaNames != null) {
            this.windowedValues.setListData(this.op.windowedValuesBaNames);
        }
        this.outputConceptName.setText(this.op.outputConceptName);
        this.windowSize.setText(this.op.windowSizeString);
        this.distance.setText(this.op.distanceString);
        this.timeStart.setText(this.op.timeStartString);
        this.timeEnd.setText(this.op.timeEndString);
    }

    public void actionPerformed(ActionEvent e) {
        String value;
        String size;
        BaseAttribute newAttrib;
        super.actionPerformed(e);
        if (e.getSource() == this.changeConceptButton) {
            this.chooser = new DataChooser(Application.frame, "Select new input concept", 1, Application.m4Case, true);
            this.chooser.setDepenceFromStep(this.op);
            Concept newConcept = (Concept)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.icChanged = newConcept != null && !newConcept.equals(this.op.theInputConcept);
            if (this.op.icChanged) {
                this.op.theInputConcept = newConcept;
            }
        } else if (e.getSource() == this.changeTBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select time stamp Base Attribute", 7, this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.tbChanged = newAttrib != null && !newAttrib.equals(this.timeBaseAttrib);
            if (this.op.tbChanged) {
                this.op.timeBaseAttrib = newAttrib;
            }
        } else if (e.getSource() == this.changeVBAButton) {
            if (this.op.theInputConcept == null) {
                JOptionPane.showMessageDialog(Application.frame, "No Input Concept selected!", "", 0);
                return;
            }
            this.chooser = new DataChooser(Application.frame, "Select value base Attribute", 8, this.op.theInputConcept, true);
            this.chooser.setDepenceFromStep(this.op);
            newAttrib = (BaseAttribute)this.chooser.showChooseSingleDialog();
            boolean bl = this.op.vbChanged = newAttrib != null && !newAttrib.equals(this.valueBaseAttrib);
            if (this.op.vbChanged) {
                this.op.valueBaseAttrib = newAttrib;
            }
        }
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            this.op.setParameter();
            Application.menuWindowClose.doClick();
        }
        if (!(size = this.windowSize.getText()).equals(this.op.windowSizeString) && this.testValueGE("Size", size, 1, 1.0)) {
            this.op.windowedValuesBaNames.removeAllElements();
            int ws = Integer.parseInt(size);
            int i = 1;
            while (i < ws + 1) {
                this.op.windowedValuesBaNames.addElement("WINDOW" + i);
                ++i;
            }
            this.op.windowSizeString = size;
            this.op.wsChanged = true;
        }
        if (!(value = this.distance.getText()).equals(this.op.distanceString) && this.testValueGE("Distance", value, 1, 1.0)) {
            this.op.distanceString = this.distance.getText();
            this.op.dChanged = true;
        }
        boolean bl = this.op.tsChanged = (!this.timeStart.getText().equals(this.op.timeStartString) || this.op.tsChanged) && this.timeStart.hasValidInput();
        if (this.op.tsChanged) {
            this.op.timeStartString = this.timeStart.getText();
        }
        boolean bl2 = this.op.teChanged = (!this.timeEnd.getText().equals(this.op.timeEndString) || this.op.teChanged) && this.timeEnd.hasValidInput();
        if (this.op.teChanged) {
            this.op.timeEndString = this.timeEnd.getText();
        }
        boolean bl3 = this.op.ocChanged = (!this.outputConceptName.getText().equals(this.op.outputConceptName) || this.op.ocChanged) && this.outputConceptName.hasValidInput();
        if (this.op.ocChanged) {
            this.op.outputConceptName = this.outputConceptName.getText();
        }
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }
}

