/*
 * Decompiled with CFR 0.152.
 */
package miningmart.hci.operators.genericOperator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import miningmart.hci.gui.main.Application;
import miningmart.hci.operators.MMStepView;
import miningmart.hci.operators.genericOperator.GenericOperator;
import miningmart.hci.operators.genericOperator.OperatorParam;

public class GenericOperatorView
extends MMStepView {
    GenericOperator op;
    JScrollPane scrollPane;
    JPanel paramPanel = new JPanel(new GridBagLayout());
    private Hashtable actualParams = null;

    public GenericOperatorView(GenericOperator genOperator) {
        this.op = genOperator;
        this.initControls();
        if (this.op.loopable) {
            this.loopPanel.init(this.op.stepLoopNr);
            this.loopPanel.addPropertyChangeListener(this);
        }
        this.updateView();
    }

    private void initControls() {
        super.initControls(this.op.loopable);
        this.panel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.paramPanel);
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.setPreferredSize(new Dimension(450, 300));
    }

    public void updateView() {
        super.updateView();
        Insets insets = new Insets(2, 0, 3, 0);
        int loopNr = this.getShownLoopNr();
        if (loopNr > 0) {
            --loopNr;
        }
        Hashtable params = (Hashtable)this.op.paramTables.get(loopNr);
        int paramNr = 0;
        if (!params.equals(this.actualParams)) {
            this.paramPanel.removeAll();
            Iterator it = params.values().iterator();
            while (it.hasNext()) {
                OperatorParam opParam = (OperatorParam)it.next();
                this.paramPanel.add((Component)opParam.getParameterView(), new GridBagConstraints(0, paramNr++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            }
        } else {
            Iterator it = params.values().iterator();
            while (it.hasNext()) {
                OperatorParam opParam = (OperatorParam)it.next();
                opParam.getParameterView().updateView();
            }
        }
        this.paramPanel.setSize(this.paramPanel.getHeight() + 1, this.paramPanel.getWidth() + 1);
        this.paramPanel.setSize(this.paramPanel.getHeight() - 1, this.paramPanel.getWidth() - 1);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.cancelButton) {
            this.op.setParameter();
            if (this.op.loopable) {
                this.loopPanel.init(this.op.stepLoopNr);
            }
            this.updateView();
            return;
        }
        if (e.getSource() == this.closeButton) {
            Application.menuWindowClose.doClick();
            return;
        }
        this.op.updateParamStrings(this.getShownLoopNr());
        if (e.getSource() == this.saveButton) {
            this.op.saveM4Object();
        }
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("loop_number")) {
            int newVal = (Integer)e.getNewValue();
            if (newVal == 0) {
                this.op.resizeParameterVector(1);
            } else {
                this.op.resizeParameterVector(newVal);
            }
            this.op.stepLoopNr = newVal;
            this.loopPanel.init(newVal);
            this.updateView();
            return;
        }
        if (e.getPropertyName().equals("loopToShow")) {
            this.op.updateParamStrings(this.getShownLoopNr());
            this.updateView();
        }
    }
}

