/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista.Sequence;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Step;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.ResultSet;
import miningmart.compiler.operator.ConceptOperator;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.operator.FeatureConstruction;
import miningmart.compiler.utils.DrawSample;
import miningmart.compiler.wrapper.dista.ColumnInfo;
import miningmart.compiler.wrapper.dista.DMException;
import miningmart.compiler.wrapper.dista.Sequence.CorrelResult;
import miningmart.compiler.wrapper.dista.Sequence.CorrelResult2PLSql;
import miningmart.compiler.wrapper.dista.Sequence.CorrelResultParser;
import miningmart.compiler.wrapper.dista.Wrapper;
import miningmart.compilerInterface.SystemPropertyInterface;

public class CorrelWrapper
extends Wrapper {
    protected String m_file_name;
    protected PrintWriter m_data;
    CorrelResult m_correl_result;
    private String sampleTableName;

    public CorrelWrapper(Step step, ExecutableOperator exOp) throws Exception {
        super(step, exOp);
    }

    public void checkMetaData() throws Exception {
        if (this.m_md.getColumnToLearn() != null) {
            throw new DMException("Sequence Correl is an unsupervised learningalgoritm.  It don't require a column to learn");
        }
        if (this.m_md.getColumnInfos().size() != 1) {
            throw new DMException("Sequence Correl require only one column");
        }
        ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(0);
        if (ci.getConceptType() != 4 && ci.getDataType() != 0) {
            throw new DMException("Sequence Correl  requite a column with a String oracol type and with a scalar concept type");
        }
    }

    protected String makeQuery() throws DMException, DbConnectionClosed, M4CompilerError {
        Columnset cs;
        Columnset tmp = null;
        Step theStep = this.getStep();
        if (theStep != null) {
            ExecutableOperator op = this.getExecutableOperator();
            Concept inputCon = null;
            if (op != null && op instanceof FeatureConstruction) {
                inputCon = ((FeatureConstruction)op).getTheInputConcept();
            } else if (op != null && op instanceof ConceptOperator) {
                inputCon = ((ConceptOperator)op).getInputConcept();
            }
            if (inputCon != null) {
                try {
                    tmp = inputCon == null ? null : inputCon.getCurrentColumnSet();
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerError("M4 interface error in CorrelWrapper: " + m4e.getMessage());
                }
            }
        }
        if ((cs = tmp) == null) {
            throw new DMException("Could not determine Columnset in class miningmart.compiler.wrapper.dista.CorrelWrapper!");
        }
        long stepId = this.getStep().getId();
        String sampleTableName = "SAMPLE_" + stepId;
        this.setSampleTableName(sampleTableName);
        String tempTableName = "TMP_" + stepId;
        try {
            new DrawSample(cs, null, sampleTableName, tempTableName, null, this.m_sample_size, null, this.getM4Db());
            this.getM4Db().addTableToTrash(this.getSampleTableName(), cs.getSchema(), stepId);
        }
        catch (M4CompilerError e) {
            throw new DMException(e.getMessage());
        }
        String query = "select ";
        ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(0);
        query = String.valueOf(query) + ci.getName();
        query = String.valueOf(query) + " from " + this.getSampleTableName() + " ";
        if (this.m_md.getColumnToLearn() != null) {
            query = String.valueOf(query) + "where " + this.m_md.getColumnToLearn().getName() + " is not null ";
        }
        return query;
    }

    protected void exportTable() throws Exception {
        String temporaryDir = SystemPropertyInterface.getProperty("TEMP_DIR");
        this.m_file_name = String.valueOf(temporaryDir) + File.separator + "seq_" + this.m_md.getTableName();
        BufferedWriter w = new BufferedWriter(new FileWriter(String.valueOf(this.m_file_name) + ".obj"));
        this.m_data = new PrintWriter(w);
        this.exportData();
        this.m_data.close();
        this.m_data = null;
    }

    protected void exportData() throws Exception {
        ResultSet res = null;
        try {
            res = this.getM4Db().executeBusinessSqlRead(this.makeQuery());
            int i = 0;
            while (res.next()) {
                this.m_data.print(i);
                this.m_data.print(" 1 0 ");
                this.m_data.print(res.getString(1));
                this.m_data.print("\n");
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DB.closeResultSet(res);
            throw throwable;
        }
        Object var4_5 = null;
        DB.closeResultSet(res);
    }

    protected void callTool() throws Exception {
        String temporaryDir = SystemPropertyInterface.getProperty("TEMP_DIR");
        this.callScript("cp " + this.m_ml_home + "/etc/correl_param.txt " + temporaryDir + File.separator + ".param");
        this.callScript("ftextract " + this.m_file_name + ".obj");
        this.callScript("seq_pattern2dlf " + this.m_file_name + ".obj.result " + this.m_file_name);
    }

    protected void clean() throws Exception {
        String temporaryDir = SystemPropertyInterface.getProperty("TEMP_DIR");
        if (temporaryDir == null || temporaryDir.trim().length() == 0) {
            return;
        }
        String s = File.separator;
        this.callScript("rm -f " + temporaryDir + s + ".list " + temporaryDir + s + ".param " + temporaryDir + s + "_listl " + temporaryDir + s + "*.str " + temporaryDir + s + "*.bpath " + temporaryDir + s + "*.cor " + temporaryDir + s + "*.fcor " + temporaryDir + s + "*.path " + temporaryDir + s + "*.sim " + temporaryDir + s + "_list " + temporaryDir + s + "_ll " + temporaryDir + s + "*.no " + temporaryDir + s + "*.tmpl ");
    }

    protected void importResult() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.m_file_name) + "_seq_pattern.dlf"));
        CorrelResultParser crp = new CorrelResultParser(r);
        this.m_correl_result = crp.parse();
    }

    protected void saveResult() throws Exception {
        CorrelResult2PLSql cr2sql = new CorrelResult2PLSql();
        cr2sql.setMetaData(this.m_md);
        cr2sql.setConnection(this.getM4Db());
        cr2sql.setResultName(this.m_result_name);
        cr2sql.convert(this.m_correl_result);
    }

    protected void setSampleTableName(String sampleTableName) {
        this.sampleTableName = sampleTableName;
    }

    protected String getSampleTableName() {
        return this.sampleTableName;
    }
}

