/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper.dista.MMS3;

import edu.udo.miningmart.m4.core.Step;
import java.io.BufferedReader;
import java.io.FileReader;
import miningmart.compiler.operator.ExecutableOperator;
import miningmart.compiler.wrapper.dista.C45.C45Wrapper;
import miningmart.compiler.wrapper.dista.ColumnInfo;
import miningmart.compiler.wrapper.dista.MMS3.Centers;
import miningmart.compiler.wrapper.dista.MMS3.Centers2PLSql;
import miningmart.compiler.wrapper.dista.MMS3.CentersParser;

public class MMS3Wrapper
extends C45Wrapper {
    protected Centers m_centers;
    protected int m_cluster_num = 5;
    protected boolean m_optimize_cluster_num = true;

    public MMS3Wrapper(Step step, ExecutableOperator exOp) throws Exception {
        super(step, exOp);
    }

    public void setClusterNum(int n) {
        this.m_cluster_num = n;
    }

    public int getClusterNum() {
        return this.m_cluster_num;
    }

    public void setOptimizeClusterNum(boolean v) {
        this.m_optimize_cluster_num = v;
    }

    public void checkMetaData() throws Exception {
        if (this.m_md.getColumnToLearn() != null) {
            throw new Exception("MMS3 is a supervised learning algoritm. It don't require a column to learn");
        }
        int i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(i);
            if (ci.getConceptType() == 3) {
                ci.setConceptType(1);
            }
            ++i;
        }
    }

    protected void callTool() throws Exception {
        if (this.m_optimize_cluster_num) {
            this.callScript("mms3 " + this.m_file_name + " kmax " + this.m_cluster_num);
        } else {
            this.callScript("mms3 " + this.m_file_name + " k " + this.m_cluster_num);
        }
    }

    protected void importResult() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.m_file_name) + "_mms3.dlf"));
        CentersParser tp = new CentersParser(r);
        this.m_centers = tp.parse();
        this.m_cluster_num = this.m_centers.getCenters().size();
    }

    protected void saveResult() throws Exception {
        Centers2PLSql t2sql = new Centers2PLSql();
        t2sql.setMetaData(this.m_md);
        t2sql.setConnection(this.getM4Db());
        t2sql.setResultName(this.m_result_name);
        t2sql.convert(this.m_centers);
    }
}

