/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.wrapper;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.utils.Print;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SVM_Wrapper {
    public static final long DEFAULTSAMPLESIZE = 10000L;
    protected static final String SAMPLE_TABLE_PREFIX = "tmp1_";
    protected static final String TEMP_TABLE_PREFIX = "tmp2_";
    protected long sampleSize;
    private final CompilerDatabaseService databaseObj;
    private final Print pr;
    private final String dbPrefix;
    protected final boolean useOracle;
    protected final boolean usePostgres;
    protected String lossPos;
    protected String lossNeg;
    protected String[][] symbolsForBooleanValues;
    protected Vector implementationalColumnTypes;
    private Vector theKernelParams;
    protected String targetColSQLDefinition;
    protected String schema;
    protected String inputTableName;
    protected long myStepId;
    protected String targetPositive = null;
    protected boolean forClassification;
    protected double b;
    protected double xiAlphaEstimation;
    protected int noSV;

    public SVM_Wrapper(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, long stepId) throws M4CompilerError {
        this.databaseObj = databaseObj;
        this.useOracle = this.databaseObj.getBusinessDbms() == 1;
        this.usePostgres = this.databaseObj.getBusinessDbms() == 2;
        this.pr = printObj;
        this.dbPrefix = nameForDatabaseUse;
        this.myStepId = stepId;
        this.xiAlphaEstimation = 0.0;
        if (this.getDatabaseObj() == null) {
            throw new M4CompilerError("Error in Support Vector Machine: got invalid db connection (null).");
        }
        this.lossPos = null;
        this.lossNeg = null;
    }

    public abstract void callSVM(Columnset var1, Column var2, long var3, String var5, String var6, String var7, Vector var8) throws M4CompilerError;

    public double getXiAlphaEstimation() {
        return this.xiAlphaEstimation;
    }

    public int getNumberOfSupportVectors() {
        return this.noSV;
    }

    protected abstract void extractXiAlpha() throws M4CompilerError;

    protected abstract void extractNumberSV() throws M4CompilerError;

    protected String[] checkForConversion(Columnset inputCS, Vector predictingColumns, Column targetColumn, Vector convertThisColumn) throws M4CompilerError {
        if (predictingColumns.isEmpty()) {
            throw new M4CompilerError("SVM wrapper: set of attributes to predict from is empty!");
        }
        int numberOfLearnAttribs = predictingColumns.size();
        Column[] allColumns = new Column[numberOfLearnAttribs + 1];
        int i = 0;
        while (i < predictingColumns.size()) {
            allColumns[i] = (Column)predictingColumns.get(i);
            ++i;
        }
        allColumns[numberOfLearnAttribs] = targetColumn;
        convertThisColumn.setSize(numberOfLearnAttribs + 1);
        this.implementationalColumnTypes = new Vector(numberOfLearnAttribs + 1);
        String[] stringsToSelectColumns = new String[numberOfLearnAttribs + 1];
        this.symbolsForBooleanValues = new String[2][numberOfLearnAttribs + 1];
        int i2 = 0;
        while (i2 < numberOfLearnAttribs + 1) {
            convertThisColumn.set(i2, null);
            this.implementationalColumnTypes.add(null);
            stringsToSelectColumns[i2] = null;
            this.symbolsForBooleanValues[0][i2] = "-1";
            this.symbolsForBooleanValues[1][i2] = "1";
            ++i2;
        }
        convertThisColumn.trimToSize();
        this.implementationalColumnTypes.trimToSize();
        this.checkColSetType(inputCS.getType());
        this.targetColSQLDefinition = targetColumn.getSQLDefinition();
        try {
            if (this.forClassification && !targetColumn.getTheBaseAttribute().getConceptualDataTypeName().equalsIgnoreCase("BINARY")) {
                throw new M4CompilerError("SVM wrapper: Error with target attribute: must be binary for SVM_CL!");
            }
            i2 = 0;
            while (i2 < allColumns.length) {
                String conceptualType = allColumns[i2].getTheBaseAttribute().getConceptualDataTypeName();
                String columnType = allColumns[i2].getColumnDataTypeName();
                if (conceptualType.equalsIgnoreCase("SCALAR") || conceptualType.equalsIgnoreCase("TIME") || conceptualType.equalsIgnoreCase("NUMERIC")) {
                    if (columnType.equalsIgnoreCase("DATE")) {
                        if (this.useOracle) {
                            stringsToSelectColumns[i2] = "to_number(to_char(" + allColumns[i2].getName() + ", 'J'))";
                        }
                        if (this.usePostgres) {
                            throw new M4CompilerError("SVM Wrapper: cannot handle columns of type DATE under Postgres; found column '" + allColumns[i2].getName() + "' of type DATE!");
                        }
                    } else {
                        stringsToSelectColumns[i2] = allColumns[i2].getName();
                    }
                    convertThisColumn.set(i2, null);
                    this.implementationalColumnTypes.set(i2, this.getDBMS_Datatype(columnType, allColumns[i2].getName()));
                } else if (conceptualType.equalsIgnoreCase("BINARY")) {
                    if (columnType.equalsIgnoreCase("VARCHAR")) {
                        convertThisColumn.set(i2, "" + allColumns[i2].getId());
                    } else {
                        convertThisColumn.set(i2, null);
                    }
                    stringsToSelectColumns[i2] = allColumns[i2].getName();
                    this.implementationalColumnTypes.set(i2, this.getDBMS_Datatype(columnType, allColumns[i2].getName()));
                } else {
                    return null;
                }
                ++i2;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in SVM Wrapper: " + m4e.getMessage());
        }
        return stringsToSelectColumns;
    }

    protected String getDBMS_Datatype(String m4ColumnDatatype, String columnName) throws M4CompilerError {
        if (m4ColumnDatatype.equals("STRING") && (this.useOracle || this.usePostgres)) {
            return "VARCHAR";
        }
        if (m4ColumnDatatype.equals("NUMBER")) {
            if (this.useOracle) {
                return "NUMBER";
            }
            if (this.usePostgres) {
                return "NUMERIC";
            }
        }
        if (m4ColumnDatatype.equals("DATE")) {
            if (this.useOracle) {
                return "DATE";
            }
            if (this.usePostgres) {
                throw new M4CompilerError("SVM_Wrapper.java#getDBMS_Datatype: can't support M4 column datatype 'DATE' under Postgres! Column: " + columnName);
            }
        }
        if (m4ColumnDatatype.equals("KEY")) {
            throw new M4CompilerError("SVM_Wrapper.java#getDBMS_Datatype(): found M4 column datatype 'KEY' for column '" + columnName + "'. Not supported.");
        }
        throw new M4CompilerError("SVM_Wrapper.java#getDBMS_Datatype(): found unknown M4 column datatype '" + m4ColumnDatatype + "'!");
    }

    protected String getSampleRatio(long maxSample, String tableName) throws M4CompilerError {
        if (maxSample <= 0L) {
            throw new M4CompilerError("Wrapper for SupportVectorMachine: Sample Size must be positive! Found: " + maxSample + ".");
        }
        String sql_getNumberOfRecords = "SELECT count(*) FROM " + tableName + " WHERE " + this.targetColSQLDefinition + " is not null";
        long count = 0L;
        try {
            Long countL = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(sql_getNumberOfRecords);
            if (countL == null) {
                throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords);
            }
            count = countL;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords + ", Database problem: " + sqle.getMessage());
        }
        if (maxSample > count) {
            maxSample = count;
        }
        double sampleRatio = (double)maxSample / (double)count;
        String integerSampleRatio = Double.toString(sampleRatio *= 1000000.0);
        if (integerSampleRatio.indexOf(".") > -1) {
            integerSampleRatio = integerSampleRatio.substring(0, integerSampleRatio.indexOf("."));
        }
        return integerSampleRatio;
    }

    protected void createDecisionFunctionAsSQL_Function(String kernelType, Vector colNamesPredictingAttribs, Vector columnsToConvert) throws M4CompilerError {
        String theFunction = this.createDecisionFunctionTemplate(colNamesPredictingAttribs, columnsToConvert);
        String declaration = this.createDeclaration(kernelType, colNamesPredictingAttribs);
        if (declaration == null) {
            throw new M4CompilerError("Error: null-declaration in SQL decision function; check kernel type!");
        }
        String body = this.createBody(kernelType, colNamesPredictingAttribs);
        if (body == null) {
            throw new M4CompilerError("Error trying to create body of SQL decision function; check kernel type!");
        }
        theFunction = this.replace(theFunction, "$DECLARATION", declaration);
        theFunction = this.replace(theFunction, "$BODY", body);
        this.insertFunctionIntoDB(theFunction);
    }

    protected String createDeclaration(String kernelType, Vector colNamesPredictingAttribs) throws M4CompilerError {
        int i;
        Vector colNamesInput = this.getColNamesInput(colNamesPredictingAttribs);
        String declaration = "";
        if (this.useOracle) {
            declaration = String.valueOf(declaration) + "    CURSOR supportvectors IS\n      SELECT ";
            i = 0;
            while (i < colNamesInput.size()) {
                declaration = String.valueOf(declaration) + (String)colNamesInput.get(i) + ", ";
                ++i;
            }
            declaration = String.valueOf(declaration) + "Alpha FROM " + this.getModelTablePlusCondition() + ";\n";
            declaration = String.valueOf(declaration) + "    currentrow supportvectors%ROWTYPE;\n";
        }
        if (this.usePostgres) {
            i = 0;
            while (i < colNamesInput.size()) {
                declaration = String.valueOf(declaration) + "    X_" + (String)colNamesPredictingAttribs.get(i) + " ALIAS FOR $" + i + ";\n";
                ++i;
            }
            declaration = String.valueOf(declaration) + "    currentrow " + this.getModelTableName() + "%ROWTYPE\n";
        }
        declaration = String.valueOf(declaration) + "    kernel " + this.getDBMS_Datatype("NUMBER", null) + ";\n";
        declaration = String.valueOf(declaration) + "    inner " + this.getDBMS_Datatype("NUMBER", null) + ";\n";
        return declaration;
    }

    protected String createBody(String kernelType, Vector colNamesPredictingAttribs) throws M4CompilerError {
        String body = null;
        String param1 = null;
        String param2 = null;
        int dimension = colNamesPredictingAttribs.size();
        if (kernelType.equalsIgnoreCase("dot") && this.theKernelParams != null || (kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("radial")) && this.theKernelParams.size() != 1 || (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) && this.theKernelParams.size() != 2) {
            throw new M4CompilerError("SVM Wrapper error: Found wrong number of kernel parameters!");
        }
        if (!kernelType.equalsIgnoreCase("dot")) {
            String params = (String)this.theKernelParams.get(0);
            StringTokenizer st = new StringTokenizer(params);
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            params = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            param1 = st.nextToken();
            try {
                Double.parseDouble(param1);
            }
            catch (NumberFormatException nfe) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            if (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) {
                params = (String)this.theKernelParams.get(1);
                st = new StringTokenizer(params);
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                params = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                param2 = st.nextToken();
                try {
                    Double.parseDouble(param2);
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
            }
        }
        String operator = null;
        Vector colNamesInput = this.getColNamesInput(colNamesPredictingAttribs);
        operator = kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("dot") ? " * " : " - ";
        body = "    retValue := 0;\n";
        if (this.useOracle) {
            body = String.valueOf(body) + "    FOR currentrow IN supportvectors\n    LOOP\n";
        }
        if (this.usePostgres) {
            body = String.valueOf(body) + "    FOR currentrow IN\n";
            body = String.valueOf(body) + "        SELECT ";
            int i = 0;
            while (i < colNamesInput.size()) {
                body = String.valueOf(body) + (String)colNamesInput.get(i) + ", ";
                ++i;
            }
            body = String.valueOf(body) + "Alpha\n";
            body = String.valueOf(body) + "        FROM " + this.getModelTablePlusCondition() + "\n";
            body = String.valueOf(body) + "    LOOP\n";
        }
        body = String.valueOf(body) + "      inner := ";
        String component = null;
        int i = 0;
        while (i < dimension) {
            component = !this.symbolsForBooleanValues[0][i].equals("-1") ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + ")" : (((String)this.implementationalColumnTypes.get(i)).equalsIgnoreCase("DATE") ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + i + ")" : "(currentrow." + (String)colNamesInput.get(i) + operator + "X_" + (String)colNamesPredictingAttribs.get(i) + ")");
            body = kernelType.equalsIgnoreCase("radial") ? String.valueOf(body) + component + " * " + component : (kernelType.equalsIgnoreCase("anova") ? String.valueOf(body) + "EXP( -" + param1 + " * " + component + ")" : String.valueOf(body) + component);
            if (i < dimension - 1) {
                body = String.valueOf(body) + "\n               + ";
            }
            ++i;
        }
        if (kernelType.equalsIgnoreCase("polynomial")) {
            body = String.valueOf(body) + ";\n      kernel := POWER(inner + 1, " + param1 + ") ";
        }
        if (kernelType.equalsIgnoreCase("neural")) {
            body = String.valueOf(body) + ";\n      kernel := TANH(inner * " + param1 + " + " + param2 + ") ";
        }
        if (kernelType.equalsIgnoreCase("dot")) {
            body = String.valueOf(body) + ";\n      kernel := inner ";
        }
        if (kernelType.equalsIgnoreCase("radial")) {
            body = String.valueOf(body) + ";\n      kernel := EXP( -(" + param1 + ") * inner) ";
        }
        if (kernelType.equalsIgnoreCase("anova")) {
            body = String.valueOf(body) + ";\n      kernel := POWER(inner, " + param2 + ") ";
        }
        body = String.valueOf(body) + "* currentrow.Alpha;\n";
        body = String.valueOf(body) + "      retValue := retValue + kernel;\n";
        body = String.valueOf(body) + "    END LOOP;\n";
        body = String.valueOf(body) + "    retValue := retValue + (" + this.b + ");\n";
        return body;
    }

    protected void insertFunctionIntoDB(String theFunction) throws M4CompilerError {
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            db.executeBusinessSqlWrite(theFunction);
            db.commitBusinessTransactions();
            if (this.useOracle) {
                db.addFunctionToTrash(this.getDecisionFunctionName(), this.schema, this.myStepId);
            }
            if (this.usePostgres) {
                db.addFunctionToTrash(this.getDecisionFunctionNameWithArgumentTypes(), this.schema, this.myStepId);
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM wrapper: Error trying to insert SQL result function into database: " + sqle.getMessage());
        }
    }

    protected String replace(String theString, String searchFor, String replaceBy) {
        int i = theString.indexOf(searchFor);
        String newString = "";
        int b = 0;
        while (i > -1) {
            newString = String.valueOf(newString) + theString.substring(b, i);
            newString = String.valueOf(newString) + replaceBy;
            b = i + searchFor.length();
            i = theString.indexOf(searchFor, b);
        }
        if (b < theString.length()) {
            newString = String.valueOf(newString) + theString.substring(b);
        }
        return newString;
    }

    protected String createDecisionFunctionTemplate(Vector colNamesPredictingAttribs, Vector columnsToConvert) throws M4CompilerError {
        int dimension = colNamesPredictingAttribs.size();
        if (columnsToConvert.size() != colNamesPredictingAttribs.size() + 1 || columnsToConvert.size() != this.implementationalColumnTypes.size()) {
            throw new M4CompilerError("Error: could not create decision function in SQL: parameter mismatch.");
        }
        String theFunction = "CREATE OR REPLACE function ";
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + this.getDecisionFunctionName();
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + this.getDecisionFunctionNameWithSchema();
        }
        theFunction = String.valueOf(theFunction) + "\n(\n";
        int i = 0;
        while (i < dimension) {
            if (this.useOracle) {
                theFunction = String.valueOf(theFunction) + "X_" + (String)colNamesPredictingAttribs.get(i) + " IN " + (String)this.implementationalColumnTypes.get(i);
            }
            if (this.usePostgres) {
                theFunction = String.valueOf(theFunction) + (String)this.implementationalColumnTypes.get(i);
            }
            if (i < dimension - 1) {
                theFunction = String.valueOf(theFunction) + ",\n";
            }
            ++i;
        }
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + "\n)\nRETURN NUMBER\nAS\nBEGIN\n";
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + "\n)\nRETURNS NUMERIC\nAS '\n";
        }
        String numbertype = this.getDBMS_Datatype("NUMBER", null);
        theFunction = String.valueOf(theFunction) + "  DECLARE\n";
        theFunction = String.valueOf(theFunction) + "    retValue " + numbertype + ";\n";
        int i2 = 0;
        while (i2 < dimension) {
            if (!this.symbolsForBooleanValues[0][i2].equals("-1")) {
                theFunction = String.valueOf(theFunction) + "    help" + i2 + " " + numbertype + ";\n";
            }
            if (((String)this.implementationalColumnTypes.get(i2)).equalsIgnoreCase("DATE")) {
                theFunction = String.valueOf(theFunction) + "    help" + i2 + i2 + " " + numbertype + ";\n";
            }
            ++i2;
        }
        theFunction = String.valueOf(theFunction) + "$DECLARATION\n";
        theFunction = String.valueOf(theFunction) + "  BEGIN\n";
        i2 = 0;
        while (i2 < dimension) {
            if (!this.symbolsForBooleanValues[0][i2].equals("-1")) {
                theFunction = String.valueOf(theFunction) + "    IF X_" + (String)colNamesPredictingAttribs.get(i2) + " = '" + this.symbolsForBooleanValues[0][i2] + "'\n" + "      THEN help" + i2 + " := -1;\n";
                theFunction = String.valueOf(theFunction) + "    ELSIF X_" + (String)colNamesPredictingAttribs.get(i2) + " = '" + this.symbolsForBooleanValues[1][i2] + "'\n" + "      THEN help" + i2 + " := 1;\n    END IF;\n";
            }
            if (((String)this.implementationalColumnTypes.get(i2)).equalsIgnoreCase("DATE")) {
                theFunction = String.valueOf(theFunction) + "    help" + i2 + i2 + " := to_number(to_char(X_" + (String)colNamesPredictingAttribs.get(i2) + ", 'J'));\n";
            }
            ++i2;
        }
        theFunction = String.valueOf(theFunction) + "\n$BODY\n";
        theFunction = this.forClassification ? String.valueOf(theFunction) + "    IF (retValue > 0)\n      THEN RETURN 1;\n    END IF;\n    RETURN -1;\n" : String.valueOf(theFunction) + "    RETURN retValue;\n";
        theFunction = String.valueOf(theFunction) + "  END;\n";
        if (this.useOracle) {
            theFunction = String.valueOf(theFunction) + "END;\n";
        }
        if (this.usePostgres) {
            theFunction = String.valueOf(theFunction) + "' LANGUAGE 'plpgsql';";
        }
        return theFunction;
    }

    protected String checkDouble(String test) throws M4CompilerError {
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = String.valueOf(pre) + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SVM wrapper: Error trying to convert '" + test + "' into double.");
        }
        return test;
    }

    protected void setPositiveTargetValue(String posValue) {
        this.targetPositive = posValue;
    }

    protected String getPositiveTargetValue() {
        return this.targetPositive;
    }

    protected abstract void checkKernel(String var1) throws M4CompilerError;

    protected abstract String getModelTablePlusCondition();

    protected abstract Vector getColNamesInput(Vector var1);

    protected abstract void checkColSetType(String var1) throws M4CompilerError;

    protected CompilerDatabaseService getDatabaseObj() {
        return this.databaseObj;
    }

    protected String getParTableName() {
        return String.valueOf(this.dbPrefix) + "_PAR";
    }

    protected String getLogTableName() {
        return String.valueOf(this.dbPrefix) + "_LOG";
    }

    protected String getOutputViewName() {
        return String.valueOf(this.dbPrefix) + "_OUT";
    }

    protected String getInputViewName() {
        return String.valueOf(this.dbPrefix) + "_IN";
    }

    protected String getModelTableName() {
        return String.valueOf(this.dbPrefix) + "_MOD";
    }

    public String getDecisionFunctionName() {
        return String.valueOf(this.dbPrefix) + "_F";
    }

    protected String getDecisionFunctionNameWithArgumentTypes() {
        String theName = String.valueOf(this.getDecisionFunctionName()) + "(";
        int i = 0;
        while (i < this.implementationalColumnTypes.size()) {
            theName = String.valueOf(theName) + (String)this.implementationalColumnTypes.get(i) + ",";
            ++i;
        }
        theName = String.valueOf(theName.substring(0, theName.length() - 2)) + ")";
        return theName;
    }

    public String getDecisionFunctionNameWithSchema() {
        return String.valueOf(this.schema) + "." + this.getDecisionFunctionName();
    }

    protected Print getPrint() {
        return this.pr;
    }

    protected Vector getKernelParams(String kern) {
        this.theKernelParams = new Vector();
        if (kern.toLowerCase().equals("dot")) {
            this.theKernelParams = null;
            return null;
        }
        if (kern.toLowerCase().equals("polynomial")) {
            this.theKernelParams.add("degree 2");
        }
        if (kern.toLowerCase().equals("neural")) {
            this.theKernelParams.add("a 0.5");
            this.theKernelParams.add("b 0.5");
        }
        if (kern.toLowerCase().equals("radial")) {
            this.theKernelParams.add("gamma 0.1");
        }
        if (kern.toLowerCase().equals("anova")) {
            this.theKernelParams.add("gamma 0.1");
            this.theKernelParams.add("degree 2");
        }
        this.theKernelParams.trimToSize();
        return this.theKernelParams;
    }
}

