/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.CompilerDatabaseService;
import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.DbConnectionClosed;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

abstract class Sampling {
    public static final long COMMIT_LIMIT = 10000L;
    private final Columnset sourceCs;
    private final String tempTable;
    private final Collection selectedColumns;
    private final long rowcount;
    private final Random random;
    private final CompilerDatabaseService db;

    protected Sampling(Columnset sourceCs, Collection selectedColumns, String tempTable, Long rowcount, Long seed, CompilerDatabaseService db) throws M4CompilerError {
        this.sourceCs = sourceCs;
        this.selectedColumns = selectedColumns;
        this.tempTable = tempTable;
        this.db = db;
        this.rowcount = Sampling.calculateRowCount(rowcount, this.sourceCs, this.db);
        this.random = seed == null ? new Random() : new Random(seed);
    }

    private static long calculateRowCount(Long rowcount, Columnset cs, DB db) throws M4CompilerError {
        block5: {
            try {
                long rc;
                if (rowcount != null) break block5;
                try {
                    rc = cs.getStatisticsAll();
                }
                catch (M4Exception e) {
                    throw new M4CompilerError("Could not load statistics:\n" + e.getMessage());
                }
                rowcount = rc != 0L ? new Long(rc) : db.executeBusinessSingleValueSqlReadL("SELECT COUNT(*) FROM " + cs.getName());
                if (rowcount == null) {
                    throw new M4CompilerError("Constructor of DrawSample: Could not determine number of rows for Columnset " + cs.getName());
                }
            }
            catch (SQLException e) {
                throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
            }
        }
        return rowcount;
    }

    public String getSourceAttributes() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column theCol = (Column)it.next();
                String colName = theCol.getName().toUpperCase();
                if (this.selectedColumns != null && !this.selectedColumns.contains(colName) || theCol.getTheBaseAttribute() == null) continue;
                sb.append(String.valueOf(colName) + ", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceAttributeDefinitions() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column theColumn = (Column)it.next();
                if (this.selectedColumns != null && !this.selectedColumns.contains(theColumn.getName().toUpperCase()) || theColumn.getTheBaseAttribute() == null) continue;
                String sql = theColumn.getSQLDefinition();
                String name = theColumn.getName();
                if (sql == null || sql.equals(name)) {
                    sb.append(name);
                } else {
                    sb.append("(" + sql + ") " + name);
                }
                sb.append(", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceTableName() {
        return this.sourceCs.getSchemaPlusName();
    }

    public Collection getSourceTableColumns() throws M4CompilerError {
        try {
            return this.sourceCs.getColumns();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getTempTableName() {
        return this.tempTable;
    }

    public long getRowCount() {
        return this.rowcount;
    }

    public double getNextRandomDouble() {
        return this.random.nextDouble();
    }

    protected void dbWrite(String sql) throws SQLException, DbConnectionClosed {
        this.db.executeBusinessSqlWrite(sql);
    }

    protected void deleteTable(String tableName) throws M4CompilerError {
        this.db.dropBusinessTable(tableName);
    }

    protected void commit() throws DbConnectionClosed, SQLException {
        this.db.commitBusinessTransactions();
    }
}

