/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Case;
import edu.udo.miningmart.m4.core.Chain;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Concept;
import edu.udo.miningmart.m4.core.Operator;
import edu.udo.miningmart.m4.core.Parameter;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Binarify {
    private final DB db;
    private final Case m4Case;
    private final Concept con;
    private final BaseAttribute ba;
    private final Chain chain;
    private final Columnset cs;
    private final Column col;
    private Step step;
    private Operator operator;
    private int numOfLoops;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public Binarify(Concept concept, BaseAttribute ba, Chain chain) throws M4Exception {
        if (concept == null || ba == null || chain == null) {
            throw new M4Exception("<null> argument found in constructor of miningmart.compiler.utils.Binarify!");
        }
        if (!concept.equals(ba.getTheConcept())) {
            throw new M4Exception("Constructor of miningmart.compiler.utils.Binarify:\nThe specified BaseAttribute does not belong to the specified Concept!");
        }
        this.db = concept.getM4Db();
        this.con = concept;
        this.ba = ba;
        this.chain = chain;
        this.m4Case = concept.getTheCase();
        if (this.m4Case == null || !this.m4Case.equals(chain.getTheCase())) {
            throw new M4Exception("Constructor of miningmart.compiler.utils.Binarify:\nConcept and Chain are not part of the same Case!");
        }
        Collection csCollection = this.con.getColumnSets();
        if (csCollection.size() != 1) {
            throw new M4Exception("Concept does not have exactly one Columnset, but " + csCollection.size() + "!");
        }
        this.cs = (Columnset)csCollection.iterator().next();
        if (this.cs == null) {
            throw new M4Exception("Concept has a null entry instead of the columnset!");
        }
        Collection colCollection = this.ba.getColumns();
        if (colCollection.size() != 1) {
            boolean exception = true;
            if (colCollection.size() > 1) {
                Iterator it = colCollection.iterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    if (col == null || !this.cs.equals(col.getColumnset())) continue;
                    System.out.println("WARNING: Binarify found multiple Columns, choosing the one linked to the found Columnset!");
                    colCollection.clear();
                    colCollection.add(col);
                    exception = false;
                    break;
                }
            }
            if (exception) {
                throw new M4Exception("BaseAttribute does not have exactly one Colum, but " + colCollection.size() + "!");
            }
        }
        this.col = (Column)colCollection.iterator().next();
        if (this.col == null) {
            throw new M4Exception("BaseAttribute has a null entry instead of the column!");
        }
    }

    private Collection createOutputBAs() throws SQLException, M4Exception, M4CompilerError {
        Vector<Object[]> newBaCollection = new Vector<Object[]>();
        String query = "SELECT DISTINCT " + this.col.getSQLDefinition() + " FROM " + this.cs.getSQLDefinition();
        String baNamePre = String.valueOf(this.ba.getName()) + "_";
        ResultSet rs = null;
        try {
            rs = this.db.executeBusinessSqlRead(query);
            while (rs.next()) {
                String value = rs.getString(1);
                if (rs.wasNull()) continue;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.udo.miningmart.m4.core.BaseAttribute");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                BaseAttribute newBa = (BaseAttribute)this.db.createNewInstance(clazz);
                newBa.setName(String.valueOf(baNamePre) + value);
                newBa.setConceptualDataTypeName("BINARY");
                newBa.setDBAttrib(false);
                newBa.setConcept(this.con);
                Object[] baData = new Object[]{value, newBa};
                newBaCollection.add(baData);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DB.closeResultSet(rs);
            throw throwable;
        }
        Object var9_10 = null;
        DB.closeResultSet(rs);
        System.out.println("Successfully created BaseAttributes for " + newBaCollection.size() + " values!");
        return newBaCollection;
    }

    private void createStep() throws M4Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.udo.miningmart.m4.core.Step");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Step newStep = (Step)this.db.createNewInstance(clazz);
        newStep.setTheCase(this.m4Case);
        newStep.setTheChain(this.chain);
        int stepNr = this.m4Case.getTheSteps().size() + 1;
        String stepName = String.valueOf(stepNr) + " BinarifyAttribute";
        newStep.setName(stepName);
        newStep.setNumber(stepNr);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("edu.udo.miningmart.m4.core.Operator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.operator = (Operator)this.db.getM4Object(104L, clazz2);
        if (this.operator == null || !this.operator.getName().equals("UserDefinedGroupingWithDefaultValue")) {
            throw new M4Exception("Binarify: Could not find operator 'UserDefinedGroupingWithDefaultValue', formerly known as the operator with ID 104!");
        }
        newStep.setTheOperator(this.operator);
        this.numOfLoops = 0;
        newStep.setLoopCount(this.numOfLoops);
        this.step = newStep;
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Parameter par = (Parameter)this.db.createNewInstance(clazz3);
        par.setName("TheInputConcept");
        par.setTheParameterObject(this.con);
        par.setIsInputParam(true);
        par.setTheOperator(this.operator);
        par.setTheStep(newStep);
    }

    private void createLoopForBa(BaseAttribute outputBa, String targetValS) throws M4Exception {
        long loopNr = ++this.numOfLoops;
        long parNr = 1L;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Parameter targetAttr = (Parameter)this.db.createNewInstance(clazz);
        targetAttr.setName("TheTargetAttribute" + loopNr);
        targetAttr.setTheParameterObject(this.ba);
        targetAttr.setTheOperator(this.operator);
        targetAttr.setIsInputParam(true);
        targetAttr.setParamNr(parNr++);
        targetAttr.setTheStep(this.step);
        targetAttr.setLoopNr((int)loopNr);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Parameter outAttr = (Parameter)this.db.createNewInstance(clazz2);
        outAttr.setName("TheOutputAttribute" + loopNr);
        outAttr.setTheParameterObject(outputBa);
        outAttr.setTheOperator(this.operator);
        outAttr.setIsInputParam(false);
        outAttr.setParamNr(parNr++);
        outAttr.setTheStep(this.step);
        outAttr.setLoopNr((int)loopNr);
        int numericConDT = 7;
        int stringConDT = 1;
        this.createInputValueParameter("TheGroupings", loopNr, targetValS, stringConDT, parNr++);
        this.createInputValueParameter("Labels", loopNr, "1", numericConDT, parNr++);
        this.createInputValueParameter("Default", loopNr, "0", numericConDT, parNr++);
    }

    private void updateLoopNr() {
        this.step.setLoopCount(this.numOfLoops);
    }

    private void createInputValueParameter(String parameterName, long loopNr, String value, int valCondDT, long parNr) throws M4Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("edu.udo.miningmart.m4.core.Value");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Value valueObj = (Value)this.db.createNewInstance(clazz);
        String valueName = String.valueOf(parameterName) + "_" + loopNr;
        valueObj.setName(valueName);
        valueObj.setType(valCondDT);
        valueObj.setValue(value);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("edu.udo.miningmart.m4.core.Parameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Parameter parameter = (Parameter)this.db.createNewInstance(clazz2);
        String parName = String.valueOf(parameterName) + loopNr;
        parameter.setName(parName);
        parameter.setTheStep(this.step);
        parameter.setTheParameterObject(valueObj);
        parameter.setTheOperator(this.operator);
        parameter.setIsInputParam(true);
        parameter.setParamNr(parNr);
        parameter.setLoopNr((int)loopNr);
    }

    private void commit() throws M4Exception {
        this.db.updateDatabase();
    }

    public void execute() throws Exception {
        Iterator it = this.createOutputBAs().iterator();
        this.createStep();
        while (it.hasNext()) {
            Object[] array = (Object[])it.next();
            String val = (String)array[0];
            BaseAttribute newBa = (BaseAttribute)array[1];
            this.createLoopForBa(newBa, val);
        }
        this.updateLoopNr();
        System.out.println("Committing changes to M4 database!");
        this.commit();
        System.out.println("Done.");
    }
}

