/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Feature;
import edu.udo.miningmart.m4.core.Value;
import java.util.ArrayList;
import miningmart.compiler.operator.FeatureSelection;

public abstract class UepFeatureSelection
extends FeatureSelection {
    protected Column theClassAttribute;
    Value[] ClassAttrEl;

    public BaseAttribute getTheClassAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute");
    }

    public Value getNoOfAttributes() {
        return (Value)this.getSingleParameter("NoOfAttributes");
    }

    protected myData selectTheBestAttr(ArrayList selected, ArrayList removed) throws M4CompilerError {
        Feature[] tmpF = new Feature[selected.size() + 1];
        int i = 0;
        while (i < selected.size()) {
            tmpF[i] = (Feature)selected.get(i);
            ++i;
        }
        double Max = -1.0;
        int MaxID = -1;
        int i2 = 0;
        while (i2 < removed.size()) {
            double MI;
            tmpF[tmpF.length - 1] = (Feature)removed.get(i2);
            try {
                MI = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
            }
            catch (M4Exception e) {
                throw new M4CompilerError("UepFeatureConstruction.selectTheBestAttr: " + e.getMessage());
            }
            if (MI > Max) {
                Max = MI;
                MaxID = i2;
            }
            ++i2;
        }
        return new myData(Max, MaxID);
    }

    protected myData selectTheWorstAttr(ArrayList selected) throws M4CompilerError {
        Feature[] tmpF = new Feature[selected.size() - 1];
        int i = 1;
        while (i < selected.size()) {
            tmpF[i - 1] = (Feature)selected.get(i);
            ++i;
        }
        try {
            double Max = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
            int MaxID = 0;
            int i2 = 0;
            while (i2 < selected.size() - 1) {
                tmpF[i2] = (Feature)selected.get(i2);
                double MI = this.getMutualInforation(new myTable(this.getM4Db().getFrquencyTable(this.theClassAttribute, tmpF, this.ClassAttrEl)));
                if (MI > Max) {
                    Max = MI;
                    MaxID = i2 + 1;
                }
                ++i2;
            }
            return new myData(Max, MaxID);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("UepFeatureConstruction.selectTheWorstAttr: " + e.getMessage());
        }
    }

    protected double getMutualInforation(myTable tbl) {
        int rs = tbl.Rows();
        int cs = tbl.Columns();
        double x = 0.0;
        int r = 0;
        while (r < rs - 1) {
            int c = 1;
            while (c < cs - 1) {
                if (tbl.Cell(r, c) > 0L) {
                    double t1 = (double)tbl.Cell(r, c) / (double)tbl.Cell(rs - 1, cs - 1);
                    double t2 = (double)tbl.Cell(rs - 1, cs - 1) * (double)tbl.Cell(r, c) / ((double)tbl.Cell(r, cs - 1) * (double)tbl.Cell(rs - 1, c));
                    double t3 = Math.log(t2);
                    x += t1 * t3;
                }
                ++c;
            }
            ++r;
        }
        return x;
    }

    protected class myTable {
        private ArrayList Rs = new ArrayList();
        private myColumn[] Cs;

        public myTable(long Columns) {
            this.Cs = new myColumn[(int)Columns];
        }

        myTable(Value[][] TableData) {
            this.Cs = new myColumn[TableData[0].length - 1];
            int i = 0;
            while (i < TableData.length) {
                long[] Vals = new long[TableData[0].length - 1];
                int n = 1;
                while (n < TableData[0].length) {
                    Vals[n - 1] = Long.parseLong(TableData[i][n].getValue());
                    ++n;
                }
                this.addRow(TableData[i][0].getValue(), Vals);
                ++i;
            }
        }

        public boolean addRow(String Name, long[] Values2) {
            if (Values2.length == this.Cs.length) {
                myRow row = new myRow(Name, Values2, this.Cs);
                this.Rs.add(row);
                int i = 0;
                while (i < this.Cs.length) {
                    myCell cell = row.cells[i];
                    this.Cs[i] = new myColumn();
                    this.Cs[i].cells.add(cell);
                    ++i;
                }
                return true;
            }
            return false;
        }

        public void print() {
            int i = 0;
            while (i < this.Rs.size()) {
                myRow row = (myRow)this.Rs.get(i);
                String s = row.name;
                int n = 0;
                while (n < row.cells.length) {
                    s = String.valueOf(s) + "\t" + row.cells[n].value;
                    ++n;
                }
                UepFeatureSelection.this.doPrint(100, s);
                ++i;
            }
        }

        public int Rows() {
            return this.Rs.size();
        }

        public int Columns() {
            return this.Cs.length;
        }

        public long Cell(int Row, int Column2) {
            return ((myRow)this.Rs.get((int)Row)).cells[Column2].value;
        }

        public long Cell(String Row, String Column2) {
            int i = 0;
            myRow row = (myRow)this.Rs.get(i);
            while (!row.equals(Row)) {
                row = (myRow)this.Rs.get(++i);
            }
            i = 0;
            while (!this.Cs[i].equals(Column2)) {
                ++i;
            }
            return row.cells[i].value;
        }

        private class myCell {
            myRow row;
            myColumn col;
            long value;

            myCell() {
            }
        }

        private class myRow {
            myCell[] cells;
            String name;

            myRow(String Name, long[] Values2, myColumn[] Cs) {
                this.name = Name;
                this.cells = new myCell[Values2.length];
                int i = 0;
                while (i < Values2.length) {
                    this.cells[i] = new myCell();
                    this.cells[i].row = this;
                    this.cells[i].col = Cs[i];
                    this.cells[i].value = Values2[i];
                    ++i;
                }
            }
        }

        private class myColumn {
            ArrayList cells = new ArrayList();
            String name;

            myColumn() {
            }
        }
    }

    protected class myData {
        public double MI;
        public int Index;

        public myData(double MutualInformation, int ID) {
            this.MI = MutualInformation;
            this.Index = ID;
        }
    }
}

