/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.uep.Discretization;

public class EquidistantDiscretizationGivenNoOfIntervals
extends Discretization {
    public Value getNoOfIntervals() {
        return (Value)this.getSingleParameter("NoOfIntervals", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        this.doPrint(12, "EquidistantDiscretizationGivenNoOfIntervals:");
        try {
            String Min = theTargetAttributeColumn.readOrComputeMinimum();
            double min = Double.parseDouble(Min);
            int numOfIntervals = Integer.parseInt(this.getNoOfIntervals().getValue());
            String Max = theTargetAttributeColumn.readOrComputeMaximum();
            double max = Double.parseDouble(Max);
            double width = (max - min) / (double)numOfIntervals;
            double[] cutPoints = new double[numOfIntervals - 1];
            int i = 1;
            while (i < numOfIntervals) {
                cutPoints[i - 1] = min + (double)i * width;
                ++i;
            }
            return cutPoints;
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    public String[] generateLabels(int num) {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(12, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        int i = 0;
        while (i < num) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
            ++i;
        }
        return labels;
    }
}

