/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Value;
import miningmart.compiler.operator.dista.DistaFeatureSelection;
import miningmart.compiler.operator.dista.FS;
import miningmart.compiler.operator.dista.SGFS;

public class SGFeatureSelection
extends DistaFeatureSelection {
    private SGFS mySGFSWrapper;
    protected BaseAttribute theTargetAttribute;
    protected Value popDim;
    protected Value stepNum;
    protected Value probMut;
    protected Value probCross;
    protected Value threshold;

    protected void initialiseWrapper() throws M4CompilerError {
        try {
            this.mySGFSWrapper = new SGFS(this.getM4Db(), this.getStep(), this);
        }
        catch (Exception e) {
            throw new M4CompilerError("SGFeatureSelection: error initialising wrapper: " + e.getMessage());
        }
    }

    protected void callWrapper(BaseAttribute[] featuresToSelectFrom) throws M4CompilerError {
        try {
            this.mySGFSWrapper.call(this.getInputConcept(), featuresToSelectFrom, this.theTargetAttribute.getCurrentColumn(), this.sampleSize);
        }
        catch (Exception e) {
            throw new M4CompilerError("Error excecuting SGFS Wrapper: " + e.getMessage());
        }
    }

    protected FS getWrapper() throws M4CompilerError {
        return this.mySGFSWrapper;
    }

    protected void loadParameters() throws M4CompilerError {
        this.theTargetAttribute = (BaseAttribute)this.getSingleParameter("TheTargetAttribute");
        this.popDim = (Value)this.getSingleParameter("PopDim");
        this.stepNum = (Value)this.getSingleParameter("StepNum");
        this.probMut = (Value)this.getSingleParameter("ProbMut");
        this.probCross = (Value)this.getSingleParameter("ProbCross");
        this.threshold = (Value)this.getSingleParameter("Threshold");
        try {
            this.mySGFSWrapper.m_pop_size = (int)Long.parseLong(this.popDim.getValue());
            this.mySGFSWrapper.m_gen_num = (int)Long.parseLong(this.stepNum.getValue());
            this.mySGFSWrapper.m_prob_mut = Double.parseDouble(this.probMut.getValue());
            this.mySGFSWrapper.m_prob_cross = Double.parseDouble(this.probCross.getValue());
            this.mySGFSWrapper.m_threshold = Double.parseDouble(this.threshold.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SGFS: A parameter was not or wrongly specified: " + nfe.getMessage());
        }
    }
}

