/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import edu.udo.miningmart.db.DB;
import edu.udo.miningmart.exception.M4CompilerError;
import edu.udo.miningmart.exception.M4Exception;
import edu.udo.miningmart.m4.core.BaseAttribute;
import edu.udo.miningmart.m4.core.Column;
import edu.udo.miningmart.m4.core.Columnset;
import edu.udo.miningmart.m4.core.Step;
import edu.udo.miningmart.m4.core.Value;
import java.sql.SQLException;
import miningmart.compiler.operator.TimeOperator;
import miningmart.storedProcedures.TimeOperatorException;
import miningmart.storedProcedures.ToWindow;

public class Windowing
extends TimeOperator {
    private static final String TIMEBASEATTRIB = "TimeBaseAttrib";
    private static final String VALUEBASEATTRIB = "ValueBaseAttrib";
    private static final String WINDOWSIZE = "WindowSize";
    private static final String DISTANCE = "Distance";
    private static final String OUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTTIMEENDBA = "OutputTimeEndBA";
    private static final String WINDOWEDVALUESBA = "WindowedValuesBA";
    private static final String procedureName = "dbWindow";
    private static final String columnSetSuffix = "_CS";
    private static final String VALNAME_SEPARATOR = "_";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBA() {
        return (BaseAttribute)this.getSingleParameter(TIMEBASEATTRIB);
    }

    public BaseAttribute getValueBA() {
        return (BaseAttribute)this.getSingleParameter(VALUEBASEATTRIB);
    }

    public Value getWinSize() {
        return (Value)this.getSingleParameter(WINDOWSIZE);
    }

    public Value getDistance() {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    public BaseAttribute getOutStartTimeBA() {
        return (BaseAttribute)this.getSingleParameter(OUTTIMESTARTBA);
    }

    public BaseAttribute getOutEndTimeBA() {
        return (BaseAttribute)this.getSingleParameter(OUTTIMEENDBA);
    }

    private BaseAttribute[] getWindowedValuesBA() {
        return (BaseAttribute[])this.getParameter(WINDOWEDVALUESBA);
    }

    public BaseAttribute getWindowedValueBA(int i) {
        BaseAttribute[] windowedValues = this.getWindowedValuesBA();
        if (windowedValues != null && i < windowedValues.length && i >= 0) {
            return windowedValues[i];
        }
        return null;
    }

    public int getNumberOfWindowedValuesBAs() {
        BaseAttribute[] windowedValues = this.getWindowedValuesBA();
        if (windowedValues != null) {
            return windowedValues.length;
        }
        return 0;
    }

    protected void createJavaColumns(Columnset newColumnSet) throws M4CompilerError {
        this.createWindowedColumns(newColumnSet);
        this.linkOutputTimeBAs(newColumnSet);
    }

    private void createWindowedColumns(Columnset newCS) throws M4CompilerError {
        try {
            Column columnForType = this.getValueBA().getColumn(0);
            int winsize = this.getNumberOfWindowedValuesBAs();
            int i = 0;
            while (i < winsize) {
                this.createM4Column(this.getWindowedValueBA(i), newCS, columnForType);
                ++i;
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void linkOutputTimeBAs(Columnset newCS) throws M4CompilerError {
        try {
            Column columnForType = this.getTimeBA().getColumn(0);
            this.createM4Column(this.getOutStartTimeBA(), newCS, columnForType);
            this.createM4Column(this.getOutEndTimeBA(), newCS, columnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        Step st = this.getStep();
        this.valueIsLong(this.getWinSize(), WINDOWSIZE);
        this.valueIsLong(this.getDistance(), DISTANCE);
        this.baseattribHasColumns(this.getTimeBA(), TIMEBASEATTRIB);
        this.baseattribHasColumns(this.getValueBA(), VALUEBASEATTRIB);
        if (this.getNumberOfWindowedValuesBAs() != this.getWinSize().getLong().intValue()) {
            throw new M4CompilerError("Array of BaseAttributes 'WindowedValuesBA' of step " + st.getId() + " does not match the windowsize (parameter name: '" + WINDOWSIZE + "')!");
        }
        String[] parameters = new String[]{TimeOperator.getQuotedColSetNameforCon(this.getInputConcept()), TimeOperator.getQuotedColNameforInpBA(this.getTimeBA()), TimeOperator.getQuotedColNameforInpBA(this.getValueBA()), DB.quote(newColumnsetName), TimeOperator.getQuotedColNameforOutBA(this.getOutStartTimeBA()), TimeOperator.getQuotedColNameforOutBA(this.getOutEndTimeBA()), DB.quote(this.createWindowedColsString()), TimeOperator.getUnquotedIntFromValue(this.getDistance())};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            ToWindow.dbWindow(this.getM4Db(), TimeOperator.unquote(parameters[0]), TimeOperator.unquote(parameters[1]), TimeOperator.unquote(parameters[2]), TimeOperator.unquote(parameters[3]), TimeOperator.unquote(parameters[4]), TimeOperator.unquote(parameters[5]), TimeOperator.unquote(parameters[6]), Integer.parseInt(parameters[7]));
        }
    }

    private String createWindowedColsString() {
        String r = "";
        int winsize = this.getNumberOfWindowedValuesBAs();
        int i = 0;
        while (i < winsize) {
            r = String.valueOf(r) + this.getWindowedValueBA(i).getName() + " ";
            ++i;
        }
        return r;
    }
}

